/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.HttpMethods;
import org.apache.camel.component.http4.HttpOperationFailedException;
import org.apache.camel.component.http4.helper.GZIPHelper;
import org.apache.camel.component.http4.helper.HttpProducerHelper;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProducer
extends DefaultProducer {
    private static final transient Log LOG = LogFactory.getLog(HttpProducer.class);
    private HttpClient httpClient;
    private boolean throwException;

    public HttpProducer(HttpEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.httpClient = endpoint.getHttpClient();
        this.throwException = endpoint.isThrowExceptionOnFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
        }
        HttpRequestBase httpRequest = this.createMethod(exchange);
        Message in = exchange.getIn();
        HeaderFilterStrategy strategy = this.getEndpoint().getHeaderFilterStrategy();
        for (Map.Entry entry : in.getHeaders().entrySet()) {
            String headerValue = (String)in.getHeader((String)entry.getKey(), String.class);
            if (strategy == null || strategy.applyFilterToCamelHeaders((String)entry.getKey(), (Object)headerValue, exchange)) continue;
            httpRequest.addHeader((String)entry.getKey(), headerValue);
        }
        HttpResponse httpResponse = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Executing http " + httpRequest.getMethod() + " method: " + httpRequest.getURI().toString()));
            }
            httpResponse = this.executeMethod((HttpUriRequest)httpRequest);
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Http responseCode: " + responseCode));
            }
            if (this.throwException && (responseCode < 100 || responseCode >= 300)) {
                throw this.populateHttpOperationFailedException(exchange, httpRequest, httpResponse, responseCode);
            }
            this.populateResponse(exchange, httpRequest, httpResponse, in, strategy, responseCode);
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                try {
                    httpResponse.getEntity().consumeContent();
                }
                catch (IOException e) {}
            }
        }
    }

    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    protected void populateResponse(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, Message in, HeaderFilterStrategy strategy, int responseCode) throws IOException {
        Header[] headers;
        Message answer = exchange.getOut();
        answer.setHeaders(in.getHeaders());
        answer.setHeader("CamelHttpResponseCode", (Object)responseCode);
        answer.setBody((Object)HttpProducer.extractResponseBody(httpRequest, httpResponse, exchange));
        for (Header header : headers = httpResponse.getAllHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (name.toLowerCase().equals("content-type")) {
                name = "Content-Type";
            }
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
            answer.setHeader(name, (Object)value);
        }
    }

    protected HttpOperationFailedException populateHttpOperationFailedException(Exchange exchange, HttpRequestBase httpRequest, HttpResponse httpResponse, int responseCode) throws IOException {
        Header locationHeader;
        String uri = httpRequest.getURI().toString();
        String statusText = httpResponse.getStatusLine() != null ? httpResponse.getStatusLine().getReasonPhrase() : null;
        Map<String, String> headers = HttpProducer.extractResponseHeaders(httpResponse.getAllHeaders());
        InputStream is = HttpProducer.extractResponseBody(httpRequest, httpResponse, exchange);
        String copy = null;
        if (is != null) {
            copy = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)is);
        }
        HttpOperationFailedException exception = (locationHeader = httpResponse.getFirstHeader("location")) != null && responseCode >= 300 && responseCode < 400 ? new HttpOperationFailedException(uri, responseCode, statusText, locationHeader.getValue(), headers, copy) : new HttpOperationFailedException(uri, responseCode, statusText, null, headers, copy);
        return exception;
    }

    protected HttpResponse executeMethod(HttpUriRequest httpRequest) throws IOException {
        return this.httpClient.execute(httpRequest);
    }

    protected static Map<String, String> extractResponseHeaders(Header[] responseHeaders) {
        if (responseHeaders == null || responseHeaders.length == 0) {
            return null;
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        for (Header header : responseHeaders) {
            answer.put(header.getName(), header.getValue());
        }
        return answer;
    }

    protected static InputStream extractResponseBody(HttpRequestBase httpRequest, HttpResponse httpResponse, Exchange exchange) throws IOException {
        String contentType;
        int index;
        String contentEncoding;
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        if (is == null) {
            return null;
        }
        Header header = httpRequest.getFirstHeader("Content-Encoding");
        String string = contentEncoding = header != null ? header.getValue() : null;
        if (!((Boolean)exchange.getProperty("CamelSkipGzipEncoding", (Object)Boolean.FALSE, Boolean.class)).booleanValue()) {
            is = GZIPHelper.uncompressGzip(contentEncoding, is);
        }
        if ((header = httpRequest.getFirstHeader("content-type")) != null && (index = (contentType = header.getValue()).indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            exchange.setProperty("CamelCharsetName", (Object)charset);
        }
        return HttpProducer.doExtractResponseBody(is, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream doExtractResponseBody(InputStream is, Exchange exchange) throws IOException {
        try {
            CachedOutputStream cos = new CachedOutputStream(exchange);
            IOHelper.copy((InputStream)is, (OutputStream)cos);
            InputStream inputStream = cos.getInputStream();
            return inputStream;
        }
        finally {
            ObjectHelper.close((Closeable)is, (String)"Extracting response body", (Log)LOG);
        }
    }

    protected HttpRequestBase createMethod(Exchange exchange) throws URISyntaxException {
        String url = HttpProducerHelper.createURL(exchange, this.getEndpoint());
        URI uri = new URI(url);
        HttpEntity requestEntity = this.createRequestEntity(exchange);
        HttpMethods methodToUse = HttpProducerHelper.createMethod(exchange, this.getEndpoint(), requestEntity != null);
        String queryString = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (queryString == null) {
            queryString = this.getEndpoint().getHttpUri().getQuery();
        }
        StringBuilder builder = new StringBuilder(uri.getScheme()).append("://").append(uri.getHost());
        if (uri.getPort() != -1) {
            builder.append(":").append(uri.getPort());
        }
        if (uri.getPath() != null) {
            builder.append(uri.getPath());
        }
        if (queryString != null) {
            builder.append('?');
            builder.append(queryString);
        }
        HttpRequestBase httpRequest = methodToUse.createMethod(builder.toString());
        if (methodToUse.isEntityEnclosing()) {
            ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(requestEntity);
            if (requestEntity != null && requestEntity.getContentType() == null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("No Content-Type provided for URL: " + url + " with exchange: " + exchange));
            }
        }
        return httpRequest;
    }

    protected HttpEntity createRequestEntity(Exchange exchange) {
        Message in = exchange.getIn();
        if (in.getBody() == null) {
            return null;
        }
        HttpEntity answer = (HttpEntity)in.getBody(HttpEntity.class);
        if (answer == null) {
            try {
                String data = (String)in.getBody(String.class);
                if (data != null) {
                    String contentType = ExchangeHelper.getContentType((Exchange)exchange);
                    String charset = (String)exchange.getProperty("CamelCharsetName", String.class);
                    if (charset == null) {
                        charset = "ISO-8859-1";
                    }
                    answer = new StringEntity(data, charset);
                    ((StringEntity)answer).setContentEncoding(charset);
                    if (contentType != null) {
                        ((StringEntity)answer).setContentType(contentType);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeCamelException((Throwable)e);
            }
        }
        return answer;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

