/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.TypeConverterRegistry;

public final class JacksonTypeConverters {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();

    private JacksonTypeConverters() {
    }

    @FallbackConverter
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        ObjectMapper mapper;
        if (JacksonTypeConverters.isNotPojoType(type)) {
            return null;
        }
        if (value instanceof Map && (mapper = JacksonTypeConverters.resolveObjectMapper(exchange.getContext().getRegistry())).canSerialize(type)) {
            return (T)mapper.convertValue(value, type);
        }
        return null;
    }

    private static boolean isNotPojoType(Class<?> type) {
        boolean isString = String.class.isAssignableFrom(type);
        boolean isNumber = Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
        return isString || isNumber;
    }

    private static ObjectMapper resolveObjectMapper(Registry registry) {
        Set mappers = registry.findByType(ObjectMapper.class);
        if (mappers.size() == 1) {
            return (ObjectMapper)mappers.iterator().next();
        }
        return DEFAULT_MAPPER;
    }
}

