/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.apache.camel.Exchange;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxb.FilteringXmlStreamWriter;
import org.apache.camel.converter.jaxb.NonXmlFilterReader;
import org.apache.camel.spi.TypeConverterAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackTypeConverter
implements TypeConverter,
TypeConverterAware {
    private static final transient Log LOG = LogFactory.getLog(FallbackTypeConverter.class);
    private Map<Class<?>, JAXBContext> contexts = new HashMap();
    private TypeConverter parentTypeConverter;
    private boolean prettyPrint = true;

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setTypeConverter(TypeConverter parentTypeConverter) {
        this.parentTypeConverter = parentTypeConverter;
    }

    public <T> T convertTo(Class<T> type, Object value) {
        return this.convertTo(type, null, value);
    }

    private <T> boolean isNotStreamCacheType(Class<T> type) {
        return !StreamCache.class.isAssignableFrom(type);
    }

    public <T> T convertTo(Class<T> type, Exchange exchange, Object value) {
        try {
            if (this.isJaxbType(type)) {
                return this.unmarshall(type, exchange, value);
            }
            if (value != null && this.isJaxbType(value.getClass()) && this.isNotStreamCacheType(type)) {
                return this.marshall(type, exchange, value);
            }
            return null;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
        }
    }

    public <T> T mandatoryConvertTo(Class<T> type, Object value) throws NoTypeConversionAvailableException {
        return this.mandatoryConvertTo(type, null, value);
    }

    public <T> T mandatoryConvertTo(Class<T> type, Exchange exchange, Object value) throws NoTypeConversionAvailableException {
        T answer = this.convertTo(type, exchange, value);
        if (answer == null) {
            throw new NoTypeConversionAvailableException(value, type);
        }
        return answer;
    }

    protected <T> boolean isJaxbType(Class<T> type) {
        XmlRootElement element = type.getAnnotation(XmlRootElement.class);
        return element != null;
    }

    protected <T> T unmarshall(Class<T> type, Exchange exchange, Object value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("Cannot convert from null value to JAXBSource");
        }
        JAXBContext context = this.createContext(type);
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (this.parentTypeConverter != null) {
            InputStream inputStream = (InputStream)this.parentTypeConverter.convertTo(InputStream.class, value);
            if (inputStream != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, inputStream);
                return type.cast(unmarshalled);
            }
            Reader reader = (Reader)this.parentTypeConverter.convertTo(Reader.class, value);
            if (reader != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, reader);
                return type.cast(unmarshalled);
            }
            Source source = (Source)this.parentTypeConverter.convertTo(Source.class, value);
            if (source != null) {
                Object unmarshalled = this.unmarshal(unmarshaller, exchange, source);
                return type.cast(unmarshalled);
            }
        }
        if (value instanceof String) {
            value = new StringReader((String)value);
        }
        if (value instanceof InputStream || value instanceof Reader) {
            Object unmarshalled = this.unmarshal(unmarshaller, exchange, value);
            return type.cast(unmarshalled);
        }
        return null;
    }

    protected <T> T marshall(Class<T> type, Exchange exchange, Object value) throws JAXBException, XMLStreamException, FactoryConfigurationError {
        Object answer = null;
        if (this.parentTypeConverter != null) {
            JAXBContext context = this.createContext(value.getClass());
            Marshaller marshaller = context.createMarshaller();
            StringWriter buffer = new StringWriter();
            marshaller.setProperty("jaxb.formatted.output", (Object)(this.isPrettyPrint() ? Boolean.TRUE : Boolean.FALSE));
            if (exchange != null && exchange.getProperty("CamelCharsetName", String.class) != null) {
                marshaller.setProperty("jaxb.encoding", exchange.getProperty("CamelCharsetName", String.class));
            }
            if (this.needFiltering(exchange)) {
                XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(buffer);
                FilteringXmlStreamWriter filteringWriter = new FilteringXmlStreamWriter(writer);
                marshaller.marshal(value, (XMLStreamWriter)filteringWriter);
            } else {
                marshaller.marshal(value, (Writer)buffer);
            }
            answer = this.parentTypeConverter.convertTo(type, (Object)((Object)buffer).toString());
        }
        return (T)answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unmarshal(Unmarshaller unmarshaller, Exchange exchange, Object value) throws JAXBException, UnsupportedEncodingException {
        try {
            if (value instanceof InputStream) {
                if (this.needFiltering(exchange)) {
                    Object object = unmarshaller.unmarshal((Reader)new NonXmlFilterReader(new InputStreamReader((InputStream)value, IOConverter.getCharsetName((Exchange)exchange))));
                    return object;
                }
                Object object = unmarshaller.unmarshal((InputStream)value);
                return object;
            }
            if (value instanceof Reader) {
                Reader reader = (Reader)value;
                if (this.needFiltering(exchange) && !(value instanceof NonXmlFilterReader)) {
                    reader = new NonXmlFilterReader((Reader)value);
                }
                Object object = unmarshaller.unmarshal(reader);
                return object;
            }
            if (value instanceof Source) {
                Object object = unmarshaller.unmarshal((Source)value);
                return object;
            }
        }
        finally {
            if (value instanceof Closeable) {
                ObjectHelper.close((Closeable)((Closeable)value), (String)"Unmarshalling", (Log)LOG);
            }
        }
        return null;
    }

    protected boolean needFiltering(Exchange exchange) {
        return exchange != null && (Boolean)exchange.getProperty("CamelFilterNonXmlChars", (Object)Boolean.FALSE, Boolean.class) != false;
    }

    protected synchronized <T> JAXBContext createContext(Class<T> type) throws JAXBException {
        JAXBContext context = this.contexts.get(type);
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{type});
            this.contexts.put(type, context);
        }
        return context;
    }
}

