/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcProducer.class);
    private DataSource dataSource;
    private int readSize;
    private Map<String, Object> parameters;

    public JdbcProducer(JdbcEndpoint endpoint, DataSource dataSource, int readSize, Map<String, Object> parameters) throws Exception {
        super((Endpoint)endpoint);
        this.dataSource = dataSource;
        this.readSize = readSize;
        this.parameters = parameters;
    }

    public JdbcEndpoint getEndpoint() {
        return (JdbcEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        if (this.getEndpoint().isResetAutoCommit()) {
            this.processingSqlBySettingAutoCommit(exchange);
        } else {
            this.processingSqlWithoutSettingAutoCommit(exchange);
        }
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
    }

    private void processingSqlBySettingAutoCommit(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.dataSource.getConnection();
            autoCommit = conn.getAutoCommit();
            if (autoCommit.booleanValue()) {
                conn.setAutoCommit(false);
            }
            this.createAndExecuteSqlStatement(exchange, sql, conn);
            conn.commit();
            this.resetAutoCommit(conn, autoCommit);
            this.closeQuietly(conn);
        }
        catch (Exception e) {
            try {
                try {
                    if (conn != null) {
                        conn.rollback();
                    }
                }
                catch (SQLException sqle) {
                    LOG.warn("Error occurred during jdbc rollback. This exception will be ignored.", (Throwable)sqle);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.resetAutoCommit(conn, autoCommit);
                this.closeQuietly(conn);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processingSqlWithoutSettingAutoCommit(Exchange exchange) throws Exception {
        String sql = (String)exchange.getIn().getBody(String.class);
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            this.createAndExecuteSqlStatement(exchange, sql, conn);
        }
        finally {
            this.closeQuietly(conn);
        }
    }

    private void createAndExecuteSqlStatement(Exchange exchange, String sql, Connection conn) throws Exception {
        if (this.getEndpoint().isUseHeadersAsParameters()) {
            this.doCreateAndExecuteSqlStatementWithHeaders(exchange, sql, conn);
        } else {
            this.doCreateAndExecuteSqlStatement(exchange, sql, conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCreateAndExecuteSqlStatementWithHeaders(Exchange exchange, String sql, Connection conn) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String preparedQuery = this.getEndpoint().getPrepareStatementStrategy().prepareQuery(sql, this.getEndpoint().isAllowNamedParameters());
            ps = conn.prepareStatement(preparedQuery);
            int expectedCount = ps.getParameterMetaData().getParameterCount();
            if (expectedCount > 0) {
                Iterator<?> it = this.getEndpoint().getPrepareStatementStrategy().createPopulateIterator(sql, preparedQuery, expectedCount, exchange, exchange.getIn().getBody());
                this.getEndpoint().getPrepareStatementStrategy().populateStatement(ps, it, expectedCount);
            }
            LOG.debug("Executing JDBC PreparedStatement: {}", (Object)sql);
            boolean stmtExecutionResult = ps.execute();
            if (stmtExecutionResult) {
                rs = ps.getResultSet();
                this.setResultSet(exchange, rs);
            } else {
                int updateCount = ps.getUpdateCount();
                exchange.getOut().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            this.closeQuietly(rs);
            this.closeQuietly(ps);
        }
        catch (Throwable throwable) {
            this.closeQuietly(rs);
            this.closeQuietly(ps);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCreateAndExecuteSqlStatement(Exchange exchange, String sql, Connection conn) throws Exception {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            boolean stmtExecutionResult;
            stmt = conn.createStatement();
            if (this.parameters != null && !this.parameters.isEmpty()) {
                IntrospectionSupport.setProperties((Object)stmt, this.parameters);
            }
            LOG.debug("Executing JDBC Statement: {}", (Object)sql);
            Boolean shouldRetrieveGeneratedKeys = (Boolean)exchange.getIn().getHeader("CamelRetrieveGeneratedKeys", (Object)false, Boolean.class);
            if (shouldRetrieveGeneratedKeys.booleanValue()) {
                Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelGeneratedColumns");
                if (expectedGeneratedColumns == null) {
                    stmtExecutionResult = stmt.execute(sql, 1);
                } else if (expectedGeneratedColumns instanceof String[]) {
                    stmtExecutionResult = stmt.execute(sql, (String[])expectedGeneratedColumns);
                } else {
                    if (!(expectedGeneratedColumns instanceof int[])) throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + expectedGeneratedColumns.getClass());
                    stmtExecutionResult = stmt.execute(sql, (int[])expectedGeneratedColumns);
                }
            } else {
                stmtExecutionResult = stmt.execute(sql);
            }
            if (stmtExecutionResult) {
                rs = stmt.getResultSet();
                this.setResultSet(exchange, rs);
            } else {
                int updateCount = stmt.getUpdateCount();
                exchange.getOut().setHeader("CamelJdbcUpdateCount", (Object)updateCount);
            }
            if (shouldRetrieveGeneratedKeys.booleanValue()) {
                this.setGeneratedKeys(exchange, stmt.getGeneratedKeys());
            }
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            return;
        }
        catch (Throwable throwable) {
            this.closeQuietly(rs);
            this.closeQuietly(stmt);
            throw throwable;
        }
    }

    private void closeQuietly(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqle) {
                LOG.warn("Error by closing result set: " + sqle, (Throwable)sqle);
            }
        }
    }

    private void closeQuietly(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqle) {
                LOG.warn("Error by closing statement: " + sqle, (Throwable)sqle);
            }
        }
    }

    private void resetAutoCommit(Connection con, Boolean autoCommit) {
        if (con != null && autoCommit != null) {
            try {
                con.setAutoCommit(autoCommit);
            }
            catch (SQLException sqle) {
                LOG.warn("Error by resetting auto commit to its original value: " + sqle, (Throwable)sqle);
            }
        }
    }

    private void closeQuietly(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException sqle) {
                LOG.warn("Error by closing connection: " + sqle, (Throwable)sqle);
            }
        }
    }

    protected void setGeneratedKeys(Exchange exchange, ResultSet generatedKeys) throws SQLException {
        if (generatedKeys != null) {
            List<Map<String, Object>> data = this.extractResultSetData(generatedKeys);
            exchange.getOut().setHeader("CamelGeneratedKeysRowCount", (Object)data.size());
            exchange.getOut().setHeader("CamelGeneratedKeysRows", data);
        }
    }

    protected void setResultSet(Exchange exchange, ResultSet rs) throws SQLException {
        List<Map<String, Object>> data = this.extractResultSetData(rs);
        exchange.getOut().setHeader("CamelJdbcRowCount", (Object)data.size());
        if (!data.isEmpty()) {
            exchange.getOut().setHeader("CamelJdbcColumnNames", data.get(0).keySet());
        }
        exchange.getOut().setBody(data);
    }

    protected List<Map<String, Object>> extractResultSetData(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        boolean jdbc4 = this.getEndpoint().isUseJDBC4ColumnNameAndLabelSemantics();
        int count = meta.getColumnCount();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (int rowNumber = 0; rs.next() && (this.readSize == 0 || rowNumber < this.readSize); ++rowNumber) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < count; ++i) {
                String columnName;
                int columnNumber = i + 1;
                if (jdbc4) {
                    columnName = meta.getColumnLabel(columnNumber);
                } else {
                    try {
                        columnName = meta.getColumnLabel(columnNumber);
                    }
                    catch (SQLException e) {
                        columnName = meta.getColumnName(columnNumber);
                    }
                }
                int columnType = meta.getColumnType(columnNumber);
                if (columnType == 2005 || columnType == 2004) {
                    row.put(columnName, rs.getString(columnNumber));
                    continue;
                }
                row.put(columnName, rs.getObject(columnNumber));
            }
            data.add(row);
        }
        return data;
    }
}

