/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.RuntimeCamelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetIterator
implements Iterator<Map<String, Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(ResultSetIterator.class);
    private final Connection connection;
    private final Statement statement;
    private final ResultSet resultSet;
    private final Column[] columns;
    private final AtomicBoolean closed = new AtomicBoolean();

    public ResultSetIterator(Connection conn, ResultSet resultSet, boolean isJDBC4) throws SQLException {
        this.resultSet = resultSet;
        this.statement = this.resultSet.getStatement();
        this.connection = conn;
        ResultSetMetaData metaData = resultSet.getMetaData();
        this.columns = new Column[metaData.getColumnCount()];
        for (int i = 0; i < this.columns.length; ++i) {
            int columnNumber = i + 1;
            String columnName = ResultSetIterator.getColumnName(metaData, columnNumber, isJDBC4);
            int columnType = metaData.getColumnType(columnNumber);
            this.columns[i] = columnType == 2005 || columnType == 2004 ? new BlobColumn(columnName, columnNumber) : new DefaultColumn(columnName, columnNumber);
        }
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.closed.get();
    }

    @Override
    public Map<String, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            for (Column column : this.columns) {
                row.put(column.getName(), column.getValue(this.resultSet));
            }
            this.loadNext();
            return row;
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeCamelException("Cannot process result", (Throwable)e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from a database result");
    }

    public Set<String> getColumnNames() {
        HashSet<String> columnNames = new HashSet<String>(this.columns.length);
        for (Column column : this.columns) {
            columnNames.add(column.getName());
        }
        return columnNames;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.safeCloseResultSet();
            this.safeCloseStatement();
        }
    }

    public void closeConnection() {
        this.safeCloseConnection();
    }

    private void loadNext() throws SQLException {
        boolean hasNext = this.resultSet.next();
        if (!hasNext) {
            this.close();
        }
    }

    private void safeCloseResultSet() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            LOG.warn("Error by closing result set: " + e, (Throwable)e);
        }
    }

    private void safeCloseStatement() {
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            LOG.warn("Error by closing statement: " + e, (Throwable)e);
        }
    }

    private void safeCloseConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.warn("Error by closing connection: " + e, (Throwable)e);
        }
    }

    private static String getColumnName(ResultSetMetaData metaData, int columnNumber, boolean isJDBC4) throws SQLException {
        if (isJDBC4) {
            return metaData.getColumnLabel(columnNumber);
        }
        try {
            return metaData.getColumnLabel(columnNumber);
        }
        catch (SQLException e) {
            return metaData.getColumnName(columnNumber);
        }
    }

    private static final class BlobColumn
    implements Column {
        private final int columnNumber;
        private final String name;

        private BlobColumn(String name, int columnNumber) {
            this.name = name;
            this.columnNumber = columnNumber;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue(ResultSet resultSet) throws SQLException {
            return resultSet.getString(this.columnNumber);
        }
    }

    private static final class DefaultColumn
    implements Column {
        private final int columnNumber;
        private final String name;

        private DefaultColumn(String name, int columnNumber) {
            this.name = name;
            this.columnNumber = columnNumber;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue(ResultSet resultSet) throws SQLException {
            return resultSet.getObject(this.columnNumber);
        }
    }

    private static interface Column {
        public String getName();

        public Object getValue(ResultSet var1) throws SQLException;
    }
}

