/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.reply.MessageSelectorCreator;

public class SharedQueueMessageListenerContainer
extends DefaultJmsMessageListenerContainer {
    private String fixedMessageSelector;
    private MessageSelectorCreator creator;

    public SharedQueueMessageListenerContainer(JmsEndpoint endpoint, String fixedMessageSelector) {
        super(endpoint, endpoint.isAllowReplyManagerQuickStop());
        this.fixedMessageSelector = fixedMessageSelector;
        this.setCacheLevel(3);
    }

    public SharedQueueMessageListenerContainer(JmsEndpoint endpoint, MessageSelectorCreator creator) {
        super(endpoint, endpoint.isAllowReplyManagerQuickStop());
        this.creator = creator;
        this.setCacheLevel(2);
    }

    public String getMessageSelector() {
        String id = null;
        if (this.fixedMessageSelector != null) {
            id = this.fixedMessageSelector;
        } else if (this.creator != null) {
            id = this.creator.get();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Using MessageSelector[" + id + "]"));
        }
        return id;
    }
}

