/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jmx.JMXComponent;
import org.apache.camel.component.jmx.JMXConsumer;
import org.apache.camel.component.jmx.JMXMonitorConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

public class JMXEndpoint
extends DefaultEndpoint {
    protected static final String ERR_PLATFORM_SERVER = "Monitor type consumer only supported on platform server.";
    protected static final String ERR_THRESHOLD_LOW = "ThresholdLow must be set when monitoring a gauge attribute.";
    protected static final String ERR_THRESHOLD_HIGH = "ThresholdHigh must be set when monitoring a gauge attribute.";
    protected static final String ERR_GAUGE_NOTIFY = "One or both of NotifyHigh and NotifyLow must be true when monitoring a gauge attribute.";
    protected static final String ERR_STRING_NOTIFY = "One or both of NotifyDiffer and NotifyMatch must be true when monitoring a string attribute.";
    protected static final String ERR_STRING_TO_COMPARE = "StringToCompare must be specified when monitoring a string attribute.";
    protected static final String ERR_OBSERVED_ATTRIBUTE = "Observed attribute must be specified";
    private String mObservedAttribute;
    private long mGranularityPeriod;
    private String mMonitorType;
    private int mInitThreshold;
    private int mOffset;
    private int mModulus;
    private boolean mDifferenceMode;
    private boolean mNotifyHigh;
    private boolean mNotifyLow;
    private Double mThresholdHigh;
    private Double mThresholdLow;
    private boolean mNotifyDiffer;
    private boolean mNotifyMatch;
    private String mStringToCompare;
    private String mFormat = "xml";
    private String mUser;
    private String mPassword;
    private String mObjectDomain;
    private String mObjectName;
    private NotificationFilter mNotificationFilter;
    private Object mHandback;
    private boolean mTestConnectionOnStartup = true;
    private boolean mReconnectOnConnectionFailure;
    private int mReconnectDelay = 10;
    private Hashtable<String, String> mObjectProperties;
    private ObjectName mJMXObjectName;
    private String mServerURL;

    public JMXEndpoint(String aEndpointUri, JMXComponent aComponent) {
        super(aEndpointUri, (Component)aComponent);
    }

    public Consumer createConsumer(Processor aProcessor) throws Exception {
        if (this.getMonitorType() != null) {
            if (!this.isPlatformServer()) {
                throw new IllegalArgumentException(ERR_PLATFORM_SERVER);
            }
            if (ObjectHelper.isEmpty((Object)this.getObservedAttribute())) {
                throw new IllegalArgumentException(ERR_OBSERVED_ATTRIBUTE);
            }
            if (this.getMonitorType().equals("string")) {
                if (ObjectHelper.isEmpty((Object)this.getStringToCompare())) {
                    throw new IllegalArgumentException(ERR_STRING_TO_COMPARE);
                }
                if (!this.isNotifyDiffer() && !this.isNotifyMatch()) {
                    throw new IllegalArgumentException(ERR_STRING_NOTIFY);
                }
            } else if (this.getMonitorType().equals("gauge")) {
                if (!this.isNotifyHigh() && !this.isNotifyLow()) {
                    throw new IllegalArgumentException(ERR_GAUGE_NOTIFY);
                }
                if (this.getThresholdHigh() == null) {
                    throw new IllegalArgumentException(ERR_THRESHOLD_HIGH);
                }
                if (this.getThresholdLow() == null) {
                    throw new IllegalArgumentException(ERR_THRESHOLD_LOW);
                }
            }
            return new JMXMonitorConsumer(this, aProcessor);
        }
        return new JMXConsumer(this, aProcessor);
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("producing JMX notifications is not supported");
    }

    public boolean isSingleton() {
        return false;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setFormat(String aFormat) {
        this.mFormat = aFormat;
    }

    public boolean isXML() {
        return "xml".equals(this.getFormat());
    }

    public boolean isPlatformServer() {
        return "platform".equals(this.getServerURL());
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String aUser) {
        this.mUser = aUser;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String aPassword) {
        this.mPassword = aPassword;
    }

    public String getObjectDomain() {
        return this.mObjectDomain;
    }

    public void setObjectDomain(String aObjectDomain) {
        this.mObjectDomain = aObjectDomain;
    }

    public String getObjectName() {
        return this.mObjectName;
    }

    public void setObjectName(String aObjectName) {
        if (this.getObjectProperties() != null) {
            throw new IllegalArgumentException("Cannot set both objectName and objectProperties");
        }
        this.mObjectName = aObjectName;
    }

    protected String getServerURL() {
        return this.mServerURL;
    }

    protected void setServerURL(String aServerURL) {
        this.mServerURL = aServerURL;
    }

    public NotificationFilter getNotificationFilter() {
        return this.mNotificationFilter;
    }

    public void setNotificationFilter(NotificationFilter aFilterRef) {
        this.mNotificationFilter = aFilterRef;
    }

    public Object getHandback() {
        return this.mHandback;
    }

    public void setHandback(Object aHandback) {
        this.mHandback = aHandback;
    }

    public Hashtable<String, String> getObjectProperties() {
        return this.mObjectProperties;
    }

    public void setObjectProperties(Hashtable<String, String> aObjectProperties) {
        if (this.getObjectName() != null) {
            throw new IllegalArgumentException("Cannot set both objectName and objectProperties");
        }
        this.mObjectProperties = aObjectProperties;
    }

    protected ObjectName getJMXObjectName() throws MalformedObjectNameException {
        if (this.mJMXObjectName == null) {
            ObjectName on = this.buildObjectName();
            this.setJMXObjectName(on);
        }
        return this.mJMXObjectName;
    }

    protected void setJMXObjectName(ObjectName aCachedObjectName) {
        this.mJMXObjectName = aCachedObjectName;
    }

    public String getObservedAttribute() {
        return this.mObservedAttribute;
    }

    public void setObservedAttribute(String aObservedAttribute) {
        this.mObservedAttribute = aObservedAttribute;
    }

    public long getGranularityPeriod() {
        return this.mGranularityPeriod;
    }

    public void setGranularityPeriod(long aGranularityPeriod) {
        this.mGranularityPeriod = aGranularityPeriod;
    }

    public String getMonitorType() {
        return this.mMonitorType;
    }

    public void setMonitorType(String aMonitorType) {
        this.mMonitorType = aMonitorType;
    }

    public int getInitThreshold() {
        return this.mInitThreshold;
    }

    public void setInitThreshold(int aInitThreshold) {
        this.mInitThreshold = aInitThreshold;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public void setOffset(int aOffset) {
        this.mOffset = aOffset;
    }

    public int getModulus() {
        return this.mModulus;
    }

    public void setModulus(int aModulus) {
        this.mModulus = aModulus;
    }

    public boolean isDifferenceMode() {
        return this.mDifferenceMode;
    }

    public void setDifferenceMode(boolean aDifferenceMode) {
        this.mDifferenceMode = aDifferenceMode;
    }

    public boolean isNotifyHigh() {
        return this.mNotifyHigh;
    }

    public void setNotifyHigh(boolean aNotifyHigh) {
        this.mNotifyHigh = aNotifyHigh;
    }

    public boolean isNotifyLow() {
        return this.mNotifyLow;
    }

    public void setNotifyLow(boolean aNotifyLow) {
        this.mNotifyLow = aNotifyLow;
    }

    public Double getThresholdHigh() {
        return this.mThresholdHigh;
    }

    public void setThresholdHigh(Double aThresholdHigh) {
        this.mThresholdHigh = aThresholdHigh;
    }

    public Double getThresholdLow() {
        return this.mThresholdLow;
    }

    public void setThresholdLow(Double aThresholdLow) {
        this.mThresholdLow = aThresholdLow;
    }

    public boolean isNotifyDiffer() {
        return this.mNotifyDiffer;
    }

    public void setNotifyDiffer(boolean aNotifyDiffer) {
        this.mNotifyDiffer = aNotifyDiffer;
    }

    public boolean isNotifyMatch() {
        return this.mNotifyMatch;
    }

    public void setNotifyMatch(boolean aNotifyMatch) {
        this.mNotifyMatch = aNotifyMatch;
    }

    public String getStringToCompare() {
        return this.mStringToCompare;
    }

    public void setStringToCompare(String aStringToCompare) {
        this.mStringToCompare = aStringToCompare;
    }

    public boolean getTestConnectionOnStartup() {
        return this.mTestConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.mTestConnectionOnStartup = testConnectionOnStartup;
    }

    public boolean getReconnectOnConnectionFailure() {
        return this.mReconnectOnConnectionFailure;
    }

    public void setReconnectOnConnectionFailure(boolean reconnectOnConnectionFailure) {
        this.mReconnectOnConnectionFailure = reconnectOnConnectionFailure;
    }

    public int getReconnectDelay() {
        return this.mReconnectDelay;
    }

    public void setReconnectDelay(int reconnectDelay) {
        this.mReconnectDelay = reconnectDelay;
    }

    private ObjectName buildObjectName() throws MalformedObjectNameException {
        ObjectName objectName;
        if (this.getObjectProperties() == null) {
            StringBuilder sb = new StringBuilder(this.getObjectDomain()).append(':').append("name=").append(this.getObjectName());
            objectName = new ObjectName(sb.toString());
        } else {
            objectName = new ObjectName(this.getObjectDomain(), this.getObjectProperties());
        }
        return objectName;
    }
}

