/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockException;
import javax.persistence.Query;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jpa.Consumed;
import org.apache.camel.component.jpa.DeleteHandler;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.PreConsumed;
import org.apache.camel.component.jpa.QueryBuilder;
import org.apache.camel.component.jpa.QueryFactory;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(JpaConsumer.class);
    private static final Map<String, Object> NOWAIT = new HashMap<String, Object>();
    private final EntityManager entityManager;
    private final TransactionTemplate transactionTemplate;
    private QueryFactory queryFactory;
    private DeleteHandler<Object> deleteHandler;
    private DeleteHandler<Object> preDeleteHandler;
    private String query;
    private String namedQuery;
    private String nativeQuery;
    private LockModeType lockModeType = LockModeType.PESSIMISTIC_WRITE;
    private Map<String, Object> parameters;
    private Class<?> resultClass;
    private boolean transacted;
    private boolean skipLockedEntity;

    public JpaConsumer(JpaEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.entityManager = endpoint.createEntityManager();
        this.transactionTemplate = endpoint.createTransactionTemplate();
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        Object messagePolled = this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus status) {
                if (JpaConsumer.this.getEndpoint().isJoinTransaction()) {
                    JpaConsumer.this.entityManager.joinTransaction();
                }
                LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
                Query query = JpaConsumer.this.getQueryFactory().createQuery(JpaConsumer.this.entityManager);
                JpaConsumer.this.configureParameters(query);
                LOG.trace("Created query {}", (Object)query);
                List results = query.getResultList();
                LOG.trace("Got result list from query {}", (Object)results);
                for (Object result : results) {
                    DataHolder holder = new DataHolder();
                    holder.manager = JpaConsumer.this.entityManager;
                    holder.result = result;
                    holder.exchange = JpaConsumer.this.createExchange(result);
                    answer.add(holder);
                }
                PersistenceException cause = null;
                int messagePolled = 0;
                try {
                    messagePolled = JpaConsumer.this.processBatch(CastUtils.cast(answer));
                }
                catch (Exception e) {
                    cause = e instanceof PersistenceException ? (PersistenceException)e : new PersistenceException((Throwable)e);
                }
                if (cause != null) {
                    if (!JpaConsumer.this.isTransacted()) {
                        LOG.warn("Error processing last message due: {}. Will commit all previous successful processed message, and ignore this last failure.", (Object)cause.getMessage(), (Object)cause);
                    } else {
                        throw cause;
                    }
                }
                LOG.debug("Flushing EntityManager");
                JpaConsumer.this.entityManager.flush();
                JpaConsumer.this.entityManager.clear();
                return messagePolled;
            }
        });
        return (Integer)this.getEndpoint().getCamelContext().getTypeConverter().convertTo(Integer.TYPE, messagePolled);
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there was " + total + " messages in this poll.");
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            DataHolder holder = (DataHolder)ObjectHelper.cast(DataHolder.class, (Object)exchanges.poll());
            EntityManager entityManager = holder.manager;
            Exchange exchange = holder.exchange;
            Object result = holder.result;
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            if (!this.lockEntity(result, entityManager)) continue;
            this.createPreDeleteHandler().deleteObject(entityManager, result);
            LOG.debug("Processing exchange: {}", (Object)exchange);
            this.getProcessor().process(exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            this.getDeleteHandler().deleteObject(entityManager, result);
        }
        return total;
    }

    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public QueryFactory getQueryFactory() {
        if (this.queryFactory == null) {
            this.queryFactory = this.createQueryFactory();
            if (this.queryFactory == null) {
                throw new IllegalArgumentException("No queryType property configured on this consumer, nor an entityType configured on the endpoint so cannot consume");
            }
        }
        return this.queryFactory;
    }

    public void setQueryFactory(QueryFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    public DeleteHandler<Object> getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = this.createDeleteHandler();
        }
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler<Object> deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public DeleteHandler<Object> getPreDeleteHandler() {
        if (this.preDeleteHandler == null) {
            this.preDeleteHandler = this.createPreDeleteHandler();
        }
        return this.preDeleteHandler;
    }

    public void setPreDeleteHandler(DeleteHandler<Object> preDeleteHandler) {
        this.preDeleteHandler = preDeleteHandler;
    }

    public void setParameters(Map<String, Object> params) {
        this.parameters = params;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public LockModeType getLockModeType() {
        return this.lockModeType;
    }

    public void setLockModeType(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setSkipLockedEntity(boolean skipLockedEntity) {
        this.skipLockedEntity = skipLockedEntity;
    }

    public boolean isSkipLockedEntity() {
        return this.skipLockedEntity;
    }

    protected boolean lockEntity(Object entity, EntityManager entityManager) {
        if (!this.getEndpoint().isConsumeDelete() || !this.getEndpoint().isConsumeLockEntity()) {
            return true;
        }
        try {
            LOG.debug("Acquiring exclusive lock on entity: {}", entity);
            if (this.isSkipLockedEntity()) {
                entityManager.lock(entity, this.lockModeType, NOWAIT);
            } else {
                entityManager.lock(entity, this.lockModeType);
            }
            return true;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to achieve lock on entity: " + entity + ". Reason: " + e, (Throwable)e);
            }
            if (e instanceof PessimisticLockException || e instanceof OptimisticLockException) {
                throw (PersistenceException)e;
            }
            return entity.getClass().isArray();
        }
    }

    protected QueryFactory createQueryFactory() {
        if (this.query != null) {
            return QueryBuilder.query(this.query);
        }
        if (this.namedQuery != null) {
            return QueryBuilder.namedQuery(this.namedQuery);
        }
        if (this.nativeQuery != null) {
            if (this.resultClass != null) {
                return QueryBuilder.nativeQuery(this.nativeQuery, this.resultClass);
            }
            return QueryBuilder.nativeQuery(this.nativeQuery);
        }
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType == null) {
            return null;
        }
        String name = this.getEntityName(entityType);
        if (name != null) {
            return QueryBuilder.query("select x from " + name + " x");
        }
        return QueryBuilder.query("select x from " + entityType.getSimpleName() + " x");
    }

    protected String getEntityName(Class<?> clazz) {
        Entity entity = clazz.getAnnotation(Entity.class);
        if (entity != null && !entity.name().equals("")) {
            return entity.name();
        }
        return null;
    }

    protected DeleteHandler<Object> createPreDeleteHandler() {
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List methods = ObjectHelper.findMethodsWithAnnotation(entityType, PreConsumed.class);
            if (methods.size() > 1) {
                throw new IllegalStateException("Only one method can be annotated with the @PreConsumed annotation but found: " + methods);
            }
            if (methods.size() == 1) {
                Class<?>[] parameters = ((Method)methods.get(0)).getParameterTypes();
                if (parameters.length != 0) {
                    throw new IllegalStateException("@PreConsumed annotated method cannot have parameters!");
                }
                final Method method = (Method)methods.get(0);
                return new DeleteHandler<Object>(){

                    @Override
                    public void deleteObject(EntityManager entityManager, Object entityBean) {
                        ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[0]);
                    }
                };
            }
        }
        return new DeleteHandler<Object>(){

            @Override
            public void deleteObject(EntityManager entityManager, Object entityBean) {
            }
        };
    }

    protected DeleteHandler<Object> createDeleteHandler() {
        Class<?> entityType = this.getEndpoint().getEntityType();
        if (entityType != null) {
            List methods = ObjectHelper.findMethodsWithAnnotation(entityType, Consumed.class);
            if (methods.size() > 1) {
                throw new IllegalArgumentException("Only one method can be annotated with the @Consumed annotation but found: " + methods);
            }
            if (methods.size() == 1) {
                final Method method = (Method)methods.get(0);
                return new DeleteHandler<Object>(){

                    @Override
                    public void deleteObject(EntityManager entityManager, Object entityBean) {
                        ObjectHelper.invokeMethod((Method)method, (Object)entityBean, (Object[])new Object[0]);
                    }
                };
            }
        }
        if (this.getEndpoint().isConsumeDelete()) {
            return new DeleteHandler<Object>(){

                @Override
                public void deleteObject(EntityManager entityManager, Object entityBean) {
                    entityManager.remove(entityBean);
                }
            };
        }
        return new DeleteHandler<Object>(){

            @Override
            public void deleteObject(EntityManager entityManager, Object entityBean) {
            }
        };
    }

    protected void configureParameters(Query query) {
        int maxResults = this.getEndpoint().getMaximumResults();
        if (maxResults > 0) {
            query.setMaxResults(maxResults);
        }
        if (this.parameters != null) {
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    protected Exchange createExchange(Object result) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody(result);
        exchange.getIn().setHeader("CamelEntityManager", (Object)this.entityManager);
        return exchange;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.entityManager.close();
        LOG.trace("closed the EntityManager {} on {}", (Object)this.entityManager, (Object)this);
    }

    static {
        NOWAIT.put("javax.persistence.lock.timeout", 0L);
    }

    private static final class DataHolder {
        private Exchange exchange;
        private Object result;
        private EntityManager manager;

        private DataHolder() {
        }
    }
}

