/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import java.util.Collection;
import javax.persistence.EntityManager;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(JpaProducer.class);
    private final EntityManager entityManager;
    private final TransactionTemplate transactionTemplate;
    private final Expression expression;

    public JpaProducer(JpaEndpoint endpoint, Expression expression) {
        super((Endpoint)endpoint);
        this.expression = expression;
        this.entityManager = endpoint.createEntityManager();
        this.transactionTemplate = endpoint.createTransactionTemplate();
    }

    public JpaEndpoint getEndpoint() {
        return (JpaEndpoint)super.getEndpoint();
    }

    public void process(final Exchange exchange) {
        final EntityManager targetEntityManager = this.getTargetEntityManager(exchange);
        exchange.getIn().setHeader("CamelEntityManager", (Object)targetEntityManager);
        final Object values = this.expression.evaluate(exchange, Object.class);
        if (values != null) {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                public Object doInTransaction(TransactionStatus status) {
                    if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                        targetEntityManager.joinTransaction();
                    }
                    if (values.getClass().isArray()) {
                        Object[] array = (Object[])values;
                        for (int index = 0; index < array.length; ++index) {
                            this.save(array[index]);
                        }
                    } else if (values instanceof Collection) {
                        Collection collection = (Collection)values;
                        for (Object entity : collection) {
                            this.save(entity);
                        }
                    } else {
                        Object managedEntity = this.save(values);
                        if (!JpaProducer.this.getEndpoint().isUsePersist()) {
                            exchange.getIn().setBody(managedEntity);
                        }
                    }
                    if (JpaProducer.this.getEndpoint().isFlushOnSend()) {
                        if (JpaProducer.this.getEndpoint().isJoinTransaction()) {
                            targetEntityManager.joinTransaction();
                        }
                        targetEntityManager.flush();
                    }
                    return null;
                }

                private Object save(Object entity) {
                    targetEntityManager.joinTransaction();
                    if (JpaProducer.this.getEndpoint().isUsePersist()) {
                        targetEntityManager.persist(entity);
                        return entity;
                    }
                    return targetEntityManager.merge(entity);
                }
            });
        }
    }

    private EntityManager getTargetEntityManager(Exchange exchange) {
        EntityManager passedIn;
        EntityManager em = this.entityManager;
        if (this.getEndpoint().isUsePassedInEntityManager() && (passedIn = (EntityManager)exchange.getIn().getHeader("CamelEntityManager", EntityManager.class)) != null) {
            em = passedIn;
        }
        return em;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.entityManager.close();
        LOG.trace("closed the EntityManager {} on {}", (Object)this.entityManager, (Object)this);
    }
}

