/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.jsonpath.JsonPathEngine;
import org.apache.camel.support.ExpressionAdapter;

public class JsonPathExpression
extends ExpressionAdapter {
    private final String expression;
    private Class<?> resultType;
    private final JsonPathEngine engine;

    public JsonPathExpression(String expression) {
        this.expression = expression;
        try {
            this.engine = new JsonPathEngine(expression);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(expression, (Throwable)e);
        }
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public Object evaluate(Exchange exchange) {
        try {
            Object result = this.evaluateJsonPath(exchange, this.engine);
            if (this.resultType != null) {
                return exchange.getContext().getTypeConverter().convertTo(this.resultType, exchange, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    public String toString() {
        return "jsonpath[" + this.expression + "]";
    }

    private Object evaluateJsonPath(Exchange exchange, JsonPathEngine engine) throws Exception {
        return engine.read(exchange);
    }
}

