/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.FolderNotFoundException;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Store;
import jakarta.mail.search.SearchTerm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.attachment.Attachment;
import org.apache.camel.attachment.AttachmentMessage;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailBoxPostProcessAction;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailEndpoint;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailSorter;
import org.apache.camel.component.mail.MailUtils;
import org.apache.camel.component.mail.SearchTermBuilder;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.eclipse.angus.mail.imap.IMAPStore;
import org.eclipse.angus.mail.imap.SortTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailConsumer
extends ScheduledBatchPollingConsumer {
    public static final String MAIL_MESSAGE_UID = "CamelMailMessageId";
    public static final long DEFAULT_CONSUMER_DELAY = 60000L;
    private static final Logger LOG = LoggerFactory.getLogger(MailConsumer.class);
    private final JavaMailSender sender;
    private Folder folder;
    private Store store;
    private boolean skipFailedMessage;
    private boolean handleFailedMessage;
    private boolean serverCanSort;

    public MailConsumer(MailEndpoint endpoint, Processor processor, JavaMailSender sender) {
        super((Endpoint)endpoint, processor);
        this.sender = sender;
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(true);
        }
        if (this.store != null && this.store.isConnected()) {
            this.store.close();
        }
        super.doStop();
    }

    private int getMaxNumberOfMessages() {
        int maximumMessagesPerPoll;
        int fetchSize = this.getEndpoint().getConfiguration().getFetchSize();
        if (this.hasMessageLimit(fetchSize)) {
            return fetchSize;
        }
        int n = maximumMessagesPerPoll = this.getMaxMessagesPerPoll() == 0 ? -1 : this.getMaxMessagesPerPoll();
        if (this.hasMessageLimit(maximumMessagesPerPoll)) {
            return maximumMessagesPerPoll;
        }
        return -1;
    }

    private boolean hasMessageLimit(int limitValue) {
        return limitValue >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        int polledMessages = 0;
        this.ensureIsConnected();
        if (this.store == null || this.folder == null) {
            throw new IllegalStateException("MailConsumer did not connect properly to the MailStore: " + this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Polling mailbox folder: {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        if (this.getEndpoint().getConfiguration().getFetchSize() == 0) {
            LOG.warn("Fetch size is 0 meaning the configuration is set to poll no new messages at all. Camel will skip this poll.");
            return 0;
        }
        try {
            if (!this.folder.isOpen()) {
                this.folder.open(2);
            }
        }
        catch (MessagingException e) {
            String msg = "Error opening mail folder due to " + e.getMessage() + ". Will re-create connection on next poll.";
            LOG.warn(msg);
            if (LOG.isDebugEnabled()) {
                LOG.debug(msg, (Throwable)e);
            }
            this.disconnect();
            return 0;
        }
        try {
            int count = this.folder.getMessageCount();
            if (count > 0) {
                Queue<Exchange> messages = this.retrieveMessages();
                polledMessages = this.processBatch(CastUtils.cast(messages));
                MailBoxPostProcessAction postProcessor = this.getEndpoint().getPostProcessAction();
                if (postProcessor != null) {
                    postProcessor.process(this.folder);
                }
            } else if (count == -1) {
                throw new MessagingException("Folder: " + this.folder.getFullName() + " is closed");
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (this.getEndpoint().getConfiguration().isCloseFolder() || this.getEndpoint().getConfiguration().isDisconnect()) {
                try {
                    if (this.folder != null && this.folder.isOpen()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Close mailbox folder {} from {}", (Object)this.folder.getName(), (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
                        }
                        this.folder.close(true);
                    }
                }
                catch (Exception e) {
                    LOG.debug("Could not close mailbox folder: {}. This exception is ignored.", (Object)this.folder.getName(), (Object)e);
                }
            }
        }
        boolean disconnect = this.getEndpoint().getConfiguration().isDisconnect();
        if (disconnect) {
            this.disconnect();
        }
        return polledMessages;
    }

    private void disconnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disconnecting from {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
        }
        try {
            if (this.store != null) {
                this.store.close();
            }
        }
        catch (Exception e) {
            LOG.debug("Could not disconnect from {}. This exception is ignored.", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation(), (Object)e);
        }
        this.store = null;
        this.folder = null;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            final jakarta.mail.Message mail = ((MailMessage)((Object)exchange.getIn(MailMessage.class))).getOriginalMessage();
            exchange.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onComplete(Exchange exchange) {
                    MailConsumer.this.processCommit(mail, exchange);
                }

                public void onFailure(Exchange exchange) {
                    MailConsumer.this.processRollback(mail, exchange);
                }

                public boolean allowHandover() {
                    return false;
                }

                public String toString() {
                    return "MailConsumerOnCompletion";
                }
            });
            this.processExchange(exchange);
        }
        return total;
    }

    private void peekMessage(jakarta.mail.Message mail) {
        if (mail.getClass().getSimpleName().startsWith("IMAP")) {
            try {
                LOG.trace("Calling setPeek(true) on mail message {}", (Object)mail);
                BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)this.getEndpoint().getCamelContext());
                beanIntrospection.setProperty(this.getEndpoint().getCamelContext(), (Object)mail, "peek", (Object)true);
            }
            catch (Exception e) {
                LOG.trace("Error setting peak property to true on: {}. This exception is ignored.", (Object)mail, (Object)e);
            }
        }
    }

    private Queue<Exchange> retrieveMessages() throws MessagingException {
        jakarta.mail.Message[] messages;
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        SortTerm[] sortTerm = this.getEndpoint().getSortTerm();
        SearchTerm searchTerm = this.computeSearchTerm();
        if (sortTerm != null && this.serverCanSort) {
            IMAPFolder imapFolder = (IMAPFolder)this.folder;
            messages = searchTerm != null ? imapFolder.getSortedMessages(sortTerm, searchTerm) : imapFolder.getSortedMessages(sortTerm);
        } else {
            messages = searchTerm != null ? this.folder.search(searchTerm, this.retrieveAllMessages()) : this.retrieveAllMessages();
            if (sortTerm != null) {
                MailSorter.sortMessages(messages, sortTerm);
            }
        }
        int maxMessage = this.getMaxNumberOfMessages();
        boolean hasMessageLimit = this.hasMessageLimit(maxMessage);
        for (jakarta.mail.Message message : messages) {
            Exchange exchange;
            if (hasMessageLimit && answer.size() >= maxMessage) break;
            String key = this.getEndpoint().getMailUidGenerator().generateUuid(this.getEndpoint(), message);
            if (!this.isValidMessage(key, message)) continue;
            if (this.getEndpoint().getConfiguration().isPeek()) {
                this.peekMessage(message);
            }
            if ((exchange = this.createExchange((KeyValueHolder<String, jakarta.mail.Message>)new KeyValueHolder((Object)key, (Object)message))) == null) continue;
            answer.add(exchange);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching {} messages. Total {} messages.", (Object)answer.size(), (Object)messages.length);
        }
        return answer;
    }

    private jakarta.mail.Message[] retrieveAllMessages() throws MessagingException {
        int total = this.folder.getMessageCount();
        ArrayList<jakarta.mail.Message> msgs = new ArrayList<jakarta.mail.Message>();
        for (int i = 1; i <= total; ++i) {
            try {
                jakarta.mail.Message msg = this.folder.getMessage(i);
                msgs.add(msg);
                continue;
            }
            catch (Exception e) {
                if (this.skipFailedMessage) {
                    LOG.debug("Skipping failed message at index {} due {}", new Object[]{i, e.getMessage(), e});
                    continue;
                }
                if (this.handleFailedMessage) {
                    this.handleException(e);
                    continue;
                }
                throw e;
            }
        }
        return msgs.toArray(new jakarta.mail.Message[0]);
    }

    private boolean isValidMessage(String key, jakarta.mail.Message msg) {
        boolean answer = true;
        if (this.getEndpoint().getIdempotentRepository() != null && !this.getEndpoint().getIdempotentRepository().add(key)) {
            LOG.trace("This consumer is idempotent and the mail message has been consumed before matching idempotentKey: {}. Will skip this message: {}", (Object)key, (Object)msg);
            answer = false;
        }
        LOG.debug("Message: {} with key: {} is valid: {}", new Object[]{msg, key, answer});
        return answer;
    }

    private SearchTerm computeSearchTerm() {
        if (this.getEndpoint().getSearchTerm() != null) {
            return this.getEndpoint().getSearchTerm();
        }
        if (this.getEndpoint().getConfiguration().isUnseen()) {
            return new SearchTermBuilder().unseen().build();
        }
        return null;
    }

    protected Exchange createExchange(KeyValueHolder<String, jakarta.mail.Message> holder) throws MessagingException {
        try {
            String key = (String)holder.getKey();
            jakarta.mail.Message message = (jakarta.mail.Message)holder.getValue();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Mail is of type: {} - {}", (Object)ObjectHelper.classCanonicalName((Object)message), (Object)message);
            }
            if (!message.getFlags().contains(Flags.Flag.DELETED)) {
                Exchange exchange = this.createExchange(message);
                if (this.getEndpoint().getConfiguration().isMapMailMessage()) {
                    LOG.trace("Mapping from jakarta.mail.Message to Camel MailMessage");
                    exchange.getIn().getBody();
                    exchange.getIn().getHeaders();
                    try {
                        HashMap<String, Attachment> att = new HashMap<String, Attachment>();
                        this.getEndpoint().getBinding().extractAttachmentsFromMail(message, att);
                        if (!att.isEmpty()) {
                            ((AttachmentMessage)exchange.getIn(AttachmentMessage.class)).setAttachmentObjects(att);
                        }
                    }
                    catch (MessagingException | IOException e) {
                        this.releaseExchange(exchange, true);
                        throw new RuntimeCamelException("Error accessing attachments due to: " + e.getMessage(), e);
                    }
                }
                exchange.setProperty(MAIL_MESSAGE_UID, (Object)key);
                return exchange;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping message as it was flagged as deleted: {}", (Object)MailUtils.dumpMessage(message));
            }
        }
        catch (Exception e) {
            if (this.skipFailedMessage) {
                LOG.debug("Skipping failed message due {}", (Object)e.getMessage(), (Object)e);
            }
            if (this.handleFailedMessage) {
                this.handleException(e);
            }
            throw e;
        }
        return null;
    }

    protected void processExchange(Exchange exchange) throws Exception {
        if (LOG.isDebugEnabled()) {
            MailMessage msg = (MailMessage)exchange.getIn();
            LOG.debug("Processing message: {}", (Object)MailUtils.dumpMessage(msg.getMessage()));
        }
        this.getProcessor().process(exchange);
    }

    protected void processCommit(jakarta.mail.Message mail, Exchange exchange) {
        try {
            if (!this.folder.isOpen()) {
                this.folder.open(2);
            }
            String uid = (String)exchange.removeProperty(MAIL_MESSAGE_UID);
            if (this.getEndpoint().getConfiguration().getProtocol().startsWith("pop3")) {
                int count = this.folder.getMessageCount();
                jakarta.mail.Message found = null;
                LOG.trace("Looking for POP3Message with UID {} from folder with {} mails", (Object)uid, (Object)count);
                for (int i = 1; i <= count; ++i) {
                    jakarta.mail.Message msg = this.folder.getMessage(i);
                    if (!uid.equals(this.getEndpoint().getMailUidGenerator().generateUuid(this.getEndpoint(), msg))) continue;
                    LOG.debug("Found POP3Message with UID {} from folder with {} mails", (Object)uid, (Object)count);
                    found = msg;
                    break;
                }
                if (found == null) {
                    boolean delete = this.getEndpoint().getConfiguration().isDelete();
                    LOG.warn("POP3message not found in folder. Message cannot be marked as {}", (Object)(delete ? "DELETED" : "SEEN"));
                } else {
                    mail = found;
                }
            }
            Message in = exchange.getIn();
            MailConfiguration config = this.getEndpoint().getConfiguration();
            String copyTo = (String)in.getHeader("copyTo", (Object)config.getCopyTo(), String.class);
            String moveTo = (String)in.getHeader("moveTo", (Object)config.getMoveTo(), String.class);
            boolean delete = (Boolean)in.getHeader("delete", (Object)config.isDelete(), Boolean.TYPE);
            this.copyOrMoveMessageIfRequired(config, mail, copyTo, false);
            if (delete) {
                LOG.trace("Exchange processed, so flagging message as DELETED");
                this.copyOrMoveMessageIfRequired(config, mail, moveTo, true);
                mail.setFlag(Flags.Flag.DELETED, true);
            } else {
                LOG.trace("Exchange processed, so flagging message as SEEN");
                mail.setFlag(Flags.Flag.SEEN, true);
                this.copyOrMoveMessageIfRequired(config, mail, moveTo, true);
            }
            if (this.getEndpoint().getIdempotentRepository() != null) {
                if (this.getEndpoint().isIdempotentRepositoryRemoveOnCommit()) {
                    this.getEndpoint().getIdempotentRepository().remove(uid);
                } else {
                    this.getEndpoint().getIdempotentRepository().confirm(uid);
                }
            }
        }
        catch (MessagingException e) {
            this.getExceptionHandler().handleException("Error occurred during committing mail message: " + mail, exchange, (Throwable)e);
        }
    }

    private Exchange createExchange(jakarta.mail.Message message) {
        Exchange exchange = this.createExchange(true);
        exchange.setProperty("CamelBinding", (Object)this.getEndpoint().getBinding());
        exchange.setIn((Message)new MailMessage(exchange, message, this.getEndpoint().getConfiguration().isMapMailMessage()));
        return exchange;
    }

    private void copyOrMoveMessageIfRequired(MailConfiguration config, jakarta.mail.Message mail, String destinationFolder, boolean moveMessage) throws MessagingException {
        if ((config.getProtocol().equals("imap") || config.getProtocol().equals("imaps")) && destinationFolder != null) {
            LOG.trace("IMAP message needs to be {} to {}", (Object)(moveMessage ? "moved" : "copied"), (Object)destinationFolder);
            Folder destFolder = this.store.getFolder(destinationFolder);
            if (!destFolder.exists()) {
                destFolder.create(1);
            }
            this.folder.copyMessages(new jakarta.mail.Message[]{mail}, destFolder);
            if (moveMessage) {
                mail.setFlag(Flags.Flag.DELETED, true);
            }
            LOG.trace("IMAP message {} {} to {}", new Object[]{mail, moveMessage ? "moved" : "copied", destinationFolder});
        }
    }

    protected void processRollback(jakarta.mail.Message mail, Exchange exchange) {
        Exception cause;
        String uid = (String)exchange.removeProperty(MAIL_MESSAGE_UID);
        if (this.getEndpoint().getIdempotentRepository() != null) {
            this.getEndpoint().getIdempotentRepository().remove(uid);
        }
        if ((cause = exchange.getException()) != null) {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange, (Object)cause);
        } else {
            LOG.warn("Exchange failed, so rolling back message status: {}", (Object)exchange);
        }
    }

    private void ensureIsConnected() throws MessagingException {
        MailConfiguration config = this.getEndpoint().getConfiguration();
        boolean connected = false;
        try {
            if (this.store != null && this.store.isConnected()) {
                connected = true;
            }
        }
        catch (Exception e) {
            LOG.debug("Exception while testing for is connected to MailStore: {}. Caused by: {}", new Object[]{this.getEndpoint().getConfiguration().getMailStoreLogInformation(), e.getMessage(), e});
        }
        if (!connected) {
            this.store = null;
            this.folder = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connecting to MailStore: {}", (Object)this.getEndpoint().getConfiguration().getMailStoreLogInformation());
            }
            this.store = this.sender.getSession().getStore(config.getProtocol());
            PasswordAuthentication passwordAuth = config.getPasswordAuthentication();
            this.store.connect(config.getHost(), config.getPort(), passwordAuth.getUserName(), passwordAuth.getPassword());
            this.serverCanSort = MailConsumer.hasSortCapability(this.store);
        }
        if (this.folder == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting folder {}", (Object)config.getFolderName());
            }
            this.folder = this.store.getFolder(config.getFolderName());
            if (this.folder == null || !this.folder.exists()) {
                throw new FolderNotFoundException(this.folder, "Folder not found or invalid: " + config.getFolderName());
            }
        }
    }

    private static boolean hasSortCapability(Store store) throws MessagingException {
        IMAPStore imapStore;
        return store instanceof IMAPStore && (imapStore = (IMAPStore)store).hasCapability("SORT*");
    }

    public MailEndpoint getEndpoint() {
        return (MailEndpoint)super.getEndpoint();
    }

    public boolean isSkipFailedMessage() {
        return this.skipFailedMessage;
    }

    public void setSkipFailedMessage(boolean skipFailedMessage) {
        this.skipFailedMessage = skipFailedMessage;
    }

    public boolean isHandleFailedMessage() {
        return this.handleFailedMessage;
    }

    public void setHandleFailedMessage(boolean handleFailedMessage) {
        this.handleFailedMessage = handleFailedMessage;
    }
}

