/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ManagementMBeansLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.support.management.DefaultManagementMBeanAssembler;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementAgent
extends ServiceSupport
implements ManagementAgent,
CamelContextAware {
    public static final String DEFAULT_DOMAIN = "org.apache.camel";
    public static final String DEFAULT_HOST = "localhost";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagementAgent.class);
    private CamelContext camelContext;
    private MBeanServer server;
    private ManagementMBeanAssembler assembler;
    private final ConcurrentMap<ObjectName, ObjectName> mbeansRegistered = new ConcurrentHashMap<ObjectName, ObjectName>();
    private String mBeanServerDefaultDomain = "org.apache.camel";
    private String mBeanObjectDomainName = "org.apache.camel";
    private Boolean usePlatformMBeanServer = true;
    private Boolean onlyRegisterProcessorWithCustomId = false;
    private Boolean loadStatisticsEnabled = false;
    private Boolean endpointRuntimeStatisticsEnabled;
    private Boolean registerAlways = false;
    private Boolean registerNewRoutes = true;
    private Boolean mask = true;
    private Boolean includeHostName = false;
    private Boolean useHostIPAddress = false;
    private String managementNamePattern = "#name#";
    private ManagementStatisticsLevel statisticsLevel = ManagementStatisticsLevel.Default;
    private ManagementMBeansLevel mBeansLevel = ManagementMBeansLevel.Default;

    public DefaultManagementAgent() {
    }

    public DefaultManagementAgent(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void finalizeSettings() throws Exception {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        if (System.getProperty("org.apache.camel.jmx.mbeanServerDefaultDomain") != null) {
            this.mBeanServerDefaultDomain = System.getProperty("org.apache.camel.jmx.mbeanServerDefaultDomain");
            values.put("org.apache.camel.jmx.mbeanServerDefaultDomain", this.mBeanServerDefaultDomain);
        }
        if (System.getProperty("org.apache.camel.jmx.mbeanObjectDomainName") != null) {
            this.mBeanObjectDomainName = System.getProperty("org.apache.camel.jmx.mbeanObjectDomainName");
            values.put("org.apache.camel.jmx.mbeanObjectDomainName", this.mBeanObjectDomainName);
        }
        if (System.getProperty("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId") != null) {
            this.onlyRegisterProcessorWithCustomId = Boolean.getBoolean("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId");
            values.put("org.apache.camel.jmx.onlyRegisterProcessorWithCustomId", this.onlyRegisterProcessorWithCustomId);
        }
        if (System.getProperty("org.apache.camel.jmx.usePlatformMBeanServer") != null) {
            this.usePlatformMBeanServer = Boolean.getBoolean("org.apache.camel.jmx.usePlatformMBeanServer");
            values.put("org.apache.camel.jmx.usePlatformMBeanServer", this.usePlatformMBeanServer);
        }
        if (System.getProperty("org.apache.camel.jmx.registerAlways") != null) {
            this.registerAlways = Boolean.getBoolean("org.apache.camel.jmx.registerAlways");
            values.put("org.apache.camel.jmx.registerAlways", this.registerAlways);
        }
        if (System.getProperty("org.apache.camel.jmx.registerNewRoutes") != null) {
            this.registerNewRoutes = Boolean.getBoolean("org.apache.camel.jmx.registerNewRoutes");
            values.put("org.apache.camel.jmx.registerNewRoutes", this.registerNewRoutes);
        }
        if (System.getProperty("org.apache.camel.jmx.mask") != null) {
            this.mask = Boolean.getBoolean("org.apache.camel.jmx.mask");
            values.put("org.apache.camel.jmx.mask", this.mask);
        }
        if (System.getProperty("org.apache.camel.jmx.includeHostName") != null) {
            this.includeHostName = Boolean.getBoolean("org.apache.camel.jmx.includeHostName");
            values.put("org.apache.camel.jmx.includeHostName", this.includeHostName);
        }
        if (System.getProperty("org.apache.camel.jmx.loadStatisticsEnabled") != null) {
            this.loadStatisticsEnabled = Boolean.getBoolean("org.apache.camel.jmx.loadStatisticsEnabled");
            values.put("org.apache.camel.jmx.loadStatisticsEnabled", this.loadStatisticsEnabled);
        }
        if (System.getProperty("org.apache.camel.jmx.endpointRuntimeStatisticsEnabled") != null) {
            this.endpointRuntimeStatisticsEnabled = Boolean.getBoolean("org.apache.camel.jmx.endpointRuntimeStatisticsEnabled");
            values.put("org.apache.camel.jmx.endpointRuntimeStatisticsEnabled", this.endpointRuntimeStatisticsEnabled);
        }
        if (System.getProperty("org.apache.camel.jmx.statisticsLevel") != null) {
            this.statisticsLevel = (ManagementStatisticsLevel)this.camelContext.getTypeConverter().mandatoryConvertTo(ManagementStatisticsLevel.class, (Object)System.getProperty("org.apache.camel.jmx.statisticsLevel"));
            values.put("org.apache.camel.jmx.statisticsLevel", this.statisticsLevel);
        }
        if (System.getProperty("org.apache.camel.jmx.managementNamePattern") != null) {
            this.managementNamePattern = System.getProperty("org.apache.camel.jmx.managementNamePattern");
            values.put("org.apache.camel.jmx.managementNamePattern", this.managementNamePattern);
        }
        if (System.getProperty("org.apache.camel.jmx.useHostIPAddress") != null) {
            this.useHostIPAddress = Boolean.getBoolean("org.apache.camel.jmx.useHostIPAddress");
            values.put("org.apache.camel.jmx.useHostIPAddress", this.useHostIPAddress);
        }
        if (!values.isEmpty()) {
            LOG.info("ManagementAgent detected JVM system properties: {}", values);
        }
    }

    public void setMBeanServerDefaultDomain(String domain) {
        this.mBeanServerDefaultDomain = domain;
    }

    public String getMBeanServerDefaultDomain() {
        return this.mBeanServerDefaultDomain;
    }

    public void setMBeanObjectDomainName(String domainName) {
        this.mBeanObjectDomainName = domainName;
    }

    public String getMBeanObjectDomainName() {
        return this.mBeanObjectDomainName;
    }

    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    public Boolean getUsePlatformMBeanServer() {
        return this.usePlatformMBeanServer;
    }

    public Boolean getOnlyRegisterProcessorWithCustomId() {
        return this.onlyRegisterProcessorWithCustomId;
    }

    public void setOnlyRegisterProcessorWithCustomId(Boolean onlyRegisterProcessorWithCustomId) {
        this.onlyRegisterProcessorWithCustomId = onlyRegisterProcessorWithCustomId;
    }

    public void setMBeanServer(MBeanServer mbeanServer) {
        this.server = mbeanServer;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public Boolean getRegisterAlways() {
        return this.registerAlways != null && this.registerAlways != false;
    }

    public void setRegisterAlways(Boolean registerAlways) {
        this.registerAlways = registerAlways;
    }

    public Boolean getRegisterNewRoutes() {
        return this.registerNewRoutes != null && this.registerNewRoutes != false;
    }

    public void setRegisterNewRoutes(Boolean registerNewRoutes) {
        this.registerNewRoutes = registerNewRoutes;
    }

    public Boolean getMask() {
        return this.mask != null && this.mask != false;
    }

    public void setMask(Boolean mask) {
        this.mask = mask;
    }

    public Boolean getIncludeHostName() {
        return this.includeHostName != null && this.includeHostName != false;
    }

    public void setIncludeHostName(Boolean includeHostName) {
        this.includeHostName = includeHostName;
    }

    public Boolean getUseHostIPAddress() {
        return this.useHostIPAddress != null && this.useHostIPAddress != false;
    }

    public void setUseHostIPAddress(Boolean useHostIPAddress) {
        this.useHostIPAddress = useHostIPAddress;
    }

    public String getManagementNamePattern() {
        return this.managementNamePattern;
    }

    public void setManagementNamePattern(String managementNamePattern) {
        this.managementNamePattern = managementNamePattern;
    }

    public Boolean getLoadStatisticsEnabled() {
        return this.loadStatisticsEnabled;
    }

    public void setLoadStatisticsEnabled(Boolean loadStatisticsEnabled) {
        this.loadStatisticsEnabled = loadStatisticsEnabled;
    }

    public Boolean getEndpointRuntimeStatisticsEnabled() {
        return this.endpointRuntimeStatisticsEnabled;
    }

    public void setEndpointRuntimeStatisticsEnabled(Boolean endpointRuntimeStatisticsEnabled) {
        this.endpointRuntimeStatisticsEnabled = endpointRuntimeStatisticsEnabled;
    }

    public ManagementStatisticsLevel getStatisticsLevel() {
        return this.statisticsLevel;
    }

    public void setStatisticsLevel(ManagementStatisticsLevel statisticsLevel) {
        this.statisticsLevel = statisticsLevel;
    }

    public ManagementMBeansLevel getMBeansLevel() {
        return this.mBeansLevel;
    }

    public void setMBeansLevel(ManagementMBeansLevel mBeansLevel) {
        this.mBeansLevel = mBeansLevel;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        block2: {
            try {
                this.registerMBeanWithServer(obj, name, forceRegistration);
            }
            catch (NotCompliantMBeanException e) {
                ObjectHelper.notNull((Object)this.assembler, (String)"ManagementMBeanAssembler", (Object)this.camelContext);
                ModelMBean mbean = this.assembler.assemble(this.server, obj, name);
                if (mbean == null) break block2;
                this.registerMBeanWithServer(mbean, name, forceRegistration);
            }
        }
    }

    public void unregister(ObjectName name) throws JMException {
        if (this.isRegistered(name)) {
            ObjectName on = (ObjectName)this.mbeansRegistered.remove(name);
            this.server.unregisterMBean(on);
            LOG.debug("Unregistered MBean with ObjectName: {}", (Object)name);
        } else {
            this.mbeansRegistered.remove(name);
        }
    }

    public boolean isRegistered(ObjectName name) {
        if (this.server == null) {
            return false;
        }
        ObjectName on = (ObjectName)this.mbeansRegistered.get(name);
        return on != null && this.server.isRegistered(on) || this.server.isRegistered(name);
    }

    public <T> T newProxyClient(ObjectName name, Class<T> mbean) {
        if (this.isRegistered(name)) {
            ObjectName on = (ObjectName)this.mbeansRegistered.get(name);
            return MBeanServerInvocationHandler.newProxyInstance(this.server, on != null ? on : name, mbean, false);
        }
        return null;
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        this.finalizeSettings();
        this.assembler = this.camelContext.getCamelContextExtension().getManagementMBeanAssembler();
        if (this.assembler == null) {
            this.assembler = new DefaultManagementMBeanAssembler(this.camelContext);
        }
        ServiceHelper.initService((Object)this.assembler);
    }

    protected void doStart() throws Exception {
        if (this.server == null) {
            this.createMBeanServer();
        }
        ServiceHelper.startService((Object)this.assembler);
        LOG.debug("Starting JMX agent on server: {}", (Object)this.getMBeanServer());
    }

    protected void doStop() throws Exception {
        if (this.mbeansRegistered.isEmpty()) {
            return;
        }
        ObjectName[] mBeans = this.mbeansRegistered.keySet().toArray(new ObjectName[0]);
        int caught = 0;
        for (ObjectName name : mBeans) {
            try {
                this.unregister(name);
            }
            catch (Exception e) {
                LOG.info("Exception unregistering MBean with name {}", (Object)name, (Object)e);
                ++caught;
            }
        }
        if (caught > 0) {
            LOG.warn("{} exceptions caught while unregistering MBeans during stop operation. See INFO log for details.", (Object)caught);
        }
        ServiceHelper.stopService((Object)this.assembler);
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        boolean exists = this.isRegistered(name);
        if (exists) {
            if (forceRegistration) {
                LOG.info("ForceRegistration enabled, unregistering existing MBean with ObjectName: {}", (Object)name);
                this.server.unregisterMBean(name);
            } else {
                LOG.debug("MBean already registered with ObjectName: {}", (Object)name);
            }
        }
        ObjectInstance instance = null;
        if (forceRegistration || !exists) {
            LOG.trace("Registering MBean with ObjectName: {}", (Object)name);
            instance = this.server.registerMBean(obj, name);
        }
        if (instance != null) {
            ObjectName registeredName = instance.getObjectName();
            LOG.debug("Registered MBean with ObjectName: {}", (Object)registeredName);
            this.mbeansRegistered.put(name, registeredName);
        }
    }

    protected void createMBeanServer() {
        this.server = this.findOrCreateMBeanServer();
    }

    protected MBeanServer findOrCreateMBeanServer() {
        if (this.usePlatformMBeanServer.booleanValue()) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            LOG.debug("Found MBeanServer with default domain {}", (Object)server.getDefaultDomain());
            if (!this.mBeanServerDefaultDomain.equals(server.getDefaultDomain())) continue;
            return server;
        }
        return MBeanServerFactory.createMBeanServer(this.mBeanServerDefaultDomain);
    }
}

