/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import java.util.List;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.camel.component.netty4.ChannelHandlerFactory;
import org.apache.camel.component.netty4.NettyConsumer;
import org.apache.camel.component.netty4.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty4.ServerPipelineFactory;
import org.apache.camel.component.netty4.handlers.ServerChannelHandler;
import org.apache.camel.component.netty4.ssl.SSLEngineFactory;
import org.apache.camel.util.ObjectHelper;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerPipelineFactory
extends ServerPipelineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServerPipelineFactory.class);
    private NettyConsumer consumer;
    private SSLContext sslContext;

    public DefaultServerPipelineFactory(NettyServerBootstrapConfiguration configuration) {
        this.consumer = null;
        try {
            this.sslContext = this.createSSLContext(configuration);
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    public DefaultServerPipelineFactory(NettyConsumer consumer) {
        this.consumer = consumer;
        try {
            this.sslContext = this.createSSLContext(consumer.getConfiguration());
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (this.sslContext != null) {
            LOG.info("Created SslContext {}", (Object)this.sslContext);
        }
    }

    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline channelPipeline = Channels.pipeline();
        SslHandler sslHandler = this.configureServerSSLOnDemand();
        if (sslHandler != null) {
            sslHandler.setCloseOnSSLException(true);
            LOG.debug("Server SSL handler configured and added as an interceptor against the ChannelPipeline: {}", (Object)sslHandler);
            this.addToPipeline("ssl", channelPipeline, (ChannelHandler)sslHandler);
        }
        List<ChannelHandler> encoders = this.consumer.getConfiguration().getEncoders();
        for (int x = 0; x < encoders.size(); ++x) {
            ChannelHandler encoder = encoders.get(x);
            if (encoder instanceof ChannelHandlerFactory) {
                encoder = ((ChannelHandlerFactory)encoder).newChannelHandler();
            }
            this.addToPipeline("encoder-" + x, channelPipeline, encoder);
        }
        List<ChannelHandler> decoders = this.consumer.getConfiguration().getDecoders();
        for (int x = 0; x < decoders.size(); ++x) {
            ChannelHandler decoder = decoders.get(x);
            if (decoder instanceof ChannelHandlerFactory) {
                decoder = ((ChannelHandlerFactory)decoder).newChannelHandler();
            }
            this.addToPipeline("decoder-" + x, channelPipeline, decoder);
        }
        if (this.consumer.getConfiguration().isOrderedThreadPoolExecutor()) {
            ExecutionHandler executionHandler = new ExecutionHandler((Executor)this.consumer.getEndpoint().getComponent().getExecutorService());
            this.addToPipeline("executionHandler", channelPipeline, (ChannelHandler)executionHandler);
            LOG.debug("Using OrderedMemoryAwareThreadPoolExecutor with core pool size: {}", (Object)this.consumer.getConfiguration().getMaximumPoolSize());
        }
        this.addToPipeline("handler", channelPipeline, (ChannelHandler)new ServerChannelHandler(this.consumer));
        LOG.trace("Created ChannelPipeline: {}", (Object)channelPipeline);
        return channelPipeline;
    }

    private void addToPipeline(String name, ChannelPipeline pipeline, ChannelHandler handler) {
        pipeline.addLast(name, handler);
    }

    private SSLContext createSSLContext(NettyServerBootstrapConfiguration configuration) throws Exception {
        if (!configuration.isSsl()) {
            return null;
        }
        if (configuration.getSslContextParameters() != null) {
            SSLContext context = configuration.getSslContextParameters().createSSLContext();
            return context;
        }
        return null;
    }

    private SslHandler configureServerSSLOnDemand() throws Exception {
        if (!this.consumer.getConfiguration().isSsl()) {
            return null;
        }
        if (this.consumer.getConfiguration().getSslHandler() != null) {
            return this.consumer.getConfiguration().getSslHandler();
        }
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            engine.setNeedClientAuth(this.consumer.getConfiguration().isNeedClientAuth());
            return new SslHandler(engine);
        }
        if (this.consumer.getConfiguration().getKeyStoreFile() == null && this.consumer.getConfiguration().getKeyStoreResource() == null) {
            LOG.debug("keystorefile is null");
        }
        if (this.consumer.getConfiguration().getTrustStoreFile() == null && this.consumer.getConfiguration().getTrustStoreResource() == null) {
            LOG.debug("truststorefile is null");
        }
        if (this.consumer.getConfiguration().getPassphrase().toCharArray() == null) {
            LOG.debug("passphrase is null");
        }
        SSLEngineFactory sslEngineFactory = this.consumer.getConfiguration().getKeyStoreFile() != null || this.consumer.getConfiguration().getTrustStoreFile() != null ? new SSLEngineFactory(this.consumer.getConfiguration().getKeyStoreFormat(), this.consumer.getConfiguration().getSecurityProvider(), this.consumer.getConfiguration().getKeyStoreFile(), this.consumer.getConfiguration().getTrustStoreFile(), this.consumer.getConfiguration().getPassphrase().toCharArray()) : new SSLEngineFactory(this.consumer.getContext().getClassResolver(), this.consumer.getConfiguration().getKeyStoreFormat(), this.consumer.getConfiguration().getSecurityProvider(), this.consumer.getConfiguration().getKeyStoreResource(), this.consumer.getConfiguration().getTrustStoreResource(), this.consumer.getConfiguration().getPassphrase().toCharArray());
        SSLEngine sslEngine = sslEngineFactory.createServerSSLEngine();
        sslEngine.setUseClientMode(false);
        sslEngine.setNeedClientAuth(this.consumer.getConfiguration().isNeedClientAuth());
        return new SslHandler(sslEngine);
    }

    @Override
    public ServerPipelineFactory createPipelineFactory(NettyConsumer consumer) {
        return new DefaultServerPipelineFactory(consumer);
    }
}

