/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;

public class SSLEngineFactory {
    private static final String SSL_PROTOCOL = "TLS";
    private static SSLContext sslContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineFactory(ClassResolver classResolver, String keyStoreFormat, String securityProvider, String keyStoreResource, String trustStoreResource, char[] passphrase) throws Exception {
        KeyStore ks = KeyStore.getInstance(keyStoreFormat);
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)classResolver, (String)keyStoreResource);
        try {
            ks.load(is, passphrase);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(securityProvider);
        kmf.init(ks, passphrase);
        sslContext = SSLContext.getInstance(SSL_PROTOCOL);
        if (trustStoreResource != null) {
            KeyStore ts = KeyStore.getInstance(keyStoreFormat);
            is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)classResolver, (String)trustStoreResource);
            try {
                ts.load(is, passphrase);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(securityProvider);
            tmf.init(ts);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        } else {
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public SSLEngineFactory(String keyStoreFormat, String securityProvider, File keyStoreFile, File trustStoreFile, char[] passphrase) throws Exception {
        KeyStore ks = KeyStore.getInstance(keyStoreFormat);
        InputStream is = IOConverter.toInputStream((File)keyStoreFile);
        try {
            ks.load(is, passphrase);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(securityProvider);
        kmf.init(ks, passphrase);
        sslContext = SSLContext.getInstance(SSL_PROTOCOL);
        if (trustStoreFile != null) {
            KeyStore ts = KeyStore.getInstance(keyStoreFormat);
            is = IOConverter.toInputStream((File)trustStoreFile);
            try {
                ts.load(is, passphrase);
            }
            finally {
                IOHelper.close((Closeable)is);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(securityProvider);
            tmf.init(ts);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        } else {
            sslContext.init(kmf.getKeyManagers(), null, null);
        }
    }

    public SSLEngine createServerSSLEngine() {
        SSLEngine serverEngine = sslContext.createSSLEngine();
        serverEngine.setUseClientMode(false);
        serverEngine.setNeedClientAuth(true);
        return serverEngine;
    }

    public SSLEngine createClientSSLEngine() {
        SSLEngine clientEngine = sslContext.createSSLEngine();
        clientEngine.setUseClientMode(true);
        return clientEngine;
    }
}

