/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.oaipmh.component;

import org.apache.camel.Processor;
import org.apache.camel.oaipmh.component.OAIPMHEndpoint;
import org.apache.camel.oaipmh.handler.ConsumerResponseHandler;
import org.apache.camel.oaipmh.handler.Harvester;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIPMHConsumer
extends DefaultScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(OAIPMHConsumer.class);
    private Harvester harvester;

    public OAIPMHConsumer(OAIPMHEndpoint endpoint, Processor processor) throws Exception {
        super((DefaultEndpoint)endpoint, processor);
        this.harvester = new Harvester(new ConsumerResponseHandler(this), endpoint.getUrl(), endpoint.getVerb(), endpoint.getMetadataPrefix(), endpoint.getUntil(), endpoint.getFrom(), endpoint.getSet(), endpoint.getIdentifier());
        if (endpoint.isIgnoreSSLWarnings()) {
            this.harvester.getHttpClient().setIgnoreSSLWarnings(true);
        }
    }

    protected int poll() throws Exception {
        this.harvester.asynHarvest();
        return 0;
    }
}

