/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class PackageDataFormatMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File dataFormatOutDir;
    protected File schemaOutDir;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageDataFormatMojo.prepareDataFormat(this.getLog(), this.project, this.projectHelper, this.dataFormatOutDir, this.schemaOutDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void prepareDataFormat(Log log, MavenProject project, MavenProjectHelper projectHelper, File dataFormatOutDir, File schemaOutDir) throws MojoExecutionException {
        File camelMetaDir = new File(dataFormatOutDir, "META-INF/services/org/apache/camel/");
        HashMap<String, String> javaTypes = new HashMap<String, String>();
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (Resource r : project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/dataformat")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                if (file.isDirectory()) continue;
                String name = file.getName();
                if (name.charAt(0) != '.') {
                    ++count;
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(name);
                }
                try {
                    String text = PackageHelper.loadText(new FileInputStream(file));
                    Map<String, String> map = PackageHelper.parseAsMap(text);
                    String javaType = map.get("class");
                    if (javaType == null) continue;
                    javaTypes.put(name, javaType);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
                }
            }
        }
        try {
            File core;
            Artifact camelCore;
            if (count > 0 && (camelCore = PackageDataFormatMojo.findCamelCoreArtifact(project)) != null && (core = camelCore.getFile()) != null) {
                URL url = new URL("file", null, core.getAbsolutePath());
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                for (Map.Entry entry : javaTypes.entrySet()) {
                    String json;
                    String name = (String)entry.getKey();
                    String javaType = (String)entry.getValue();
                    String modelName = PackageDataFormatMojo.asModelName(name);
                    InputStream is = loader.getResourceAsStream("org/apache/camel/model/dataformat/" + modelName + ".json");
                    if (is == null) {
                        is = new FileInputStream(new File(core, "org/apache/camel/model/dataformat/" + modelName + ".json"));
                    }
                    if ((json = PackageHelper.loadText(is)) == null) continue;
                    DataFormatModel dataFormatModel = new DataFormatModel();
                    dataFormatModel.setName(name);
                    dataFormatModel.setTitle("");
                    dataFormatModel.setModelName(modelName);
                    dataFormatModel.setLabel("");
                    dataFormatModel.setDescription(project.getDescription());
                    dataFormatModel.setJavaType(javaType);
                    dataFormatModel.setGroupId(project.getGroupId());
                    dataFormatModel.setArtifactId(project.getArtifactId());
                    dataFormatModel.setVersion(project.getVersion());
                    List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
                    for (Map<String, String> row : rows) {
                        if (row.containsKey("title")) {
                            String title = row.get("title");
                            dataFormatModel.setTitle(PackageDataFormatMojo.asModelTitle(name, title));
                        }
                        if (row.containsKey("label")) {
                            dataFormatModel.setLabel(row.get("label"));
                        }
                        if (row.containsKey("javaType")) {
                            dataFormatModel.setModelJavaType(row.get("javaType"));
                        }
                        if (!"camel-core".equals(project.getArtifactId()) || !row.containsKey("description")) continue;
                        dataFormatModel.setLabel(row.get("description"));
                    }
                    log.debug((CharSequence)("Model " + dataFormatModel));
                    String properties = PackageHelper.after(json, "  \"properties\": {");
                    String schema = PackageDataFormatMojo.createParameterJsonSchema(dataFormatModel, properties);
                    log.debug((CharSequence)("JSon schema\n" + schema));
                    File dir = new File(schemaOutDir, PackageDataFormatMojo.schemaSubDirectory(dataFormatModel.getJavaType()));
                    dir.mkdirs();
                    File out = new File(dir, name + ".json");
                    FileOutputStream fos = new FileOutputStream(out, false);
                    fos.write(schema.getBytes());
                    fos.close();
                    log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " data format"));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading dataformat model from camel-core. Reason: " + e, e);
        }
        if (count > 0) {
            Properties properties = new Properties();
            String names = buffer.toString();
            properties.put("dataFormats", names);
            properties.put("groupId", project.getGroupId());
            properties.put("artifactId", project.getArtifactId());
            properties.put("version", project.getVersion());
            properties.put("projectName", project.getName());
            if (project.getDescription() != null) {
                properties.put("projectDescription", project.getDescription());
            }
            camelMetaDir.mkdirs();
            File outFile = new File(camelMetaDir, "dataformat.properties");
            try {
                properties.store(new FileWriter(outFile), "Generated by camel-package-maven-plugin");
                log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "dataformats: " : "dataformat: ") + names));
                if (projectHelper == null) return;
                ArrayList<String> includes = new ArrayList<String>();
                includes.add("**/dataformat.properties");
                projectHelper.addResource(project, dataFormatOutDir.getPath(), includes, new ArrayList());
                projectHelper.attachArtifact(project, "properties", "camelDataFormat", outFile);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
            }
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/dataformat directory found. Are you sure you have created a Camel data format?");
        }
    }

    private static String asModelName(String name) {
        if ("json-gson".equals(name) || "json-jackson".equals(name) || "json-xstream".equals(name)) {
            return "json";
        }
        if ("bindy-csv".equals(name) || "bindy-fixed".equals(name) || "bindy-kvp".equals(name)) {
            return "bindy";
        }
        if ("zipfile".equals(name)) {
            return "zipFile";
        }
        return name;
    }

    private static String asModelTitle(String name, String title) {
        if ("json-gson".equals(name)) {
            return "JSon GSon";
        }
        if ("json-jackson".equals(name)) {
            return "JSon Jackson";
        }
        if ("json-xstream".equals(name)) {
            return "JSon XStream";
        }
        if ("bindy-csv".equals(name)) {
            return "Bindy CSV";
        }
        if ("bindy-fixed".equals(name)) {
            return "Bindy Fixed Length";
        }
        if ("bindy-kvp".equals(name)) {
            return "Bindy Key Value Pair";
        }
        return title;
    }

    private static Artifact findCamelCoreArtifact(MavenProject project) {
        Artifact artifact2 = project.getArtifact();
        if (artifact2.getGroupId().equals("org.apache.camel") && artifact2.getArtifactId().equals("camel-core")) {
            return artifact2;
        }
        for (Artifact artifact2 : project.getDependencyArtifacts()) {
            if (!artifact2.getGroupId().equals("org.apache.camel") || !artifact2.getArtifactId().equals("camel-core")) continue;
            return artifact2;
        }
        return null;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }

    private static String createParameterJsonSchema(DataFormatModel dataFormatModel, String schema) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"dataformat\": {");
        buffer.append("\n    \"name\": \"").append(dataFormatModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("dataformat").append("\",");
        buffer.append("\n    \"modelName\": \"").append(dataFormatModel.getModelName()).append("\",");
        if (dataFormatModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(dataFormatModel.getTitle()).append("\",");
        }
        if (dataFormatModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(dataFormatModel.getDescription()).append("\",");
        }
        buffer.append("\n    \"label\": \"").append(dataFormatModel.getLabel()).append("\",");
        buffer.append("\n    \"javaType\": \"").append(dataFormatModel.getJavaType()).append("\",");
        if (dataFormatModel.getModelJavaType() != null) {
            buffer.append("\n    \"modelJavaType\": \"").append(dataFormatModel.getModelJavaType()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(dataFormatModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(dataFormatModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(dataFormatModel.getVersion()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        buffer.append(schema);
        return buffer.toString();
    }

    private static class DataFormatModel {
        private String name;
        private String title;
        private String modelName;
        private String description;
        private String label;
        private String javaType;
        private String modelJavaType;
        private String groupId;
        private String artifactId;
        private String version;

        private DataFormatModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getModelJavaType() {
            return this.modelJavaType;
        }

        public void setModelJavaType(String modelJavaType) {
            this.modelJavaType = modelJavaType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "DataFormatModel[name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", modelName='" + this.modelName + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", javaType='" + this.javaType + '\'' + ", modelJavaType='" + this.modelJavaType + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

