/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class PackageLanguageMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File languageOutDir;
    protected File schemaOutDir;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PackageLanguageMojo.prepareLanguage(this.getLog(), this.project, this.projectHelper, this.languageOutDir, this.schemaOutDir);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void prepareLanguage(Log log, MavenProject project, MavenProjectHelper projectHelper, File languageOutDir, File schemaOutDir) throws MojoExecutionException {
        File camelMetaDir = new File(languageOutDir, "META-INF/services/org/apache/camel/");
        HashMap<String, String> javaTypes = new HashMap<String, String>();
        StringBuilder buffer = new StringBuilder();
        int count = 0;
        for (Resource r : project.getBuild().getResources()) {
            File[] files;
            File f = new File(r.getDirectory());
            if (!f.exists()) {
                f = new File(project.getBasedir(), r.getDirectory());
            }
            if (!(f = new File(f, "META-INF/services/org/apache/camel/language")).exists() || !f.isDirectory() || (files = f.listFiles()) == null) continue;
            for (File file : files) {
                if (file.isDirectory()) continue;
                String name = file.getName();
                if (name.charAt(0) != '.') {
                    ++count;
                    if (buffer.length() > 0) {
                        buffer.append(" ");
                    }
                    buffer.append(name);
                }
                try {
                    String text = PackageHelper.loadText(new FileInputStream(file));
                    Map<String, String> map = PackageHelper.parseAsMap(text);
                    String javaType = map.get("class");
                    if (javaType == null) continue;
                    javaTypes.put(name, javaType);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to read file " + file + ". Reason: " + e, (Exception)e);
                }
            }
        }
        try {
            File core;
            Artifact camelCore;
            if (count > 0 && (camelCore = PackageLanguageMojo.findCamelCoreArtifact(project)) != null && (core = camelCore.getFile()) != null) {
                URL url = new URL("file", null, core.getAbsolutePath());
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                for (Map.Entry entry : javaTypes.entrySet()) {
                    String json;
                    String name = (String)entry.getKey();
                    String javaType = (String)entry.getValue();
                    String modelName = PackageLanguageMojo.asModelName(name);
                    InputStream is = loader.getResourceAsStream("org/apache/camel/model/language/" + modelName + ".json");
                    if (is == null) {
                        is = new FileInputStream(new File(core, "org/apache/camel/model/language/" + modelName + ".json"));
                    }
                    if ((json = PackageHelper.loadText(is)) == null) continue;
                    LanguageModel languageModel = new LanguageModel();
                    languageModel.setName(name);
                    languageModel.setTitle("");
                    languageModel.setModelName(modelName);
                    languageModel.setLabel("");
                    languageModel.setDescription("");
                    languageModel.setJavaType(javaType);
                    languageModel.setGroupId(project.getGroupId());
                    languageModel.setArtifactId(project.getArtifactId());
                    languageModel.setVersion(project.getVersion());
                    List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
                    for (Map<String, String> row : rows) {
                        if (row.containsKey("title")) {
                            languageModel.setTitle(row.get("title"));
                        }
                        if (row.containsKey("description")) {
                            languageModel.setDescription(row.get("description"));
                        }
                        if (row.containsKey("label")) {
                            languageModel.setLabel(row.get("label"));
                        }
                        if (!row.containsKey("javaType")) continue;
                        languageModel.setModelJavaType(row.get("javaType"));
                    }
                    log.debug((CharSequence)("Model " + languageModel));
                    String properties = PackageHelper.after(json, "  \"properties\": {");
                    String schema = PackageLanguageMojo.createParameterJsonSchema(languageModel, properties);
                    log.debug((CharSequence)("JSon schema\n" + schema));
                    File dir = new File(schemaOutDir, PackageLanguageMojo.schemaSubDirectory(languageModel.getJavaType()));
                    dir.mkdirs();
                    File out = new File(dir, name + ".json");
                    FileOutputStream fos = new FileOutputStream(out, false);
                    fos.write(schema.getBytes());
                    fos.close();
                    log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " language"));
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading language model from camel-core. Reason: " + e, e);
        }
        if (count > 0) {
            Properties properties = new Properties();
            String names = buffer.toString();
            properties.put("languages", names);
            properties.put("groupId", project.getGroupId());
            properties.put("artifactId", project.getArtifactId());
            properties.put("version", project.getVersion());
            properties.put("projectName", project.getName());
            if (project.getDescription() != null) {
                properties.put("projectDescription", project.getDescription());
            }
            camelMetaDir.mkdirs();
            File outFile = new File(camelMetaDir, "language.properties");
            try {
                properties.store(new FileWriter(outFile), "Generated by camel-package-maven-plugin");
                log.info((CharSequence)("Generated " + outFile + " containing " + count + " Camel " + (count > 1 ? "languages: " : "language: ") + names));
                if (projectHelper == null) return;
                ArrayList<String> includes = new ArrayList<String>();
                includes.add("**/language.properties");
                projectHelper.addResource(project, languageOutDir.getPath(), includes, new ArrayList());
                projectHelper.attachArtifact(project, "properties", "camelLanguage", outFile);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write properties to " + outFile + ". Reason: " + e, (Exception)e);
            }
        } else {
            log.debug((CharSequence)"No META-INF/services/org/apache/camel/language directory found. Are you sure you have created a Camel language?");
        }
    }

    private static String asModelName(String name) {
        if ("bean".equals(name)) {
            return "method";
        }
        if ("file".equals(name)) {
            return "simple";
        }
        return name;
    }

    private static Artifact findCamelCoreArtifact(MavenProject project) {
        Artifact artifact2 = project.getArtifact();
        if (artifact2.getGroupId().equals("org.apache.camel") && artifact2.getArtifactId().equals("camel-core")) {
            return artifact2;
        }
        for (Artifact artifact2 : project.getDependencyArtifacts()) {
            if (!artifact2.getGroupId().equals("org.apache.camel") || !artifact2.getArtifactId().equals("camel-core")) continue;
            return artifact2;
        }
        return null;
    }

    private static String schemaSubDirectory(String javaType) {
        int idx = javaType.lastIndexOf(46);
        String pckName = javaType.substring(0, idx);
        return pckName.replace('.', '/');
    }

    private static String createParameterJsonSchema(LanguageModel languageModel, String schema) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"language\": {");
        buffer.append("\n    \"name\": \"").append(languageModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("language").append("\",");
        buffer.append("\n    \"modelName\": \"").append(languageModel.getModelName()).append("\",");
        if (languageModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(languageModel.getTitle()).append("\",");
        }
        if (languageModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(languageModel.getDescription()).append("\",");
        }
        buffer.append("\n    \"label\": \"").append(languageModel.getLabel()).append("\",");
        buffer.append("\n    \"javaType\": \"").append(languageModel.getJavaType()).append("\",");
        if (languageModel.getModelJavaType() != null) {
            buffer.append("\n    \"modelJavaType\": \"").append(languageModel.getModelJavaType()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(languageModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(languageModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(languageModel.getVersion()).append("\"");
        buffer.append("\n  },");
        buffer.append("\n  \"properties\": {");
        buffer.append(schema);
        return buffer.toString();
    }

    private static class LanguageModel {
        private String name;
        private String title;
        private String modelName;
        private String description;
        private String label;
        private String javaType;
        private String modelJavaType;
        private String groupId;
        private String artifactId;
        private String version;

        private LanguageModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getModelJavaType() {
            return this.modelJavaType;
        }

        public void setModelJavaType(String modelJavaType) {
            this.modelJavaType = modelJavaType;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "LanguageModel[name='" + this.name + '\'' + ", modelName='" + this.modelName + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", javaType='" + this.javaType + '\'' + ", modelJavaType='" + this.modelJavaType + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

