/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

public class PrepareCatalogMojo
extends AbstractMojo {
    public static final int BUFFER_SIZE = 131072;
    private static final Pattern LABEL_PATTERN = Pattern.compile("\\\"label\\\":\\s\\\"([\\w,]+)\\\"");
    protected MavenProject project;
    protected File componentsOutDir;
    protected File dataFormatsOutDir;
    protected File languagesOutDir;
    protected File modelsOutDir;
    protected File archetypesOutDir;
    protected File schemasOutDir;
    protected File componentsDir;
    protected File coreDir;
    protected File archetypesDir;
    protected File springSchemaDir;
    protected File blueprintSchemaDir;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeModel();
        this.executeComponents();
        this.executeDataFormats();
        this.executeLanguages();
        this.executeArchetypes();
        this.executeXmlSchemas();
    }

    protected void executeModel() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Copying all Camel model json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> missingLabels = new TreeSet<File>();
        TreeSet<File> missingJavaDoc = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes/org/apache/camel/model");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " model json files"));
        this.modelsOutDir.mkdirs();
        for (File file : jsonFiles) {
            File to = new File(this.modelsOutDir, file.getName());
            if (to.exists()) {
                duplicateJsonFiles.add(to);
                this.getLog().warn((CharSequence)("Duplicate model name detected: " + to));
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String text = PackageHelper.loadText(new FileInputStream(file));
                if (text.contains("\"label\": \"\"")) {
                    missingLabels.add(file);
                } else {
                    String name = PrepareCatalogMojo.asComponentName(file);
                    Matcher matcher = LABEL_PATTERN.matcher(text);
                    if (matcher.find()) {
                        String[] labels;
                        String label = matcher.group(1);
                        for (String s : labels = label.split(",")) {
                            TreeSet<String> models = (TreeSet<String>)usedLabels.get(s);
                            if (models == null) {
                                models = new TreeSet<String>();
                                usedLabels.put(s, models);
                            }
                            models.add(name);
                        }
                    }
                }
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", text, true);
                for (Map<String, String> row : rows) {
                    String doc;
                    String name = row.get("name");
                    if ("outputs".equals(name) || (doc = row.get("description")) != null && !doc.isEmpty()) continue;
                    missingJavaDoc.add(file);
                }
            }
            catch (IOException e) {}
        }
        File all = new File(this.modelsOutDir, "../models.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.modelsOutDir.list();
            ArrayList<String> models = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String modelName = name.substring(0, name.length() - 5);
                models.add(modelName);
            }
            Collections.sort(models);
            for (String name : models) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printModelsReport(jsonFiles, duplicateJsonFiles, missingLabels, usedLabels, missingJavaDoc);
    }

    protected void executeComponents() throws MojoExecutionException, MojoFailureException {
        File[] components;
        this.getLog().info((CharSequence)"Copying all Camel component json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> componentFiles = new TreeSet<File>();
        TreeSet<File> missingComponents = new TreeSet<File>();
        TreeSet<File> missingLabels = new TreeSet<File>();
        TreeSet<File> missingUriPaths = new TreeSet<File>();
        TreeSet<File> missingComponentJavaDoc = new TreeSet<File>();
        TreeSet<File> missingEndpointJavaDoc = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (components = this.componentsDir.listFiles()) != null) {
            for (File dir : components) {
                if (!dir.isDirectory() || "camel-jetty9".equals(dir.getName()) || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                if ("camel-salesforce".equals(dir.getName())) {
                    target = new File(dir, "camel-salesforce-component/target/classes");
                } else if ("camel-linkedin".equals(dir.getName())) {
                    target = new File(dir, "camel-linkedin-component/target/classes");
                }
                int before = componentFiles.size();
                int before2 = jsonFiles.size();
                this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
                int after = componentFiles.size();
                int after2 = jsonFiles.size();
                if (before == after || before2 != after2) continue;
                missingComponents.add(dir);
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            int before = componentFiles.size();
            int before2 = jsonFiles.size();
            this.findComponentFilesRecursive(target, jsonFiles, componentFiles, new CamelComponentsFileFilter());
            int after = componentFiles.size();
            int after2 = jsonFiles.size();
            if (before != after && before2 == after2) {
                missingComponents.add(this.coreDir);
            }
        }
        this.getLog().info((CharSequence)("Found " + componentFiles.size() + " component.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " component json files"));
        this.componentsOutDir.mkdirs();
        for (File file : jsonFiles) {
            File to = new File(this.componentsOutDir, file.getName());
            if (to.exists()) {
                duplicateJsonFiles.add(to);
                this.getLog().warn((CharSequence)("Duplicate component name detected: " + to));
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String doc;
                String text = PackageHelper.loadText(new FileInputStream(file));
                if (text.contains("\"label\": \"\"")) {
                    missingLabels.add(file);
                } else {
                    String name = PrepareCatalogMojo.asComponentName(file);
                    Matcher matcher = LABEL_PATTERN.matcher(text);
                    if (matcher.find()) {
                        String[] labels;
                        String label = matcher.group(1);
                        for (String s : labels = label.split(",")) {
                            TreeSet<String> components2 = (TreeSet<String>)usedLabels.get(s);
                            if (components2 == null) {
                                components2 = new TreeSet<String>();
                                usedLabels.put(s, components2);
                            }
                            components2.add(name);
                        }
                    }
                }
                if (!text.contains("\"kind\": \"path\"")) {
                    missingUriPaths.add(file);
                }
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("componentProperties", text, true);
                for (Map<String, String> row : rows) {
                    doc = row.get("description");
                    if (doc != null && !doc.isEmpty()) continue;
                    missingComponentJavaDoc.add(file);
                    break;
                }
                rows = JSonSchemaHelper.parseJsonSchema("properties", text, true);
                for (Map<String, String> row : rows) {
                    doc = row.get("description");
                    if (doc != null && !doc.isEmpty()) continue;
                    missingEndpointJavaDoc.add(file);
                }
            }
            catch (IOException e) {}
        }
        File all = new File(this.componentsOutDir, "../components.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.componentsOutDir.list();
            ArrayList<String> components3 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String componentName = name.substring(0, name.length() - 5);
                components3.add(componentName);
            }
            Collections.sort(components3);
            for (String name : components3) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printComponentsReport(jsonFiles, duplicateJsonFiles, missingComponents, missingEndpointJavaDoc, missingComponentJavaDoc, missingUriPaths, missingLabels, usedLabels);
    }

    protected void executeDataFormats() throws MojoExecutionException, MojoFailureException {
        File[] dataFormats;
        this.getLog().info((CharSequence)"Copying all Camel dataformat json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        TreeSet<File> missingLabels = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (dataFormats = this.componentsDir.listFiles()) != null) {
            for (File dir : dataFormats) {
                if (!dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findDataFormatFilesRecursive(target, jsonFiles, dataFormatFiles, new CamelDataFormatsFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + dataFormatFiles.size() + " dataformat.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " dataformat json files"));
        this.dataFormatsOutDir.mkdirs();
        for (File file : jsonFiles) {
            File to = new File(this.dataFormatsOutDir, file.getName());
            if (to.exists()) {
                duplicateJsonFiles.add(to);
                this.getLog().warn((CharSequence)("Duplicate dataformat name detected: " + to));
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String[] labels;
                String text = PackageHelper.loadText(new FileInputStream(file));
                if (text.contains("\"label\": \"\"")) {
                    missingLabels.add(file);
                    continue;
                }
                String name = PrepareCatalogMojo.asComponentName(file);
                Matcher matcher = LABEL_PATTERN.matcher(text);
                if (!matcher.find()) continue;
                String label = matcher.group(1);
                for (String s : labels = label.split(",")) {
                    TreeSet<String> dataFormats2 = (TreeSet<String>)usedLabels.get(s);
                    if (dataFormats2 == null) {
                        dataFormats2 = new TreeSet<String>();
                        usedLabels.put(s, dataFormats2);
                    }
                    dataFormats2.add(name);
                }
            }
            catch (IOException e) {
            }
        }
        File all = new File(this.dataFormatsOutDir, "../dataformats.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.dataFormatsOutDir.list();
            ArrayList<String> dataFormats3 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String dataFormatName = name.substring(0, name.length() - 5);
                dataFormats3.add(dataFormatName);
            }
            Collections.sort(dataFormats3);
            for (String name : dataFormats3) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printDataFormatsReport(jsonFiles, duplicateJsonFiles, missingLabels, usedLabels);
    }

    protected void executeLanguages() throws MojoExecutionException, MojoFailureException {
        File[] languages;
        this.getLog().info((CharSequence)"Copying all Camel language json descriptors");
        TreeSet<File> jsonFiles = new TreeSet<File>();
        TreeSet<File> duplicateJsonFiles = new TreeSet<File>();
        TreeSet<File> languageFiles = new TreeSet<File>();
        TreeSet<File> missingLabels = new TreeSet<File>();
        TreeMap<String, Set<String>> usedLabels = new TreeMap<String, Set<String>>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (languages = this.componentsDir.listFiles()) != null) {
            for (File dir : languages) {
                if (!dir.isDirectory() || "target".equals(dir.getName())) continue;
                File target = new File(dir, "target/classes");
                this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
            }
        }
        if (this.coreDir != null && this.coreDir.isDirectory()) {
            File target = new File(this.coreDir, "target/classes");
            this.findLanguageFilesRecursive(target, jsonFiles, languageFiles, new CamelLanguagesFileFilter());
        }
        this.getLog().info((CharSequence)("Found " + languageFiles.size() + " language.properties files"));
        this.getLog().info((CharSequence)("Found " + jsonFiles.size() + " language json files"));
        this.languagesOutDir.mkdirs();
        for (File file : jsonFiles) {
            File to = new File(this.languagesOutDir, file.getName());
            if (to.exists()) {
                duplicateJsonFiles.add(to);
                this.getLog().warn((CharSequence)("Duplicate language name detected: " + to));
            }
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
            try {
                String[] labels;
                String text = PackageHelper.loadText(new FileInputStream(file));
                if (text.contains("\"label\": \"\"")) {
                    missingLabels.add(file);
                    continue;
                }
                String name = PrepareCatalogMojo.asComponentName(file);
                Matcher matcher = LABEL_PATTERN.matcher(text);
                if (!matcher.find()) continue;
                String label = matcher.group(1);
                for (String s : labels = label.split(",")) {
                    TreeSet<String> languages2 = (TreeSet<String>)usedLabels.get(s);
                    if (languages2 == null) {
                        languages2 = new TreeSet<String>();
                        usedLabels.put(s, languages2);
                    }
                    languages2.add(name);
                }
            }
            catch (IOException e) {
            }
        }
        File all = new File(this.languagesOutDir, "../languages.properties");
        try {
            FileOutputStream fos = new FileOutputStream(all, false);
            String[] names = this.languagesOutDir.list();
            ArrayList<String> languages3 = new ArrayList<String>();
            for (String name : names) {
                if (!name.endsWith(".json")) continue;
                String languageName = name.substring(0, name.length() - 5);
                languages3.add(languageName);
            }
            Collections.sort(languages3);
            for (String name : languages3) {
                fos.write(name.getBytes());
                fos.write("\n".getBytes());
            }
            fos.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Error writing to file " + all);
        }
        this.printLanguagesReport(jsonFiles, duplicateJsonFiles, missingLabels, usedLabels);
    }

    protected void executeArchetypes() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Copying Archetype Catalog");
        File file = new File(this.archetypesDir, "target/classes/archetype-catalog.xml");
        this.archetypesOutDir.mkdirs();
        if (file.exists() && file.isFile()) {
            File to = new File(this.archetypesOutDir, file.getName());
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
    }

    protected void executeXmlSchemas() throws MojoExecutionException, MojoFailureException {
        File to;
        this.getLog().info((CharSequence)"Copying Spring/Blueprint XML schemas");
        this.schemasOutDir.mkdirs();
        File file = new File(this.springSchemaDir, "camel-spring.xsd");
        if (file.exists() && file.isFile()) {
            to = new File(this.schemasOutDir, file.getName());
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
        if ((file = new File(this.blueprintSchemaDir, "camel-blueprint.xsd")).exists() && file.isFile()) {
            to = new File(this.schemasOutDir, file.getName());
            try {
                PrepareCatalogMojo.copyFile(file, to);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot copy file from " + file + " -> " + to, (Throwable)e);
            }
        }
    }

    private void printModelsReport(Set<File> json, Set<File> duplicate, Set<File> missingLabels, Map<String, Set<String>> usedLabels, Set<File> missingJavaDoc) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel model catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tModels found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate models detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missingLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing labels detected: " + missingLabels.size()));
            for (File file : missingLabels) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingJavaDoc.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing javadoc on models: " + missingJavaDoc.size()));
            for (File file : missingJavaDoc) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printComponentsReport(Set<File> json, Set<File> duplicate, Set<File> missing, Set<File> missingEndpointJavaDoc, Set<File> missingComponentJavaDoc, Set<File> missingUriPaths, Set<File> missingLabels, Map<String, Set<String>> usedLabels) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel component catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tComponents found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate components detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        if (!missingLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing labels detected: " + missingLabels.size()));
            for (File file : missingLabels) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missingUriPaths.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing @UriPath detected: " + missingUriPaths.size()));
            for (File file : missingUriPaths) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missingComponentJavaDoc.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing component options javadoc detected: " + missingComponentJavaDoc.size()));
            for (File file : missingComponentJavaDoc) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missingEndpointJavaDoc.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing endpoint options javadoc detected: " + missingEndpointJavaDoc.size()));
            for (File file : missingEndpointJavaDoc) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missing.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing components detected: " + missing.size()));
            for (File file : missing) {
                this.getLog().warn((CharSequence)("\t\t" + file.getName()));
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printDataFormatsReport(Set<File> json, Set<File> duplicate, Set<File> missingLabels, Map<String, Set<String>> usedLabels) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel data format catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tDataFormats found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate dataformat detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missingLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing labels detected: " + missingLabels.size()));
            for (File file : missingLabels) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private void printLanguagesReport(Set<File> json, Set<File> duplicate, Set<File> missingLabels, Map<String, Set<String>> usedLabels) {
        this.getLog().info((CharSequence)"================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"Camel language catalog report");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("\tLanguages found: " + json.size()));
        for (File file : json) {
            this.getLog().info((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
        }
        if (!duplicate.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tDuplicate language detected: " + duplicate.size()));
            for (File file : duplicate) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!missingLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().warn((CharSequence)("\tMissing labels detected: " + missingLabels.size()));
            for (File file : missingLabels) {
                this.getLog().warn((CharSequence)("\t\t" + PrepareCatalogMojo.asComponentName(file)));
            }
        }
        if (!usedLabels.isEmpty()) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("\tUsed labels: " + usedLabels.size()));
            for (Map.Entry entry : usedLabels.entrySet()) {
                this.getLog().info((CharSequence)("\t\t" + (String)entry.getKey() + ":"));
                for (String name : (Set)entry.getValue()) {
                    this.getLog().info((CharSequence)("\t\t\t" + name));
                }
            }
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"================================================================================");
    }

    private static String asComponentName(File file) {
        String name = file.getName();
        if (name.endsWith(".json")) {
            return name.substring(0, name.length() - 5);
        }
        return name;
    }

    private void findComponentFilesRecursive(File dir, Set<File> found, Set<File> components, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean componentFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = componentFile = !rootDir && file.isFile() && file.getName().equals("component.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (componentFile) {
                    components.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findComponentFilesRecursive(file, found, components, filter);
            }
        }
    }

    private void findDataFormatFilesRecursive(File dir, Set<File> found, Set<File> dataFormats, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean dataFormatFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = dataFormatFile = !rootDir && file.isFile() && file.getName().equals("dataformat.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (dataFormatFile) {
                    dataFormats.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findDataFormatFilesRecursive(file, found, dataFormats, filter);
            }
        }
    }

    private void findLanguageFilesRecursive(File dir, Set<File> found, Set<File> languages, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean languageFile;
                boolean rootDir = "classes".equals(dir.getName()) || "META-INF".equals(dir.getName());
                boolean jsonFile = !rootDir && file.isFile() && file.getName().endsWith(".json");
                boolean bl = languageFile = !rootDir && file.isFile() && file.getName().equals("language.properties");
                if (jsonFile) {
                    found.add(file);
                    continue;
                }
                if (languageFile) {
                    languages.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findLanguageFilesRecursive(file, found, languages, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(from).getChannel();
            out = new FileOutputStream(to).getChannel();
            long size = in.size();
            for (long position = 0L; position < size; position += in.transferTo(position, 131072L, (WritableByteChannel)((Object)out))) {
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private class CamelLanguagesFileFilter
    implements FileFilter {
        private CamelLanguagesFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"language\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("language.properties");
        }
    }

    private class CamelDataFormatsFileFilter
    implements FileFilter {
        private CamelDataFormatsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"dataformat\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("dataformat.properties");
        }
    }

    private class CamelComponentsFileFilter
    implements FileFilter {
        private CamelComponentsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (pathname.isDirectory() && pathname.getName().equals("model")) {
                return false;
            }
            if (pathname.isFile() && pathname.getName().endsWith(".json")) {
                try {
                    String json = PackageHelper.loadText(new FileInputStream(pathname));
                    return json != null && json.contains("\"kind\": \"component\"");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return pathname.isDirectory() || pathname.isFile() && pathname.getName().equals("component.properties");
        }
    }
}

