/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-eips-list", threadSafe=true)
public class PackageModelMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.build.directory}/generated/camel/models")
    protected File outDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelMetaDir = new File(this.outDir, "META-INF/services/org/apache/camel/");
        camelMetaDir.mkdirs();
        TreeSet<File> jsonFiles = new TreeSet<File>();
        if (this.buildDir != null && this.buildDir.isDirectory()) {
            File target = new File(this.buildDir, "classes/org/apache/camel/model");
            PackageHelper.findJsonFiles(target, jsonFiles, new PackageHelper.CamelComponentsModelFilter());
        }
        ArrayList<String> models = new ArrayList<String>();
        for (File file : jsonFiles) {
            String name = file.getName();
            if (!name.endsWith(".json")) continue;
            String modelName = name.substring(0, name.length() - 5);
            models.add(modelName);
        }
        Collections.sort(models);
        StringBuilder sb = new StringBuilder();
        sb.append("# Generated by camel build tools\n");
        for (String name : models) {
            sb.append(name).append("\n");
        }
        Path path = camelMetaDir.toPath().resolve("model.properties");
        this.updateResource(path, sb.toString());
        this.getLog().info((CharSequence)("Generated " + path + " containing " + models.size() + " Camel models"));
        this.addResourceDirectory(this.outDir.toPath());
    }
}

