/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.StringHelper;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="generate-others-list", threadSafe=true)
public class PackageOtherMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}/generated/camel/others")
    protected File otherOutDir;
    @Parameter(defaultValue="${project.build.directory}/classes")
    protected File schemaOutDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File f = new File(this.project.getBasedir(), "target/classes");
        File comp = new File(f, "META-INF/services/org/apache/camel/component");
        if (comp.exists() && comp.isDirectory()) {
            return;
        }
        File df = new File(f, "META-INF/services/org/apache/camel/dataformat");
        if (df.exists() && df.isDirectory()) {
            return;
        }
        File lan = new File(f, "META-INF/services/org/apache/camel/language");
        if (lan.exists() && lan.isDirectory()) {
            return;
        }
        PackageOtherMojo.prepareOthers(this.getLog(), this.project, this.projectHelper, this.otherOutDir, this.schemaOutDir, this.buildContext);
    }

    public static void prepareOthers(Log log, MavenProject project, MavenProjectHelper projectHelper, File otherOutDir, File schemaOutDir, BuildContext buildContext) throws MojoExecutionException {
        String name;
        if (projectHelper != null) {
            projectHelper.addResource(project, otherOutDir.getPath(), Collections.singletonList("**/other.properties"), Collections.emptyList());
        }
        if ((name = project.getArtifactId()).startsWith("camel-")) {
            name = name.substring(6);
        }
        try {
            OtherModel otherModel = new OtherModel();
            otherModel.setName(name);
            otherModel.setGroupId(project.getGroupId());
            otherModel.setArtifactId(project.getArtifactId());
            otherModel.setVersion(project.getVersion());
            otherModel.setDescription(project.getDescription());
            if (project.getName() != null && project.getName().contains("(deprecated)")) {
                otherModel.setDeprecated("true");
            } else {
                otherModel.setDeprecated("false");
            }
            otherModel.setFirstVersion(project.getProperties().getProperty("firstVersion"));
            otherModel.setLabel(project.getProperties().getProperty("label"));
            String title = project.getProperties().getProperty("title");
            if (title == null) {
                title = StringHelper.camelDashToTitle(name);
            }
            otherModel.setTitle(title);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Model: " + otherModel));
            }
            String schema = PackageOtherMojo.createJsonSchema(otherModel);
            Path out = schemaOutDir.toPath().resolve(name + ".json");
            PackageOtherMojo.updateResource(buildContext, out, schema);
            if (log.isDebugEnabled()) {
                log.debug((CharSequence)("Generated " + out + " containing JSon schema for " + name + " other"));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error loading other model. Reason: " + e, e);
        }
        File camelMetaDir = new File(otherOutDir, "META-INF/services/org/apache/camel/");
        Path outFile = camelMetaDir.toPath().resolve("other.properties");
        String properties = PackageOtherMojo.createProperties(project, "name", name);
        PackageOtherMojo.updateResource(buildContext, outFile, properties);
        log.info((CharSequence)("Generated " + outFile + " containing 1 Camel other: " + name));
    }

    private static String createJsonSchema(OtherModel otherModel) {
        StringBuilder buffer = new StringBuilder("{");
        buffer.append("\n \"other\": {");
        buffer.append("\n    \"name\": \"").append(otherModel.getName()).append("\",");
        buffer.append("\n    \"kind\": \"").append("other").append("\",");
        if (otherModel.getTitle() != null) {
            buffer.append("\n    \"title\": \"").append(otherModel.getTitle()).append("\",");
        }
        if (otherModel.getDescription() != null) {
            buffer.append("\n    \"description\": \"").append(otherModel.getDescription()).append("\",");
        }
        buffer.append("\n    \"deprecated\": \"").append(otherModel.getDeprecated()).append("\",");
        if (otherModel.getFirstVersion() != null) {
            buffer.append("\n    \"firstVersion\": \"").append(otherModel.getFirstVersion()).append("\",");
        }
        if (otherModel.getLabel() != null) {
            buffer.append("\n    \"label\": \"").append(otherModel.getLabel()).append("\",");
        }
        buffer.append("\n    \"groupId\": \"").append(otherModel.getGroupId()).append("\",");
        buffer.append("\n    \"artifactId\": \"").append(otherModel.getArtifactId()).append("\",");
        buffer.append("\n    \"version\": \"").append(otherModel.getVersion()).append("\"");
        buffer.append("\n  }");
        buffer.append("\n}");
        return buffer.toString();
    }

    private static class OtherModel {
        private String name;
        private String title;
        private String description;
        private String deprecated;
        private String deprecationNote;
        private String firstVersion;
        private String label;
        private String groupId;
        private String artifactId;
        private String version;

        private OtherModel() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDeprecated() {
            return this.deprecated;
        }

        public void setDeprecated(String deprecated) {
            this.deprecated = deprecated;
        }

        public String getDeprecationNote() {
            return this.deprecationNote;
        }

        public void setDeprecationNote(String deprecationNote) {
            this.deprecationNote = deprecationNote;
        }

        public String getFirstVersion() {
            return this.firstVersion;
        }

        public void setFirstVersion(String firstVersion) {
            this.firstVersion = firstVersion;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "OtherModel[name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", label='" + this.label + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ']';
        }
    }
}

