/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.JSonSchemaHelper;
import org.apache.camel.maven.packaging.PackageHelper;
import org.apache.camel.maven.packaging.SpringBootHelper;
import org.apache.camel.maven.packaging.model.ComponentModel;
import org.apache.camel.maven.packaging.model.ComponentOptionModel;
import org.apache.camel.maven.packaging.model.DataFormatModel;
import org.apache.camel.maven.packaging.model.DataFormatOptionModel;
import org.apache.camel.maven.packaging.model.EndpointOptionModel;
import org.apache.camel.maven.packaging.model.LanguageModel;
import org.apache.camel.maven.packaging.model.LanguageOptionModel;
import org.apache.camel.maven.packaging.model.OtherModel;
import org.apache.camel.maven.packaging.model.OtherOptionModel;
import org.apache.camel.maven.packaging.srcgen.Annotation;
import org.apache.camel.maven.packaging.srcgen.GenericType;
import org.apache.camel.maven.packaging.srcgen.JavaClass;
import org.apache.camel.maven.packaging.srcgen.Method;
import org.apache.camel.maven.packaging.srcgen.Property;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.forge.roaster.model.util.Strings;
import org.objectweb.asm.ClassWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Mojo(name="prepare-spring-boot-auto-configuration", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class SpringBootAutoConfigurationMojo
extends AbstractMojo {
    private static final boolean DELETE_FILES_ON_MAIN_ARTIFACTS = false;
    private static final String INNER_TYPE_SUFFIX = "NestedConfiguration";
    private static final Pattern INCLUDE_INNER_PATTERN = Pattern.compile("org\\.apache\\.camel\\..*");
    private static final boolean ADD_NESTED_CONFIGURATION_PROPERTY = false;
    private static final Map<String, String> PRIMITIVEMAP;
    private static final Map<Type, Type> PRIMITIVE_CLASSES;
    private static final List<String> JAVA_LANG_TYPES;
    private static final String[] IGNORE_MODULES;
    @Parameter(defaultValue="${project.build.directory}/classes")
    protected File classesDir;
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${basedir}")
    protected File baseDir;
    DynamicClassLoader projectClassLoader;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (Arrays.asList(IGNORE_MODULES).contains(this.project.getArtifactId())) {
            this.getLog().info((CharSequence)"Component auto-configuration will not be created: component contained in the ignore list");
            return;
        }
        File starterDir = SpringBootHelper.starterDir(this.baseDir, this.project.getArtifactId());
        if (!starterDir.exists() || !new File(starterDir, "pom.xml").exists()) {
            this.getLog().info((CharSequence)"Component auto-configuration will not be created: the starter does not exist");
            return;
        }
        this.executeAll();
    }

    private void executeAll() throws MojoExecutionException, MojoFailureException {
        Map<File, Supplier<String>> files = PackageHelper.findJsonFiles(this.buildDir, p -> p.isDirectory() || p.getName().endsWith(".json")).stream().collect(Collectors.toMap(Function.identity(), s -> SpringBootAutoConfigurationMojo.cache(() -> SpringBootAutoConfigurationMojo.loadJson(s))));
        this.executeModels(files);
        this.executeComponent(files);
        this.executeDataFormat(files);
        this.executeLanguage(files);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadJson(File file) {
        try (FileInputStream is = new FileInputStream(file);){
            String string = PackageHelper.loadText(is);
            return string;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static <T> Supplier<T> cache(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }

    private void executeModels(Map<File, Supplier<String>> files) throws MojoExecutionException, MojoFailureException {
        String pkg;
        int pos;
        OtherModel model;
        String json = SpringBootAutoConfigurationMojo.loadModelJson(files, "hystrixConfiguration");
        if (json != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.hystrix", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "consulServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.consul.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "dnsServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.dns.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "etcdServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.etcd.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "kubernetesServiceDiscovery")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.kubernetes.service-discovery", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "ribbonLoadBalancer")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createOtherModelConfigurationSource(pkg, model, "camel.cloud.ribbon.load-balancer", true);
        }
        if ((json = SpringBootAutoConfigurationMojo.loadModelJson(files, "restConfiguration")) != null) {
            model = this.generateOtherModel(json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createRestConfigurationSource(pkg, model, "camel.rest");
            this.createRestModuleAutoConfigurationSource(pkg, model);
        }
    }

    private void createOtherModelConfigurationSource(String packageName, OtherModel model, String propertiesPrefix, boolean generatedNestedConfig) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String commonName = model.getJavaType().substring(pos + 1) + (generatedNestedConfig ? "Common" : "Properties");
        String configName = model.getJavaType().substring(pos + 1) + (generatedNestedConfig ? "Properties" : null);
        JavaClass commonClass = new JavaClass(this.getProjectClassLoader());
        commonClass.setPackage(packageName);
        commonClass.setName(commonName);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        commonClass.getJavaDoc().setFullText(doc);
        commonClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        for (OtherOptionModel option : model.getOptions()) {
            String type = option.getJavaType();
            String name = option.getName();
            if ("id".equalsIgnoreCase(name) || "parent".equalsIgnoreCase(name) || "camelContext".equalsIgnoreCase(name)) continue;
            if ("java.util.List<org.apache.camel.model.PropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.String>";
            }
            Property prop = commonClass.addProperty(type, option.getName());
            if (!Strings.isBlank((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(type)) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(type) || "java.lang.Long".equals(type)) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            commonClass.addImport(model.getJavaType());
        }
        this.writeSourceIfChanged(commonClass, packageName.replaceAll("\\.", "\\/") + "/" + commonName + ".java", true);
        Class commonClazz = this.generateDummyClass(commonClass.getCanonicalName());
        if (generatedNestedConfig) {
            JavaClass configClass = new JavaClass(this.getProjectClassLoader());
            configClass.setPackage(packageName);
            configClass.setName(configName);
            configClass.extendSuperType(commonClass);
            configClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
            configClass.addAnnotation(this.loadClass("org.springframework.boot.context.properties.ConfigurationProperties")).setStringValue("prefix", propertiesPrefix);
            configClass.addImport(Map.class);
            configClass.addImport(HashMap.class);
            configClass.removeImport(commonClass);
            configClass.addField().setName("enabled").setType(Boolean.TYPE).setPrivate().setLiteralInitializer("true").getJavaDoc().setFullText("Enable the component");
            configClass.addField().setName("configurations").setType(this.loadType("java.util.Map<java.lang.String, " + packageName + "." + commonName + ">")).setPrivate().setLiteralInitializer("new HashMap<>()").getJavaDoc().setFullText("Define additional configuration definitions");
            Method method = configClass.addMethod();
            method.setName("getConfigurations");
            method.setReturnType(this.loadType("java.util.Map<java.lang.String, " + packageName + "." + commonName + ">"));
            method.setPublic();
            method.setBody("return configurations;");
            method = configClass.addMethod();
            method.setName("isEnabled");
            method.setReturnType(Boolean.TYPE);
            method.setPublic();
            method.setBody("return enabled;");
            method = configClass.addMethod();
            method.setName("setEnabled");
            method.addParameter(Boolean.TYPE, "enabled");
            method.setPublic();
            method.setBody("this.enabled = enabled;");
            String fileName = packageName.replaceAll("\\.", "\\/") + "/" + configName + ".java";
            this.writeSourceIfChanged(configClass, fileName, true);
        }
    }

    private void createRestConfigurationSource(String packageName, OtherModel model, String propertiesPrefix) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String className = model.getJavaType().substring(pos + 1) + "Properties";
        this.generateDummyClass(packageName + "." + className);
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(className);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", propertiesPrefix);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        for (OtherOptionModel option : model.getOptions()) {
            String type = option.getJavaType();
            String name = option.getName();
            if ("id".equalsIgnoreCase(name) || "parent".equalsIgnoreCase(name) || "camelContext".equalsIgnoreCase(name)) continue;
            if ("java.util.List<org.apache.camel.model.PropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.String>";
            } else if ("java.util.List<org.apache.camel.model.rest.RestPropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.Object>";
            }
            if ("enableCORS".equalsIgnoreCase(name)) {
                name = "enableCors";
            }
            Property prop = javaClass.addProperty(type, name);
            if (!Strings.isBlank((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(type)) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(type) || "java.lang.Long".equals(type)) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + className + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private void createRestModuleAutoConfigurationSource(String packageName, OtherModel model) throws MojoFailureException {
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1) + "AutoConfiguration";
        String configType = model.getJavaType().substring(pos + 1) + "Properties";
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        javaClass.getJavaDoc().setFullText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(ConditionalOnBean.class).setStringValue("type", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(ConditionalOnProperty.class).setStringValue("name", "camel.rest.enabled").setLiteralValue("matchIfMissing", "true");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("value", configType + ".class");
        javaClass.addImport("java.util.Map");
        javaClass.addImport("java.util.HashMap");
        javaClass.addImport("org.apache.camel.util.CollectionHelper");
        javaClass.addImport("org.apache.camel.support.IntrospectionSupport");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.model.rest.RestConstants");
        javaClass.addImport("org.apache.camel.spi.RestConfiguration");
        javaClass.addField().setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext")).setPrivate().addAnnotation(Autowired.class);
        javaClass.addField().setName("config").setType(this.loadClass(packageName + "." + configType)).setPrivate().addAnnotation(Autowired.class);
        Method method = javaClass.addMethod();
        method.setName("configure" + model.getShortJavaType());
        method.setPublic();
        method.addThrows(Exception.class);
        method.setReturnType(this.loadClass("org.apache.camel.spi.RestConfiguration"));
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class).setLiteralValue("name", "RestConstants.DEFAULT_REST_CONFIGURATION_ID");
        method.addAnnotation(ConditionalOnClass.class).setLiteralValue("value", "CamelContext.class");
        method.addAnnotation(ConditionalOnMissingBean.class);
        method.setBody("Map<String, Object> properties = new HashMap<>();\nIntrospectionSupport.getProperties(config, properties, null, false);\n// These options is configured specially further below, so remove them first\nproperties.remove(\"enableCors\");\nproperties.remove(\"apiProperty\");\nproperties.remove(\"componentProperty\");\nproperties.remove(\"consumerProperty\");\nproperties.remove(\"dataFormatProperty\");\nproperties.remove(\"endpointProperty\");\nproperties.remove(\"corsHeaders\");\n\nRestConfiguration definition = new RestConfiguration();\nCamelPropertiesHelper.setCamelProperties(camelContext, definition, properties, true);\n\n// Workaround for spring-boot properties name as It would appear\n// as enable-c-o-r-s if left uppercase in Configuration\ndefinition.setEnableCORS(config.getEnableCors());\n\nif (config.getApiProperty() != null) {\n    definition.setApiProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getApiProperty(), \".\")));\n}\nif (config.getComponentProperty() != null) {\n    definition.setComponentProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getComponentProperty(), \".\")));\n}\nif (config.getConsumerProperty() != null) {\n    definition.setConsumerProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getConsumerProperty(), \".\")));\n}\nif (config.getDataFormatProperty() != null) {\n    definition.setDataFormatProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getDataFormatProperty(), \".\")));\n}\nif (config.getEndpointProperty() != null) {\n    definition.setEndpointProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getEndpointProperty(), \".\")));\n}\nif (config.getCorsHeaders() != null) {\n    Map<String, Object> map = CollectionHelper.flattenKeysInMap(config.getCorsHeaders(), \".\");\n    Map<String, String> target = new HashMap<>();\n    map.forEach((k, v) -> target.put(k, v.toString()));\n    definition.setCorsHeaders(target);\n}\nreturn definition;");
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void executeComponent(Map<File, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException {
        TreeSet<String> componentNames = new TreeSet<String>();
        this.findComponentNames(this.buildDir, componentNames);
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            LinkedList<ComponentModel> allModels = new LinkedList<ComponentModel>();
            for (String componentName : componentNames) {
                String json = SpringBootAutoConfigurationMojo.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                ComponentModel model = SpringBootAutoConfigurationMojo.generateComponentModel(componentName, json);
                allModels.add(model);
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(ComponentModel::getJavaType));
            for (String componentClass : grModels.keySet()) {
                List<ComponentModel> compModels = grModels.get(componentClass);
                ComponentModel model = compModels.get(0);
                List<String> aliases = compModels.stream().map(ComponentModel::getScheme).sorted().collect(Collectors.toList());
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideComponentName = null;
                if (aliases.size() > 1) {
                    overrideComponentName = model.getArtifactId().replace("camel-", "");
                }
                this.createComponentConfigurationSource(pkg, model, overrideComponentName);
                this.createComponentAutoConfigurationSource(pkg, model, aliases, overrideComponentName);
                this.createComponentSpringFactorySource(pkg, model);
            }
        }
    }

    private void executeDataFormat(Map<File, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException {
        List<String> dataFormatNames = this.findDataFormatNames();
        if (!dataFormatNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + dataFormatNames.size() + " dataformats"));
            LinkedList<DataFormatModel> allModels = new LinkedList<DataFormatModel>();
            for (String dataFormatName : dataFormatNames) {
                String json = SpringBootAutoConfigurationMojo.loadDataFormatJson(jsonFiles, dataFormatName);
                if (json == null) continue;
                DataFormatModel model = SpringBootAutoConfigurationMojo.generateDataFormatModel(dataFormatName, json);
                allModels.add(model);
            }
            Map<String, List<DataFormatModel>> grModels = allModels.stream().collect(Collectors.groupingBy(DataFormatModel::getJavaType));
            for (String dataFormatClass : grModels.keySet()) {
                List<DataFormatModel> dfModels = grModels.get(dataFormatClass);
                DataFormatModel model = dfModels.get(0);
                List<String> aliases = dfModels.stream().map(DataFormatModel::getName).sorted().collect(Collectors.toList());
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideDataFormatName = null;
                if (aliases.size() > 1) {
                    overrideDataFormatName = model.getArtifactId().replace("camel-", "");
                }
                this.createDataFormatConfigurationSource(pkg, model, overrideDataFormatName);
                this.createDataFormatAutoConfigurationSource(pkg, model, aliases, overrideDataFormatName);
                this.createDataFormatSpringFactorySource(pkg, model);
            }
        }
    }

    private void executeLanguage(Map<File, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException {
        List<String> languageNames = this.findLanguageNames();
        if (!languageNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + languageNames.size() + " languages"));
            LinkedList<LanguageModel> allModels = new LinkedList<LanguageModel>();
            for (String languageName : languageNames) {
                String json = SpringBootAutoConfigurationMojo.loadLanguageJson(jsonFiles, languageName);
                if (json == null) continue;
                LanguageModel model = SpringBootAutoConfigurationMojo.generateLanguageModel(languageName, json);
                allModels.add(model);
            }
            Map<String, List<LanguageModel>> grModels = allModels.stream().collect(Collectors.groupingBy(LanguageModel::getJavaType));
            for (String languageClass : grModels.keySet()) {
                List<LanguageModel> dfModels = grModels.get(languageClass);
                LanguageModel model = dfModels.get(0);
                List<String> aliases = dfModels.stream().map(LanguageModel::getName).sorted().collect(Collectors.toList());
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideLanguageName = null;
                if (aliases.size() > 1) {
                    overrideLanguageName = model.getArtifactId().replace("camel-", "");
                }
                this.createLanguageConfigurationSource(pkg, model, overrideLanguageName);
                this.createLanguageAutoConfigurationSource(pkg, model, aliases, overrideLanguageName);
                this.createLanguageSpringFactorySource(pkg, model);
            }
        }
    }

    private void createComponentConfigurationSource(String packageName, ComponentModel model, String overrideComponentName) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Component", "ComponentConfiguration");
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.extendSuperType("ComponentConfigurationPropertiesCommon");
        javaClass.addImport("org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon");
        Property bogus = javaClass.addProperty("java.lang.Boolean", "enabled");
        String scheme = overrideComponentName != null ? overrideComponentName : model.getScheme();
        bogus.getField().getJavaDoc().setText("Whether to enable auto configuration of the " + scheme + " component. This is enabled by default.");
        bogus.removeAccessor();
        bogus.removeMutator();
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setText(doc);
        String prefix = "camel.component." + (overrideComponentName != null ? overrideComponentName : model.getScheme());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class.getName()).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        LinkedHashSet<JavaClass> nestedTypes = new LinkedHashSet<JavaClass>();
        for (ComponentOptionModel option : model.getComponentOptions()) {
            boolean complex;
            boolean isNestedProperty;
            if (SpringBootAutoConfigurationMojo.skipComponentOption(model, option)) continue;
            String type = option.getJavaType();
            JavaClass javaClassSource = this.readJavaType(type = this.getSimpleJavaType(type));
            boolean bl = isNestedProperty = this.isNestedProperty(nestedTypes, javaClassSource) || "org.apache.camel.converter.jaxp.XmlConverter".equals(type);
            if (isNestedProperty) {
                type = packageName + "." + name + "$" + option.getShortJavaType() + INNER_TYPE_SUFFIX;
            }
            boolean bl2 = complex = this.isComplexType(option) && !isNestedProperty && Strings.isBlank((String)option.getEnums());
            if (complex) {
                type = "java.lang.String";
            }
            if (type.equals(packageName + "." + name + "$" + option.getShortJavaType() + INNER_TYPE_SUFFIX)) {
                Class clazz = this.generateDummyClass(type);
            }
            Property prop = javaClass.addProperty(type, option.getName());
            if ("true".equals(option.getDeprecated())) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isBlank((String)option.getDescription())) {
                String desc = option.getDescription();
                if (complex) {
                    if (!desc.endsWith(".")) {
                        desc = desc + ".";
                    }
                    desc = desc + " The option is a " + option.getJavaType() + " type.";
                }
                prop.getField().getJavaDoc().setFullText(desc);
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(option.getJavaType())) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        this.createComponentConfigurationSourceInnerClass(javaClass, nestedTypes, model);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private void createComponentConfigurationSourceInnerClass(JavaClass javaClass, Set<JavaClass> nestedTypes, ComponentModel model) throws MojoFailureException {
        for (JavaClass nestedType : nestedTypes) {
            JavaClass innerClass = javaClass.addNestedType().setPublic().setStatic(true).setName(nestedType.getName() + INNER_TYPE_SUFFIX);
            innerClass.addField().setPublic().setStatic(true).setFinal(true).setType(Class.class).setName("CAMEL_NESTED_CLASS").setLiteralInitializer(nestedType.getCanonicalName() + ".class");
            for (Property sourceProp : this.getProperties(nestedType)) {
                boolean anEnum;
                Class<?> optionClass;
                GenericType propType = sourceProp.getType();
                boolean ignore = sourceProp.hasAnnotation(XmlTransient.class);
                if (ignore || propType.getRawClass().getName().equals("org.apache.camel.CamelContext")) continue;
                String wt = PRIMITIVEMAP.get(propType.toString());
                GenericType ptype = wt != null ? this.loadType(wt) : propType;
                Property prop = innerClass.addProperty(ptype, sourceProp.getName());
                if (sourceProp.getField() != null) {
                    prop.getField().getJavaDoc().setText(sourceProp.getField().getJavaDoc().getText());
                    prop.getField().setLiteralInitializer(sourceProp.getField().getLiteralInitializer());
                }
                ComponentOptionModel com = model.getComponentOptions().stream().filter(o -> o.getName().equals(sourceProp.getName())).findFirst().orElse(null);
                EndpointOptionModel eom = Stream.concat(model.getEndpointOptions().stream(), model.getEndpointPathOptions().stream()).filter(o -> o.getName().equals(sourceProp.getName())).findFirst().orElse(null);
                String deprecationNote = null;
                if (eom != null) {
                    prop.getField().getJavaDoc().setText(eom.getDescription());
                    prop.getField().setLiteralInitializer(this.asLiteralDefault(sourceProp.getType(), eom.getDefaultValue()));
                    deprecationNote = eom.getDeprecationNote();
                } else if (com != null) {
                    prop.getField().getJavaDoc().setText(com.getDescription());
                    prop.getField().setLiteralInitializer(this.asLiteralDefault(sourceProp.getType(), com.getDefaultValue()));
                    deprecationNote = com.getDeprecationNote();
                }
                if (!propType.getRawClass().isArray()) {
                    optionClass = propType.getRawClass();
                    anEnum = optionClass.isEnum();
                } else {
                    optionClass = null;
                    anEnum = false;
                }
                if (sourceProp.hasAnnotation(Deprecated.class)) {
                    if (deprecationNote != null && !deprecationNote.isEmpty()) {
                        String jd = prop.getField().getJavaDoc().getText();
                        jd = jd != null ? jd + "\n\n" : "";
                        jd = "@deprecated " + deprecationNote;
                        prop.getField().getJavaDoc().setText(jd);
                    }
                    prop.getField().addAnnotation(Deprecated.class);
                    prop.getAccessor().addAnnotation(Deprecated.class);
                    prop.getMutator().addAnnotation(Deprecated.class);
                    prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
                }
                String description = null;
                Method mutator = sourceProp.getMutator();
                if (mutator.hasJavaDoc()) {
                    description = mutator.getJavaDoc().getFullText();
                } else if (sourceProp.hasField()) {
                    description = sourceProp.getField().getJavaDoc().getFullText();
                }
                if (Strings.isBlank((String)description) && sourceProp.hasAnnotation(UriPath.class)) {
                    description = sourceProp.getAnnotation(UriPath.class).getStringValue("description");
                }
                if (Strings.isBlank((String)description) && sourceProp.hasAnnotation(UriParam.class)) {
                    description = sourceProp.getAnnotation(UriParam.class).getStringValue("description");
                }
                if (Strings.isBlank((String)description) && sourceProp.hasAnnotation(Metadata.class)) {
                    description = sourceProp.getAnnotation(Metadata.class).getStringValue("description");
                }
                if (!Strings.isBlank((String)description)) {
                    prop.getField().getJavaDoc().setFullText(description);
                }
                if (!sourceProp.hasAnnotation(UriParam.class) && !sourceProp.hasAnnotation(UriPath.class)) continue;
                String defaultValue = null;
                String javaType = null;
                String type = null;
                String fileName = model.getJavaType();
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                File jsonFile = new File(this.classesDir, (fileName = fileName.replace('.', '/')) + "/" + model.getScheme() + ".json");
                if (jsonFile.isFile() && jsonFile.exists()) {
                    try {
                        String json = FileUtils.readFileToString((File)jsonFile);
                        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
                        String optionName = sourceProp.hasAnnotation(UriParam.class) ? sourceProp.getAnnotation(UriParam.class).getStringValue("name") : sourceProp.getAnnotation(UriPath.class).getStringValue("name");
                        if (optionName == null) {
                            String string = optionName = sourceProp.hasField() ? sourceProp.getField().getName() : null;
                        }
                        if (optionName != null) {
                            javaType = JSonSchemaHelper.getPropertyJavaType(rows, optionName);
                            type = JSonSchemaHelper.getPropertyType(rows, optionName);
                            defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, optionName);
                            description = JSonSchemaHelper.getPropertyDescriptionValue(rows, optionName);
                            if (description != null) {
                                prop.getField().getJavaDoc().setFullText(description);
                            }
                        }
                    }
                    catch (IOException json) {
                        // empty catch block
                    }
                }
                if (Strings.isBlank(defaultValue)) continue;
                String wrapperType = this.getSimpleJavaType(javaType);
                if (wrapperType.startsWith("java.lang.")) {
                    wrapperType = wrapperType.substring(10);
                    prop.setType(this.loadType(wrapperType));
                }
                if ("long".equals(javaType) || "java.lang.Long".equals(javaType)) {
                    String value = defaultValue + "L";
                    prop.getField().setLiteralInitializer(value);
                    continue;
                }
                if ("integer".equals(type) || "boolean".equals(type)) {
                    prop.getField().setLiteralInitializer(defaultValue);
                    continue;
                }
                if ("string".equals(type)) {
                    prop.getField().setStringInitializer(defaultValue);
                    continue;
                }
                if (!anEnum) continue;
                String enumShortName = optionClass.getSimpleName();
                prop.getField().setLiteralInitializer(enumShortName + "." + defaultValue);
                javaClass.addImport(model.getJavaType());
            }
        }
    }

    private boolean isComplexType(ComponentOptionModel option) {
        return "object".equals(option.getType());
    }

    private boolean isComplexType(DataFormatOptionModel option) {
        return "object".equals(option.getType());
    }

    private boolean isComplexType(LanguageOptionModel option) {
        return "object".equals(option.getType());
    }

    private List<Property> getProperties(JavaClass nestedType) {
        ArrayList<Property> properties = new ArrayList<Property>();
        HashSet<String> names = new HashSet<String>();
        do {
            for (Property propertySource : nestedType.getProperties()) {
                if (!propertySource.isMutable() || names.contains(propertySource.getName())) continue;
                properties.add(propertySource);
                names.add(propertySource.getName());
            }
        } while ((nestedType = this.readJavaType(nestedType.getSuperType())) != null);
        return properties;
    }

    private String asLiteralDefault(GenericType type, String defaultValue) {
        if (defaultValue != null && !defaultValue.isEmpty()) {
            if (type.getRawClass() == String.class) {
                return Annotation.quote(defaultValue);
            }
            if (type.getRawClass().isEnum()) {
                return type.getRawClass().getSimpleName() + "." + defaultValue;
            }
            if (type.getRawClass() == Boolean.TYPE || type.getRawClass() == Boolean.class) {
                return defaultValue;
            }
            if (type.getRawClass() == Integer.TYPE || type.getRawClass() == Integer.class) {
                return defaultValue;
            }
            if (type.getRawClass() == Long.TYPE || type.getRawClass() == Long.class) {
                return defaultValue + "L";
            }
            if (type.getRawClass() == Float.TYPE || type.getRawClass() == Float.class) {
                return defaultValue + "f";
            }
            if (type.getRawClass() == Double.TYPE || type.getRawClass() == Double.class) {
                return defaultValue;
            }
            if (type.getRawClass() == Class.class) {
                return defaultValue + ".class";
            }
            return null;
        }
        return null;
    }

    private GenericType loadType(String type) throws MojoFailureException {
        try {
            return GenericType.parse(type, this.getProjectClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Unable to load type", (Throwable)e);
        }
    }

    private Class<?> loadClass(String loadClassName) throws MojoFailureException {
        Class<?> optionClass;
        while (true) {
            try {
                optionClass = this.getProjectClassLoader().loadClass(loadClassName);
            }
            catch (ClassNotFoundException e) {
                int dotIndex = loadClassName.lastIndexOf(46);
                if (dotIndex == -1) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
                loadClassName = loadClassName.substring(0, dotIndex) + "$" + loadClassName.substring(dotIndex + 1);
                continue;
            }
            break;
        }
        return optionClass;
    }

    protected DynamicClassLoader getProjectClassLoader() {
        if (this.projectClassLoader == null) {
            List classpathElements;
            try {
                classpathElements = this.project.getTestClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            URL[] urls = new URL[classpathElements.size()];
            int i = 0;
            Iterator it = classpathElements.iterator();
            while (it.hasNext()) {
                try {
                    urls[i] = new File((String)it.next()).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                ++i;
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            this.projectClassLoader = new DynamicClassLoader(urls, tccl != null ? tccl : ((Object)((Object)this)).getClass().getClassLoader());
        }
        return this.projectClassLoader;
    }

    private String getSimpleJavaType(String type) {
        String wrapper = PRIMITIVEMAP.get(type);
        if (wrapper != null) {
            type = wrapper;
        }
        return type;
    }

    private boolean isNestedProperty(Set<JavaClass> nestedTypes, JavaClass type) {
        if (type != null) {
            if (type.isClass() && !type.isEnum() && !type.isAbstract() && !type.getProperties().isEmpty()) {
                nestedTypes.add(type);
            } else {
                type = null;
            }
        }
        return type != null;
    }

    private JavaClass readJavaType(String type) {
        if (!type.startsWith("java.lang.")) {
            String sourceCode;
            String fileName = type.replaceAll("[\\[\\]]", "").replaceAll("\\.", "\\/") + ".java";
            Path sourcePath = this.project.getCompileSourceRoots().stream().map(x$0 -> Paths.get(x$0, new String[0])).map(p -> p.resolve(fileName)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElse(null);
            if (sourcePath == null) {
                return null;
            }
            try (InputStream is = Files.newInputStream(sourcePath, new OpenOption[0]);){
                sourceCode = PackageHelper.loadText(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load source code", e);
            }
            try {
                Class<?> clazz = this.getProjectClassLoader().loadClass(type);
                JavaClass nestedType = new JavaClass(this.getProjectClassLoader()).setPackage(clazz.getPackage().getName()).setName(clazz.getSimpleName()).setEnum(clazz.isEnum()).setClass(!clazz.isInterface()).setAbstract((clazz.getModifiers() & 0x400) != 0).setStatic((clazz.getModifiers() & 8) != 0).extendSuperType(clazz.getGenericSuperclass() != null ? new GenericType(clazz.getGenericSuperclass()).toString() : null);
                List publicMethods = Stream.of(clazz.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).collect(Collectors.toList());
                List allSetters = publicMethods.stream().filter(m -> m.getReturnType() == Void.TYPE || m.getReturnType() == clazz).filter(m -> m.getParameterCount() == 1).filter(m -> m.getName().matches("set[A-Z][a-zA-Z0-9]*")).collect(Collectors.toList());
                List allGetters = publicMethods.stream().filter(m -> m.getReturnType() != Void.TYPE).filter(m -> m.getParameterCount() == 0).filter(m -> m.getName().matches("(get|is)[A-Z][a-zA-Z0-9]*")).collect(Collectors.toList());
                allSetters.stream().sorted(Comparator.comparing(m -> this.getSetterPosition(sourceCode, (java.lang.reflect.Method)m))).map(m -> Strings.uncapitalize((String)m.getName().substring(3))).forEach(fn -> {
                    java.lang.reflect.Method accessor;
                    boolean isBoolean;
                    Type wft;
                    Class<?> ft;
                    java.lang.reflect.Method mutator;
                    Field field = Stream.of(clazz.getDeclaredFields()).filter(f -> f.getName().equals(fn)).findAny().orElse(null);
                    List setters = allSetters.stream().filter(m -> m.getName().equals("set" + Strings.capitalize((String)fn))).collect(Collectors.toList());
                    List getters = allGetters.stream().filter(m -> m.getName().equals("get" + Strings.capitalize((String)fn)) || m.getName().equals("is" + Strings.capitalize((String)fn))).collect(Collectors.toList());
                    if (setters.size() == 1) {
                        mutator = (java.lang.reflect.Method)setters.get(0);
                        ft = mutator.getParameterTypes()[0];
                        wft = PRIMITIVE_CLASSES.getOrDefault(ft, ft);
                        isBoolean = ft == Boolean.TYPE || ft == Boolean.class;
                        accessor = allGetters.stream().filter(m -> m.getName().equals("get" + Strings.capitalize((String)fn)) || isBoolean && m.getName().equals("is" + Strings.capitalize((String)fn))).filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getReturnType(), m.getReturnType()) == wft).findAny().orElse(null);
                    } else if (field != null) {
                        ft = field.getType();
                        wft = PRIMITIVE_CLASSES.getOrDefault(ft, ft);
                        isBoolean = ft == Boolean.TYPE || ft == Boolean.class;
                        mutator = allSetters.stream().filter(m -> m.getName().equals("set" + Strings.capitalize((String)fn))).filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getParameterTypes()[0], m.getParameterTypes()[0]) == wft).findAny().orElse(null);
                        accessor = allGetters.stream().filter(m -> m.getName().equals("get" + Strings.capitalize((String)fn)) || isBoolean && m.getName().equals("is" + Strings.capitalize((String)fn))).filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getReturnType(), m.getReturnType()) == wft).findAny().orElse(null);
                    } else {
                        if (getters.size() != 1) {
                            throw new IllegalStateException("Unable to determine type for property " + fn);
                        }
                        ft = ((java.lang.reflect.Method)getters.get(0)).getReturnType();
                        wft = PRIMITIVE_CLASSES.getOrDefault(ft, ft);
                        mutator = setters.stream().filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getParameterTypes()[0], m.getParameterTypes()[0]) == wft).findAny().orElse(null);
                        accessor = getters.stream().filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getReturnType(), m.getReturnType()) == wft).findAny().orElse(null);
                    }
                    if (mutator == null) {
                        throw new IllegalStateException("Could not find mutator for property " + fn);
                    }
                    Property property = nestedType.addProperty(new GenericType(wft), (String)fn);
                    property.getMutator().getJavaDoc().setText(this.getSetterJavaDoc(sourceCode, (String)fn));
                    for (java.lang.annotation.Annotation ann : mutator.getAnnotations()) {
                        this.addAnnotation(ac -> property.getMutator().addAnnotation((Class<? extends java.lang.annotation.Annotation>)ac), ann);
                    }
                    if (accessor != null) {
                        for (java.lang.annotation.Annotation ann : accessor.getAnnotations()) {
                            this.addAnnotation(ac -> property.getAccessor().addAnnotation((Class<? extends java.lang.annotation.Annotation>)ac), ann);
                        }
                    } else {
                        property.removeAccessor();
                    }
                    if (field != null) {
                        for (java.lang.annotation.Annotation ann : field.getAnnotations()) {
                            this.addAnnotation(ac -> property.getField().addAnnotation((Class<? extends java.lang.annotation.Annotation>)ac), ann);
                        }
                    } else {
                        property.removeField();
                    }
                });
                return nestedType;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    private int getSetterPosition(String sourceCode, java.lang.reflect.Method m) {
        int i0 = sourceCode.indexOf("void " + m.getName() + "(");
        int i1 = sourceCode.indexOf(m.getDeclaringClass().getSimpleName() + " " + m.getName() + "(");
        int l = sourceCode.length();
        return Math.min(i0 > 0 ? i0 : l, i1 > 0 ? i1 : l);
    }

    private String getSetterJavaDoc(String sourceCode, String name) {
        int idx = sourceCode.indexOf("public void set" + Strings.capitalize((String)name) + "(");
        if (idx > 0 && (idx = (sourceCode = sourceCode.substring(0, idx)).lastIndexOf("/**")) > 0 && (idx = (sourceCode = sourceCode.substring(idx + 3)).indexOf("*/")) > 0) {
            int lastLine;
            sourceCode = sourceCode.substring(0, idx);
            List lines = Stream.of(sourceCode.split("\n")).map(String::trim).map(s -> s.startsWith("*") ? s.substring(1) : s).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            for (lastLine = 0; lastLine < lines.size() && !((String)lines.get(lastLine)).startsWith("@"); ++lastLine) {
            }
            sourceCode = lines.subList(0, lastLine).stream().map(s -> s.replaceAll("  ", " ")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
            return sourceCode;
        }
        return null;
    }

    private void addAnnotation(Function<Class<? extends java.lang.annotation.Annotation>, Annotation> creator, java.lang.annotation.Annotation ann) {
        Class<? extends java.lang.annotation.Annotation> ac = ann.annotationType();
        Annotation a = creator.apply(ac);
        for (java.lang.reflect.Method m : ac.getMethods()) {
            if ("equals".equals(m.getName()) || "toString".equals(m.getName()) || "hashCode".equals(m.getName())) continue;
            String n = m.getName();
            try {
                Object v = m.invoke((Object)ann, new Object[0]);
                if (v == null) continue;
                a.setLiteralValue(n, v.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to retrieve annotation value " + n + " on " + ac.getName());
            }
        }
    }

    private static boolean skipComponentOption(ComponentModel model, ComponentOptionModel option) {
        String name;
        return !(!"netty4-http".equals(model.getScheme()) && !"netty-http".equals(model.getScheme()) || !(name = option.getName()).equals("textline") && !name.equals("delimiter") && !name.equals("autoAppendDelimiter") && !name.equals("decoderMaxLineLength") && !name.equals("encoding") && !name.equals("allowDefaultCodec") && !name.equals("udpConnectionlessSending") && !name.equals("networkInterface") && !name.equals("clientMode") && !name.equals("reconnect") && !name.equals("reconnectInterval") && !name.equals("useByteBuf") && !name.equals("udpByteArrayCodec") && !name.equals("broadcast"));
    }

    private void createDataFormatConfigurationSource(String packageName, DataFormatModel model, String overrideDataFormatName) throws MojoFailureException {
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("DataFormat", "DataFormatConfiguration");
        javaClass.setPackage(packageName).setName(name);
        javaClass.extendSuperType("DataFormatConfigurationPropertiesCommon");
        javaClass.addImport("org.apache.camel.spring.boot.DataFormatConfigurationPropertiesCommon");
        Property bogus = javaClass.addProperty("java.lang.Boolean", "enabled");
        bogus.getField().getJavaDoc().setText("Whether to enable auto configuration of the " + model.getName() + " data format. This is enabled by default.");
        bogus.removeAccessor();
        bogus.removeMutator();
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        String prefix = "camel.dataformat." + (overrideDataFormatName != null ? overrideDataFormatName : model.getName());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        for (DataFormatOptionModel option : model.getDataFormatOptions()) {
            boolean complex;
            if ("id".equals(option.getName())) continue;
            String type = option.getJavaType();
            type = this.getSimpleJavaType(type);
            boolean bl = complex = this.isComplexType(option) && Strings.isBlank((String)option.getEnumValues());
            if (complex) {
                type = "java.lang.String";
            }
            Property prop = javaClass.addProperty(type, option.getName());
            if ("true".equals(option.getDeprecated())) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isBlank((String)option.getDescription())) {
                String desc = option.getDescription();
                if (complex) {
                    if (!desc.endsWith(".")) {
                        desc = desc + ".";
                    }
                    desc = desc + " The option is a " + option.getJavaType() + " type.";
                }
                prop.getField().getJavaDoc().setFullText(desc);
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(option.getJavaType())) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnumValues())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private void createLanguageConfigurationSource(String packageName, LanguageModel model, String overrideLanguageName) throws MojoFailureException {
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Language", "LanguageConfiguration");
        javaClass.setPackage(packageName).setName(name);
        javaClass.extendSuperType("LanguageConfigurationPropertiesCommon");
        javaClass.addImport("org.apache.camel.spring.boot.LanguageConfigurationPropertiesCommon");
        Property bogus = javaClass.addProperty("java.lang.Boolean", "enabled");
        bogus.getField().getJavaDoc().setText("Whether to enable auto configuration of the " + model.getName() + " language. This is enabled by default.");
        bogus.removeAccessor();
        bogus.removeMutator();
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isBlank((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        String prefix = "camel.language." + (overrideLanguageName != null ? overrideLanguageName : model.getName());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        for (LanguageOptionModel option : model.getLanguageOptions()) {
            boolean complex;
            if ("id".equals(option.getName()) || "expression".equals(option.getName()) || "resultType".equals(option.getName()) || ("bean".equals(model.getName()) ? "bean".equals(option.getName()) || "ref".equals(option.getName()) || "method".equals(option.getName()) || "beanType".equals(option.getName()) : ("tokenize".equals(model.getName()) ? "token".equals(option.getName()) || "endToken".equals(option.getName()) || "inheritNamespaceTagName".equals(option.getName()) || "headerName".equals(option.getName()) || "regex".equals(option.getName()) || "xml".equals(option.getName()) || "includeTokens".equals(option.getName()) || "group".equals(option.getName()) || "skipFirst".equals(option.getName()) : ("xtokenize".equals(model.getName()) ? "headerName".equals(option.getName()) || "group".equals(option.getName()) : ("xpath".equals(model.getName()) ? "headerName".equals(option.getName()) : "xquery".equals(model.getName()) && "headerName".equals(option.getName())))))) continue;
            String type = option.getJavaType();
            type = this.getSimpleJavaType(type);
            boolean bl = complex = this.isComplexType(option) && Strings.isBlank((String)option.getEnumValues());
            if (complex) {
                type = "java.lang.String";
            }
            Property prop = javaClass.addProperty(type, option.getName());
            if ("true".equals(option.getDeprecated())) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isBlank((String)option.getDescription())) {
                String desc = option.getDescription();
                if (complex) {
                    if (!desc.endsWith(".")) {
                        desc = desc + ".";
                    }
                    desc = desc + " The option is a " + option.getJavaType() + " type.";
                }
                prop.getField().getJavaDoc().setFullText(desc);
            }
            if (Strings.isBlank((String)option.getDefaultValue())) continue;
            if ("java.lang.String".equals(option.getJavaType())) {
                prop.getField().setStringInitializer(option.getDefaultValue());
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "boolean".equals(option.getType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue());
                continue;
            }
            if (Strings.isBlank((String)option.getEnumValues())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private void createComponentAutoConfigurationSource(String packageName, ComponentModel model, List<String> componentAliases, String overrideComponentName) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("Component", "ComponentAutoConfiguration");
        String configurationName = name.replace("ComponentAutoConfiguration", "ComponentConfiguration");
        String componentName = (overrideComponentName != null ? overrideComponentName : model.getScheme()).toLowerCase(Locale.US);
        Class configClass = this.generateDummyClass(packageName + "." + configurationName);
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(Conditional.class).setLiteralValue("{ConditionalOnCamelContextAndAutoConfigurationBeans.class,\n        " + name + ".GroupConditions.class}");
        javaClass.addAnnotation(AutoConfigureAfter.class).setLiteralValue("CamelAutoConfiguration.class");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("{ComponentConfigurationProperties.class,\n        " + configurationName + ".class}");
        javaClass.addImport(HashMap.class);
        javaClass.addImport(List.class);
        javaClass.addImport(Map.class);
        javaClass.addImport(ApplicationContext.class);
        javaClass.addImport(ConditionalOnBean.class);
        javaClass.addImport("org.slf4j.Logger");
        javaClass.addImport("org.slf4j.LoggerFactory");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.spi.ComponentCustomizer");
        javaClass.addImport("org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addImport("org.apache.camel.spring.boot.ComponentConfigurationProperties");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans");
        javaClass.addImport("org.apache.camel.spring.boot.util.GroupCondition");
        javaClass.addImport("org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator");
        javaClass.addImport("org.apache.camel.support.IntrospectionSupport");
        javaClass.addImport("org.apache.camel.util.ObjectHelper");
        javaClass.addImport("org.apache.camel.spi.HasId");
        javaClass.addImport(model.getJavaType());
        javaClass.addField().setPrivate().setStatic(true).setFinal(true).setName("LOGGER").setType(this.loadClass("org.slf4j.Logger")).setLiteralInitializer("LoggerFactory\n            .getLogger(" + name + ".class)");
        javaClass.addField().setPrivate().setName("applicationContext").setType(ApplicationContext.class).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext")).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("configuration").setType(configClass).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("customizers").setType(this.loadType("java.util.List<org.apache.camel.spi.ComponentCustomizer<" + model.getJavaType() + ">>")).addAnnotation(Autowired.class).setLiteralValue("required", "false");
        javaClass.addNestedType().setName("GroupConditions").setStatic(true).setPackagePrivate().extendSuperType("GroupCondition").addMethod().setName("GroupConditions").setConstructor(true).setPublic().setBody("super(\"camel.component\", \"camel.component." + componentName + "\");");
        String body = SpringBootAutoConfigurationMojo.createComponentBody(model.getShortJavaType(), componentName);
        String methodName = "configure" + model.getShortJavaType();
        Method method = javaClass.addMethod().setName(methodName).setPublic().setBody(body).setReturnType(this.loadType(model.getJavaType())).addThrows(Exception.class);
        String[] springBeanAliases = (String[])componentAliases.stream().map(alias -> alias + "-component").toArray(String[]::new);
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class).setStringArrayValue("name", springBeanAliases);
        method.addAnnotation(ConditionalOnMissingBean.class).setLiteralValue(model.getShortJavaType() + ".class");
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private Class generateDummyClass(String clazzName) {
        ClassWriter cw = new ClassWriter(2);
        cw.visit(52, 1, clazzName.replace('.', '/'), null, "java/lang/Object", null);
        cw.visitEnd();
        return this.getProjectClassLoader().defineClass(clazzName, cw.toByteArray());
    }

    private void createDataFormatAutoConfigurationSource(String packageName, DataFormatModel model, List<String> dataFormatAliases, String overrideDataFormatName) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("DataFormat", "DataFormatAutoConfiguration");
        String configurationName = name.replace("DataFormatAutoConfiguration", "DataFormatConfiguration");
        String dataformatName = (overrideDataFormatName != null ? overrideDataFormatName : model.getName()).toLowerCase(Locale.US);
        Class configClass = this.generateDummyClass(packageName + "." + configurationName);
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(Conditional.class).setLiteralValue("{ConditionalOnCamelContextAndAutoConfigurationBeans.class,\n        " + name + ".GroupConditions.class}");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("{DataFormatConfigurationProperties.class,\n        " + configurationName + ".class}");
        javaClass.addImport(HashMap.class);
        javaClass.addImport(List.class);
        javaClass.addImport(Map.class);
        javaClass.addImport(ApplicationContext.class);
        javaClass.addImport(ConditionalOnBean.class);
        javaClass.addImport("org.slf4j.Logger");
        javaClass.addImport("org.slf4j.LoggerFactory");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.CamelContextAware");
        javaClass.addImport("org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addImport("org.apache.camel.spring.boot.DataFormatConfigurationProperties");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans");
        javaClass.addImport("org.apache.camel.spring.boot.util.GroupCondition");
        javaClass.addImport("org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator");
        javaClass.addImport("org.apache.camel.support.IntrospectionSupport");
        javaClass.addImport("org.apache.camel.util.ObjectHelper");
        javaClass.addImport("org.apache.camel.RuntimeCamelException");
        javaClass.addImport("org.apache.camel.spi.DataFormat");
        javaClass.addImport("org.apache.camel.spi.DataFormatCustomizer");
        javaClass.addImport("org.apache.camel.spi.DataFormatFactory");
        javaClass.addImport("org.apache.camel.spi.HasId");
        javaClass.addImport(model.getJavaType());
        javaClass.addField().setPrivate().setStatic(true).setFinal(true).setName("LOGGER").setType(this.loadType("org.slf4j.Logger")).setLiteralInitializer("LoggerFactory\n            .getLogger(" + name + ".class)");
        javaClass.addField().setPrivate().setName("applicationContext").setType(ApplicationContext.class).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("camelContext").setType(this.loadType("org.apache.camel.CamelContext")).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("configuration").setType(configClass).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("customizers").setType(this.loadType("java.util.List<org.apache.camel.spi.DataFormatCustomizer<" + model.getJavaType() + ">>")).addAnnotation(Autowired.class).setLiteralValue("required", "false");
        JavaClass groupConditions = javaClass.addNestedType().setName("GroupConditions").setStatic(true).setPackagePrivate().extendSuperType("GroupCondition");
        groupConditions.addMethod().setName("GroupConditions").setConstructor(true).setPublic().setBody("super(\"camel.dataformat\", \"camel.dataformat." + dataformatName + "\");");
        String body = SpringBootAutoConfigurationMojo.createDataFormatBody(model.getShortJavaType(), dataformatName);
        String methodName = "configure" + model.getShortJavaType() + "Factory";
        Method method = javaClass.addMethod().setName(methodName).setPublic().setBody(body).setReturnType(this.loadType("org.apache.camel.spi.DataFormatFactory")).addThrows(Exception.class);
        String[] springBeanAliases = (String[])dataFormatAliases.stream().map(alias -> alias + "-dataformat-factory").toArray(String[]::new);
        method.addAnnotation(Bean.class).setStringArrayValue("name", springBeanAliases);
        method.addAnnotation(ConditionalOnMissingBean.class).setLiteralValue("value", model.getShortJavaType() + ".class");
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private void createLanguageAutoConfigurationSource(String packageName, LanguageModel model, List<String> languageAliases, String overrideLanguageName) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("Language", "LanguageAutoConfiguration");
        String configurationName = name.replace("LanguageAutoConfiguration", "LanguageConfiguration");
        String languageName = (overrideLanguageName != null ? overrideLanguageName : model.getName()).toLowerCase(Locale.US);
        Class configClass = this.generateDummyClass(packageName + "." + configurationName);
        JavaClass javaClass = new JavaClass(this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class);
        javaClass.addAnnotation(Conditional.class).setLiteralValue("{ConditionalOnCamelContextAndAutoConfigurationBeans.class,\n        " + name + ".GroupConditions.class}");
        javaClass.addAnnotation(AutoConfigureAfter.class).setLiteralValue("CamelAutoConfiguration.class");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("{LanguageConfigurationProperties.class,\n        " + configurationName + ".class}");
        javaClass.addImport(HashMap.class);
        javaClass.addImport(List.class);
        javaClass.addImport(Map.class);
        javaClass.addImport(ApplicationContext.class);
        javaClass.addImport(ConditionalOnBean.class);
        javaClass.addImport(ConfigurableBeanFactory.class);
        javaClass.addImport("org.slf4j.Logger");
        javaClass.addImport("org.slf4j.LoggerFactory");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.CamelContextAware");
        javaClass.addImport("org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addImport("org.apache.camel.spring.boot.LanguageConfigurationProperties");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans");
        javaClass.addImport("org.apache.camel.spring.boot.util.GroupCondition");
        javaClass.addImport("org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator");
        javaClass.addImport("org.apache.camel.support.IntrospectionSupport");
        javaClass.addImport("org.apache.camel.util.ObjectHelper");
        javaClass.addImport("org.apache.camel.spi.HasId");
        javaClass.addImport("org.apache.camel.spi.LanguageCustomizer");
        javaClass.addImport(model.getJavaType());
        javaClass.addField().setPrivate().setStatic(true).setFinal(true).setName("LOGGER").setType(this.loadType("org.slf4j.Logger")).setLiteralInitializer("LoggerFactory\n            .getLogger(" + name + ".class)");
        javaClass.addField().setPrivate().setName("applicationContext").setType(ApplicationContext.class).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("camelContext").setType(this.loadType("org.apache.camel.CamelContext")).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("configuration").setType(configClass).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setName("customizers").setType(this.loadType("java.util.List<org.apache.camel.spi.LanguageCustomizer<" + model.getJavaType() + ">>")).addAnnotation(Autowired.class).setLiteralValue("required", "false");
        javaClass.addNestedType().setName("GroupConditions").setStatic(true).setPackagePrivate().extendSuperType("GroupCondition").addMethod().setName("GroupConditions").setConstructor(true).setPublic().setBody("super(\"camel.component\", \"camel.component." + languageName + "\");");
        String body = SpringBootAutoConfigurationMojo.createLanguageBody(model.getShortJavaType(), languageName);
        String methodName = "configure" + model.getShortJavaType();
        Method method = javaClass.addMethod().setName(methodName).setPublic().setBody(body).setReturnType(this.loadType(model.getJavaType())).addThrows(Exception.class);
        String[] springBeanAliases = (String[])languageAliases.stream().map(alias -> alias + "-language").toArray(String[]::new);
        method.addAnnotation(Bean.class).setStringArrayValue("name", springBeanAliases);
        method.addAnnotation(Scope.class).setLiteralValue("ConfigurableBeanFactory.SCOPE_PROTOTYPE");
        method.addAnnotation(ConditionalOnMissingBean.class).setLiteralValue("value", model.getShortJavaType() + ".class");
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private void createComponentSpringFactorySource(String packageName, ComponentModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Component", "ComponentAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void createDataFormatSpringFactorySource(String packageName, DataFormatModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("DataFormat", "DataFormatAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void createLanguageSpringFactorySource(String packageName, LanguageModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Language", "LanguageAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private static String createComponentBody(String shortJavaType, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(shortJavaType).append(" component = new ").append(shortJavaType).append("();").append("\n");
        sb.append("component.setCamelContext(camelContext);\n");
        sb.append("Map<String, Object> parameters = new HashMap<>();\n");
        sb.append("IntrospectionSupport.getProperties(configuration, parameters, null,\n        false);\n");
        sb.append("for (Map.Entry<String, Object> entry : parameters.entrySet()) {\n");
        sb.append("    Object value = entry.getValue();\n");
        sb.append("    Class<?> paramClass = value.getClass();\n");
        sb.append("    if (paramClass.getName().endsWith(\"NestedConfiguration\")) {\n");
        sb.append("        Class nestedClass = null;\n");
        sb.append("        try {\n");
        sb.append("            nestedClass = (Class) paramClass.getDeclaredField(\n                    \"CAMEL_NESTED_CLASS\").get(null);\n");
        sb.append("            HashMap<String, Object> nestedParameters = new HashMap<>();\n");
        sb.append("            IntrospectionSupport.getProperties(value, nestedParameters,\n                    null, false);\n");
        sb.append("            Object nestedProperty = nestedClass.newInstance();\n");
        sb.append("            CamelPropertiesHelper.setCamelProperties(camelContext,\n                    nestedProperty, nestedParameters, false);\n");
        sb.append("            entry.setValue(nestedProperty);\n");
        sb.append("        } catch (NoSuchFieldException e) {\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("CamelPropertiesHelper.setCamelProperties(camelContext, component,\n");
        sb.append("        parameters, false);\n");
        sb.append("if (ObjectHelper.isNotEmpty(customizers)) {\n");
        sb.append("    for (ComponentCustomizer<").append(shortJavaType).append("> customizer : customizers) {\n");
        sb.append("        boolean useCustomizer = (customizer instanceof HasId)\n");
        sb.append("                ? HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                        applicationContext.getEnvironment(),\n");
        sb.append("                        \"camel.component.customizer\",\n");
        sb.append("                        \"camel.component.").append(name).append(".customizer\",\n");
        sb.append("                        ((HasId) customizer).getId())\n");
        sb.append("                : HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                        applicationContext.getEnvironment(),\n");
        sb.append("                        \"camel.component.customizer\",\n");
        sb.append("                        \"camel.component.").append(name).append(".customizer\");\n");
        sb.append("        if (useCustomizer) {\n");
        sb.append("            LOGGER.debug(\"Configure component {}, with customizer {}\",\n");
        sb.append("                    component, customizer);\n");
        sb.append("            customizer.customize(component);\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("return component;");
        return sb.toString();
    }

    private static String createDataFormatBody(String shortJavaType, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("return new DataFormatFactory() {\n");
        sb.append("    @Override\n");
        sb.append("    public DataFormat newInstance() {\n");
        sb.append("        ").append(shortJavaType).append(" dataformat = new ").append(shortJavaType).append("();").append("\n");
        sb.append("        if (CamelContextAware.class\n                .isAssignableFrom(").append(shortJavaType).append(".class)) {\n");
        sb.append("            CamelContextAware contextAware = CamelContextAware.class\n                    .cast(dataformat);\n");
        sb.append("            if (contextAware != null) {\n");
        sb.append("                contextAware.setCamelContext(camelContext);\n");
        sb.append("            }\n");
        sb.append("        }\n");
        sb.append("        try {\n");
        sb.append("            Map<String, Object> parameters = new HashMap<>();\n");
        sb.append("            IntrospectionSupport.getProperties(configuration,\n                    parameters, null, false);\n");
        sb.append("            CamelPropertiesHelper.setCamelProperties(camelContext,\n                    dataformat, parameters, false);\n");
        sb.append("        } catch (Exception e) {\n");
        sb.append("            throw new RuntimeCamelException(e);\n");
        sb.append("        }\n");
        sb.append("        if (ObjectHelper.isNotEmpty(customizers)) {\n");
        sb.append("            for (DataFormatCustomizer<").append(shortJavaType).append("> customizer : customizers) {\n");
        sb.append("                boolean useCustomizer = (customizer instanceof HasId)\n");
        sb.append("                        ? HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                                applicationContext.getEnvironment(),\n");
        sb.append("                                \"camel.dataformat.customizer\",\n");
        sb.append("                                \"camel.dataformat.").append(name).append(".customizer\",\n");
        sb.append("                                ((HasId) customizer).getId())\n");
        sb.append("                        : HierarchicalPropertiesEvaluator.evaluate(\n                                applicationContext.getEnvironment(),\n");
        sb.append("                                \"camel.dataformat.customizer\",\n");
        sb.append("                                \"camel.dataformat.").append(name).append(".customizer\");\n");
        sb.append("                if (useCustomizer) {\n");
        sb.append("                    LOGGER.debug(\n                            \"Configure dataformat {}, with customizer {}\",\n                            dataformat, customizer);\n");
        sb.append("                    customizer.customize(dataformat);\n");
        sb.append("                }\n");
        sb.append("            }\n");
        sb.append("        }\n");
        sb.append("        return dataformat;\n");
        sb.append("    }\n");
        sb.append("};\n");
        return sb.toString();
    }

    private static String createLanguageBody(String shortJavaType, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(shortJavaType).append(" language = new ").append(shortJavaType).append("();").append("\n");
        sb.append("if (CamelContextAware.class.isAssignableFrom(").append(shortJavaType).append(".class)) {\n");
        sb.append("    CamelContextAware contextAware = CamelContextAware.class\n            .cast(language);\n");
        sb.append("    if (contextAware != null) {\n");
        sb.append("        contextAware.setCamelContext(camelContext);\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("Map<String, Object> parameters = new HashMap<>();\n");
        sb.append("IntrospectionSupport.getProperties(configuration, parameters, null,\n        false);\n");
        sb.append("CamelPropertiesHelper.setCamelProperties(camelContext, language,\n        parameters, false);\n");
        sb.append("if (ObjectHelper.isNotEmpty(customizers)) {\n");
        sb.append("    for (LanguageCustomizer<").append(shortJavaType).append("> customizer : customizers) {\n");
        sb.append("        boolean useCustomizer = (customizer instanceof HasId)\n");
        sb.append("                ? HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                        applicationContext.getEnvironment(),\n");
        sb.append("                        \"camel.language.customizer\",\n");
        sb.append("                        \"camel.language.").append(name).append(".customizer\",\n");
        sb.append("                        ((HasId) customizer).getId())\n");
        sb.append("                : HierarchicalPropertiesEvaluator.evaluate(\n");
        sb.append("                        applicationContext.getEnvironment(),\n");
        sb.append("                        \"camel.language.customizer\",\n");
        sb.append("                        \"camel.language.").append(name).append(".customizer\");\n");
        sb.append("        if (useCustomizer) {\n");
        sb.append("            LOGGER.debug(\"Configure language {}, with customizer {}\",\n                    language, customizer);\n");
        sb.append("            customizer.customize(language);\n");
        sb.append("        }\n");
        sb.append("    }\n");
        sb.append("}\n");
        sb.append("return language;");
        return sb.toString();
    }

    private static void sortImports(JavaClass importer) {
    }

    private static String loadModelJson(Map<File, Supplier<String>> jsonFiles, String modelName) {
        return SpringBootAutoConfigurationMojo.loadJsonOfType(jsonFiles, modelName, "model");
    }

    private static String loadComponentJson(Map<File, Supplier<String>> jsonFiles, String componentName) {
        return SpringBootAutoConfigurationMojo.loadJsonOfType(jsonFiles, componentName, "component");
    }

    private static String loadDataFormatJson(Map<File, Supplier<String>> jsonFiles, String dataFormatName) {
        return SpringBootAutoConfigurationMojo.loadJsonOfType(jsonFiles, dataFormatName, "dataformat");
    }

    private static String loadLanguageJson(Map<File, Supplier<String>> jsonFiles, String languageName) {
        return SpringBootAutoConfigurationMojo.loadJsonOfType(jsonFiles, languageName, "language");
    }

    private static String loadJsonOfType(Map<File, Supplier<String>> jsonFiles, String modelName, String type) {
        for (Map.Entry<File, Supplier<String>> entry : jsonFiles.entrySet()) {
            String json;
            if (!entry.getKey().getName().equals(modelName + ".json") || !(json = entry.getValue().get()).contains("\"kind\": \"" + type + "\"")) continue;
            return json;
        }
        return null;
    }

    private static ComponentModel generateComponentModel(String componentName, String json) {
        Object option;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        ComponentModel component = new ComponentModel(true);
        component.setScheme(JSonSchemaHelper.getSafeValue("scheme", rows));
        component.setSyntax(JSonSchemaHelper.getSafeValue("syntax", rows));
        component.setAlternativeSyntax(JSonSchemaHelper.getSafeValue("alternativeSyntax", rows));
        component.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        component.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        component.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        component.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        component.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        component.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        component.setConsumerOnly(JSonSchemaHelper.getSafeValue("consumerOnly", rows));
        component.setProducerOnly(JSonSchemaHelper.getSafeValue("producerOnly", rows));
        component.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        component.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        component.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        component.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("componentProperties", json, true);
        for (Map<String, String> row : rows) {
            option = new ComponentOptionModel();
            ((ComponentOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((ComponentOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((ComponentOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((ComponentOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((ComponentOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((ComponentOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((ComponentOptionModel)option).setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            ((ComponentOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            ((ComponentOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((ComponentOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            component.addComponentOption((ComponentOptionModel)option);
        }
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            option = new EndpointOptionModel();
            ((EndpointOptionModel)option).setName(JSonSchemaHelper.getSafeValue("name", row));
            ((EndpointOptionModel)option).setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            ((EndpointOptionModel)option).setKind(JSonSchemaHelper.getSafeValue("kind", row));
            ((EndpointOptionModel)option).setGroup(JSonSchemaHelper.getSafeValue("group", row));
            ((EndpointOptionModel)option).setRequired(JSonSchemaHelper.getSafeValue("required", row));
            ((EndpointOptionModel)option).setType(JSonSchemaHelper.getSafeValue("type", row));
            ((EndpointOptionModel)option).setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            ((EndpointOptionModel)option).setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            ((EndpointOptionModel)option).setPrefix(JSonSchemaHelper.getSafeValue("prefix", row));
            ((EndpointOptionModel)option).setMultiValue(JSonSchemaHelper.getSafeValue("multiValue", row));
            ((EndpointOptionModel)option).setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            ((EndpointOptionModel)option).setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            ((EndpointOptionModel)option).setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            ((EndpointOptionModel)option).setDescription(JSonSchemaHelper.getSafeValue("description", row));
            ((EndpointOptionModel)option).setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            component.addEndpointOption((EndpointOptionModel)option);
        }
        return component;
    }

    private static DataFormatModel generateDataFormatModel(String dataFormatName, String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
        DataFormatModel dataFormat = new DataFormatModel();
        dataFormat.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        dataFormat.setName(JSonSchemaHelper.getSafeValue("name", rows));
        dataFormat.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        dataFormat.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        dataFormat.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        dataFormat.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        dataFormat.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        dataFormat.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        dataFormat.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        dataFormat.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        dataFormat.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        dataFormat.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            DataFormatOptionModel option = new DataFormatOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            dataFormat.addDataFormatOption(option);
        }
        return dataFormat;
    }

    private static LanguageModel generateLanguageModel(String languageName, String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
        LanguageModel language = new LanguageModel();
        language.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        language.setName(JSonSchemaHelper.getSafeValue("name", rows));
        language.setModelName(JSonSchemaHelper.getSafeValue("modelName", rows));
        language.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        language.setFirstVersion(JSonSchemaHelper.getSafeValue("firstVersion", rows));
        language.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        language.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        language.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        language.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        language.setGroupId(JSonSchemaHelper.getSafeValue("groupId", rows));
        language.setArtifactId(JSonSchemaHelper.getSafeValue("artifactId", rows));
        language.setVersion(JSonSchemaHelper.getSafeValue("version", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            LanguageOptionModel option = new LanguageOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setEnumValues(JSonSchemaHelper.getSafeValue("enum", row));
            language.addLanguageOption(option);
        }
        return language;
    }

    private OtherModel generateOtherModel(String json) {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
        OtherModel model = new OtherModel();
        model.setName(JSonSchemaHelper.getSafeValue("name", rows));
        model.setTitle(JSonSchemaHelper.getSafeValue("title", rows));
        model.setDescription(JSonSchemaHelper.getSafeValue("description", rows));
        model.setJavaType(JSonSchemaHelper.getSafeValue("javaType", rows));
        model.setLabel(JSonSchemaHelper.getSafeValue("label", rows));
        model.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", rows));
        model.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", rows));
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        for (Map<String, String> row : rows) {
            OtherOptionModel option = new OtherOptionModel();
            option.setName(JSonSchemaHelper.getSafeValue("name", row));
            option.setDisplayName(JSonSchemaHelper.getSafeValue("displayName", row));
            option.setKind(JSonSchemaHelper.getSafeValue("kind", row));
            option.setGroup(JSonSchemaHelper.getSafeValue("group", row));
            option.setRequired(JSonSchemaHelper.getSafeValue("required", row));
            option.setType(JSonSchemaHelper.getSafeValue("type", row));
            option.setJavaType(JSonSchemaHelper.getSafeValue("javaType", row));
            option.setEnums(JSonSchemaHelper.getSafeValue("enum", row));
            option.setDeprecated(JSonSchemaHelper.getSafeValue("deprecated", row));
            option.setDeprecationNote(JSonSchemaHelper.getSafeValue("deprecationNote", row));
            option.setDefaultValue(JSonSchemaHelper.getSafeValue("defaultValue", row));
            option.setDescription(JSonSchemaHelper.getSafeValue("description", row));
            option.setEnums(JSonSchemaHelper.getSafeValue("enums", row));
            model.addOptionModel(option);
        }
        return model;
    }

    private void findComponentNames(File dir, Set<String> componentNames) {
        File[] files;
        File f = new File(dir, "classes/META-INF/services/org/apache/camel/component");
        if (f.exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                componentNames.add(name);
            }
        }
    }

    private List<String> findDataFormatNames() {
        File[] files;
        ArrayList<String> dataFormatNames = new ArrayList<String>();
        File f = new File(this.project.getBasedir(), "target/classes");
        if ((f = new File(f, "META-INF/services/org/apache/camel/dataformat")).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                dataFormatNames.add(name);
            }
        }
        return dataFormatNames;
    }

    private List<String> findLanguageNames() {
        File[] files;
        ArrayList<String> languageNames = new ArrayList<String>();
        File f = new File(this.project.getBasedir(), "target/classes");
        if ((f = new File(f, "META-INF/services/org/apache/camel/language")).exists() && f.isDirectory() && (files = f.listFiles()) != null) {
            for (File file : files) {
                String name;
                if (file.isDirectory() || (name = file.getName()).charAt(0) == '.') continue;
                languageNames.add(name);
            }
        }
        return languageNames;
    }

    private void writeSourceIfChanged(JavaClass source, String fileName, boolean innerClassesLast) throws MojoFailureException {
        this.writeSourceIfChanged(source.printClass(innerClassesLast), fileName);
    }

    private void writeSourceIfChanged(String source, String fileName) throws MojoFailureException {
        File target = new File(SpringBootHelper.starterSrcDir(this.baseDir, this.project.getArtifactId()), fileName);
        this.deleteFileOnMainArtifact(target);
        try {
            String header;
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                header = PackageHelper.loadText(is);
            }
            String code = header + source;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            AbstractGeneratorMojo.updateResource(null, target.toPath(), code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    private void writeComponentSpringFactorySource(String packageName, String name) throws MojoFailureException {
        StringBuilder sb = new StringBuilder();
        sb.append("org.springframework.boot.autoconfigure.EnableAutoConfiguration=\\\n");
        String lineToAdd = packageName + "." + name + "\n";
        sb.append(lineToAdd);
        String fileName = "META-INF/spring.factories";
        File target = new File(SpringBootHelper.starterResourceDir(this.baseDir, this.project.getArtifactId()), fileName);
        this.deleteFileOnMainArtifact(target);
        if (target.exists()) {
            try {
                boolean found = false;
                List lines = FileUtils.readLines((File)target);
                for (String line : lines) {
                    if (!line.contains(name)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.getLog().debug((CharSequence)("No changes to existing file: " + target));
                }
                int lastLine = 0;
                for (int i = lines.size() - 1; i >= 0; --i) {
                    String line = (String)lines.get(i);
                    if (line.trim().isEmpty()) continue;
                    line = line + ",\\";
                    lines.set(i, line);
                    lastLine = i;
                    break;
                }
                lines.add(lastLine + 1, lineToAdd);
                StringBuilder code = new StringBuilder();
                for (String line : lines) {
                    code.append(line).append("\n");
                }
                FileUtils.write((File)target, (CharSequence)code.toString(), (boolean)false);
                this.getLog().info((CharSequence)("Updated existing file: " + target));
            }
            catch (Exception e) {
                throw new MojoFailureException("IOError with file " + target, (Throwable)e);
            }
        } else {
            try {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header.txt");
                String header = PackageHelper.loadText(is);
                String code = sb.toString();
                code = header + "\n" + code;
                this.getLog().debug((CharSequence)("Source code generated:\n" + code));
                FileUtils.write((File)target, (CharSequence)code);
                this.getLog().info((CharSequence)("Created file: " + target));
            }
            catch (Exception e) {
                throw new MojoFailureException("IOError with file " + target, (Throwable)e);
            }
        }
    }

    private void deleteFileOnMainArtifact(File starterFile) {
    }

    static {
        PRIMITIVE_CLASSES = new HashMap<Type, Type>();
        PRIMITIVE_CLASSES.put(Boolean.TYPE, (Type)((Object)Boolean.class));
        PRIMITIVE_CLASSES.put(Character.TYPE, (Type)((Object)Character.class));
        PRIMITIVE_CLASSES.put(Long.TYPE, (Type)((Object)Long.class));
        PRIMITIVE_CLASSES.put(Integer.TYPE, (Type)((Object)Integer.class));
        PRIMITIVE_CLASSES.put(Byte.TYPE, (Type)((Object)Byte.class));
        PRIMITIVE_CLASSES.put(Short.TYPE, (Type)((Object)Short.class));
        PRIMITIVE_CLASSES.put(Double.TYPE, (Type)((Object)Double.class));
        PRIMITIVE_CLASSES.put(Float.TYPE, (Type)((Object)Float.class));
        PRIMITIVEMAP = new HashMap<String, String>();
        PRIMITIVEMAP.put("boolean", "java.lang.Boolean");
        PRIMITIVEMAP.put("char", "java.lang.Character");
        PRIMITIVEMAP.put("long", "java.lang.Long");
        PRIMITIVEMAP.put("int", "java.lang.Integer");
        PRIMITIVEMAP.put("integer", "java.lang.Integer");
        PRIMITIVEMAP.put("byte", "java.lang.Byte");
        PRIMITIVEMAP.put("short", "java.lang.Short");
        PRIMITIVEMAP.put("double", "java.lang.Double");
        PRIMITIVEMAP.put("float", "java.lang.Float");
        JAVA_LANG_TYPES = Arrays.asList("Boolean", "Byte", "Character", "Class", "Double", "Float", "Integer", "Long", "Object", "Short", "String");
        IGNORE_MODULES = new String[]{"camel-grape"};
    }

    static class DynamicClassLoader
    extends URLClassLoader {
        public DynamicClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public Class defineClass(String name, byte[] data) {
            return super.defineClass(name, data, 0, data.length);
        }
    }
}

