/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl.component;

import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.commons.lang3.StringUtils;

public final class ComponentDslInnerBuilderGenerator {
    private static final String BUILDER_SUFFIX = "Builder";
    private final JavaClass javaClass;
    private final ComponentModel componentModel;

    private ComponentDslInnerBuilderGenerator(JavaClass javaClass, ComponentModel componentModel) {
        this.javaClass = javaClass;
        this.componentModel = componentModel;
        this.generateJavaClass();
    }

    public static ComponentDslInnerBuilderGenerator generateClass(JavaClass javaClass, ComponentModel componentModel) {
        return new ComponentDslInnerBuilderGenerator(javaClass, componentModel);
    }

    public static String getExpectedGeneratedInterfaceName(ComponentModel componentModel) {
        return DslHelper.generateComponentBuilderClassName(componentModel, BUILDER_SUFFIX);
    }

    public String getGeneratedInterfaceName() {
        return ComponentDslInnerBuilderGenerator.getExpectedGeneratedInterfaceName(this.componentModel);
    }

    private void generateJavaClass() {
        this.setJavaDoc();
        this.setClassNameAndType();
        this.setFluentMethodsFromComponentOptions();
    }

    private void setJavaDoc() {
        this.javaClass.getJavaDoc().setText("Builder for the " + this.componentModel.getTitle() + " component.");
    }

    private void setClassNameAndType() {
        this.javaClass.setName(this.getGeneratedInterfaceName()).setPackagePrivate().setClass(false).extendSuperType(String.format("ComponentBuilder<%s>", this.componentModel.getShortJavaType()));
    }

    private void setFluentMethodsFromComponentOptions() {
        this.componentModel.getComponentOptions().forEach(componentOptionModel -> {
            Method method = this.javaClass.addMethod();
            method.setDefault().setReturnType(this.getGeneratedInterfaceName()).setName(StringUtils.uncapitalize((String)componentOptionModel.getName())).addParameter(componentOptionModel.getJavaType(), componentOptionModel.getName()).setBody(new String[]{String.format("doSetProperty(\"%s\", %s);", componentOptionModel.getName(), componentOptionModel.getName()), "return this;"});
            if (componentOptionModel.isDeprecated()) {
                method.addAnnotation(Deprecated.class);
            }
            method.getJavaDoc().setFullText(this.generateOptionDescription((ComponentModel.ComponentOptionModel)componentOptionModel));
        });
    }

    private String generateOptionDescription(ComponentModel.ComponentOptionModel componentOptionModel) {
        String desc = componentOptionModel.getDescription();
        if (!desc.endsWith(".")) {
            desc = desc + ".";
        }
        desc = desc + "\n";
        desc = desc + "\nThe option is a: <code>" + componentOptionModel.getJavaType() + "</code> type.";
        desc = desc + "\n";
        if ("parameter".equals(componentOptionModel.getKind()) && componentOptionModel.isRequired()) {
            desc = desc + "\nRequired: true";
        }
        if (componentOptionModel.getDefaultValue() != null) {
            desc = desc + "\nDefault: " + componentOptionModel.getDefaultValue();
        }
        desc = desc + "\nGroup: " + componentOptionModel.getGroup();
        return desc;
    }
}

