/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging.dsl.component;

import java.util.Objects;
import javax.annotation.Generated;
import org.apache.camel.maven.packaging.ComponentDslMojo;
import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.maven.packaging.dsl.component.ComponentDslInnerBuilderGenerator;
import org.apache.camel.maven.packaging.dsl.component.ComponentDslInnerImplBuilderGenerator;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;

public final class ComponentDslBuilderFactoryGenerator {
    private static final String BUILDER_FACTORY_SUFFIX = "BuilderFactory";
    private final ComponentModel componentModel;
    private final String packageName;
    private JavaClass javaClass;
    private ComponentDslInnerBuilderGenerator componentDslInnerBuilderGenerator;
    private ComponentDslInnerImplBuilderGenerator componentDslInnerImplBuilderGenerator;

    private ComponentDslBuilderFactoryGenerator(ComponentModel componentModel, ClassLoader classLoader, String packageName) {
        this.componentModel = componentModel;
        this.packageName = packageName;
        this.javaClass = new JavaClass(classLoader);
        this.generateJavaClass();
    }

    public static ComponentDslBuilderFactoryGenerator generateClass(ComponentModel componentModel, ClassLoader classLoader, String componentDslPackageName) {
        Objects.requireNonNull(componentModel);
        Objects.requireNonNull(classLoader);
        return new ComponentDslBuilderFactoryGenerator(componentModel, classLoader, componentDslPackageName);
    }

    public static String getExpectedGeneratedClassName(ComponentModel componentModel) {
        return DslHelper.generateComponentBuilderClassName(componentModel, BUILDER_FACTORY_SUFFIX);
    }

    public String printClassAsString() {
        return this.javaClass.printClass(true);
    }

    public String toString() {
        return this.printClassAsString();
    }

    public String getGeneratedClassName() {
        return ComponentDslBuilderFactoryGenerator.getExpectedGeneratedClassName(this.componentModel);
    }

    public ComponentDslInnerBuilderGenerator getComponentDslInnerBuilderGenerator() {
        return this.componentDslInnerBuilderGenerator;
    }

    public ComponentDslInnerImplBuilderGenerator getComponentDslInnerImplBuilderGenerator() {
        return this.componentDslInnerImplBuilderGenerator;
    }

    private void generateJavaClass() {
        this.setPackage();
        this.setImports();
        this.setJavaDoc();
        this.setMainAnnotations();
        this.setBuilderFactoryClassNameAndType();
        this.componentDslInnerBuilderGenerator = ComponentDslInnerBuilderGenerator.generateClass(this.javaClass.addNestedType(), this.componentModel);
        this.componentDslInnerImplBuilderGenerator = ComponentDslInnerImplBuilderGenerator.generateClass(this.javaClass.addNestedType(), this.componentModel, this.componentDslInnerBuilderGenerator.getGeneratedInterfaceName());
        this.setDslEntryMethod(this.componentDslInnerBuilderGenerator.getGeneratedInterfaceName(), this.componentDslInnerImplBuilderGenerator.getGeneratedClassName());
    }

    private void setPackage() {
        this.javaClass.setPackage(this.packageName + ".dsl");
    }

    private void setImports() {
        this.javaClass.addImport("org.apache.camel.Component");
        this.javaClass.addImport(this.packageName + ".AbstractComponentBuilder");
        this.javaClass.addImport(this.packageName + ".ComponentBuilder");
        this.javaClass.addImport(this.componentModel.getJavaType());
    }

    private void setJavaDoc() {
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!this.componentModel.getDescription().isEmpty()) {
            doc = this.componentModel.getDescription() + "\n\n" + doc;
        }
        doc = JavadocHelper.xmlEncode((String)doc);
        this.javaClass.getJavaDoc().setText(doc);
    }

    private void setMainAnnotations() {
        this.javaClass.addAnnotation(Generated.class).setStringValue("value", ComponentDslMojo.class.getName());
    }

    private void setBuilderFactoryClassNameAndType() {
        this.javaClass.setClass(false).setName(this.getGeneratedClassName());
    }

    private void setDslEntryMethod(String innerBuilderInterfaceName, String innerBuilderImplName) {
        Method method = this.javaClass.addMethod().setStatic().setReturnType(innerBuilderInterfaceName).setName(DslHelper.toCamelCaseLower(this.componentModel.getScheme())).setBody(String.format("return new %s();", innerBuilderImplName));
        if (this.componentModel.isDeprecated()) {
            method.addAnnotation(Deprecated.class);
        }
        String doc = DslHelper.getMainDescriptionWithoutPathOptions(this.componentModel);
        doc = JavadocHelper.xmlEncode((String)doc);
        doc = doc + "\n\n@return the dsl builder\n";
        method.getJavaDoc().setText(doc);
    }
}

