/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz2;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.component.quartz2.CamelJob;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.component.quartz2.QuartzConsumer;
import org.apache.camel.component.quartz2.StatefulCamelJob;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.RoundRobinLoadBalancer;
import org.apache.camel.util.EndpointHelper;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzEndpoint.class);
    private TriggerKey triggerKey;
    private String cron;
    private LoadBalancer consumerLoadBalancer;
    private Map<String, Object> triggerParameters;
    private Map<String, Object> jobParameters;
    private boolean stateful;
    private boolean fireNow;
    private boolean deleteJob = true;
    private boolean pauseJob;
    private long triggerStartDelay = 500L;
    private AtomicBoolean jobAdded = new AtomicBoolean(false);
    private AtomicBoolean jobPaused = new AtomicBoolean(false);

    public QuartzEndpoint(String uri, QuartzComponent quartzComponent) {
        super(uri, (Component)quartzComponent);
    }

    public String getCron() {
        return this.cron;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public boolean isFireNow() {
        return this.fireNow;
    }

    public long getTriggerStartDelay() {
        return this.triggerStartDelay;
    }

    public boolean isDeleteJob() {
        return this.deleteJob;
    }

    public boolean isPauseJob() {
        return this.pauseJob;
    }

    public void setPauseJob(boolean pauseJob) {
        this.pauseJob = pauseJob;
    }

    public void setTriggerStartDelay(long triggerStartDelay) {
        this.triggerStartDelay = triggerStartDelay;
    }

    public void setDeleteJob(boolean deleteJob) {
        this.deleteJob = deleteJob;
    }

    public void setFireNow(boolean fireNow) {
        this.fireNow = fireNow;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public void setTriggerParameters(Map<String, Object> triggerParameters) {
        this.triggerParameters = triggerParameters;
    }

    public void setJobParameters(Map<String, Object> jobParameters) {
        this.jobParameters = jobParameters;
    }

    public LoadBalancer getConsumerLoadBalancer() {
        if (this.consumerLoadBalancer == null) {
            this.consumerLoadBalancer = new RoundRobinLoadBalancer();
        }
        return this.consumerLoadBalancer;
    }

    public void setConsumerLoadBalancer(LoadBalancer consumerLoadBalancer) {
        this.consumerLoadBalancer = consumerLoadBalancer;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public TriggerKey getTriggerKey() {
        return this.triggerKey;
    }

    public void setTriggerKey(TriggerKey triggerKey) {
        this.triggerKey = triggerKey;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Quartz producer is not supported.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        QuartzConsumer result = new QuartzConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)result);
        return result;
    }

    public boolean isSingleton() {
        return false;
    }

    protected void doStart() throws Exception {
        if (this.isDeleteJob() && this.isPauseJob()) {
            throw new IllegalArgumentException("Cannot have both options deleteJob and pauseJob enabled");
        }
        this.addJobInScheduler();
    }

    protected void doStop() throws Exception {
        this.removeJobInScheduler();
    }

    private void removeJobInScheduler() throws Exception {
        boolean isClustered;
        Scheduler scheduler = this.getComponent().getScheduler();
        if (scheduler == null) {
            return;
        }
        if (this.deleteJob) {
            isClustered = scheduler.getMetaData().isJobStoreClustered();
            if (!scheduler.isShutdown() && !isClustered) {
                LOG.info("Deleting job {}", (Object)this.triggerKey);
                scheduler.unscheduleJob(this.triggerKey);
                this.jobAdded.set(false);
            }
        } else if (this.pauseJob) {
            isClustered = scheduler.getMetaData().isJobStoreClustered();
            if (!scheduler.isShutdown() && !isClustered) {
                LOG.info("Pausing job {}", (Object)this.triggerKey);
                scheduler.pauseTrigger(this.triggerKey);
                this.jobAdded.set(false);
            }
        }
        AtomicInteger number = (AtomicInteger)scheduler.getContext().get((Object)"CamelQuartzJobsCount");
        number.decrementAndGet();
    }

    private void addJobInScheduler() throws Exception {
        Date nextFireDate;
        Scheduler scheduler = this.getComponent().getScheduler();
        Trigger trigger = scheduler.getTrigger(this.triggerKey);
        if (trigger == null) {
            JobDetail jobDetail = this.createJobDetail();
            trigger = this.createTrigger();
            this.updateJobDataMap(jobDetail);
            nextFireDate = scheduler.scheduleJob(jobDetail, trigger);
            LOG.info("Job {} (triggerType={}, jobClass={}) is scheduled. Next fire date is {}", new Object[]{trigger.getKey(), trigger.getClass().getSimpleName(), jobDetail.getJobClass().getSimpleName(), nextFireDate});
        } else {
            this.ensureNoDupTriggerKey();
            JobDetail jobDetail = scheduler.getJobDetail(trigger.getJobKey());
            this.updateJobDataMap(jobDetail);
            scheduler.addJob(jobDetail, true);
            nextFireDate = trigger.getNextFireTime();
            LOG.info("Reuse existing Job {} (triggerType={}, jobType={}) is scheduled. Next fire date is {}", new Object[]{trigger.getKey(), trigger.getClass().getSimpleName(), jobDetail.getJobClass().getSimpleName(), nextFireDate});
        }
        AtomicInteger number = (AtomicInteger)scheduler.getContext().get((Object)"CamelQuartzJobsCount");
        number.incrementAndGet();
        this.jobAdded.set(true);
    }

    private void ensureNoDupTriggerKey() {
        for (Route route : this.getCamelContext().getRoutes()) {
            QuartzEndpoint quartzEndpoint;
            TriggerKey checkTriggerKey;
            if (!(route.getEndpoint() instanceof QuartzEndpoint) || !this.triggerKey.equals((Object)(checkTriggerKey = (quartzEndpoint = (QuartzEndpoint)route.getEndpoint()).getTriggerKey()))) continue;
            throw new IllegalArgumentException("Trigger key " + this.triggerKey + " is already in used by " + (Object)((Object)quartzEndpoint));
        }
    }

    private void updateJobDataMap(JobDetail jobDetail) {
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String camelContextName = this.getCamelContext().getManagementName();
        String endpointUri = this.getEndpointUri();
        LOG.debug("Adding camelContextName={}, endpintUri={} into job data map.", (Object)camelContextName, (Object)endpointUri);
        jobDataMap.put("CamelQuartzCamelContextName", camelContextName);
        jobDataMap.put("CamelQuartzEndpoint", endpointUri);
    }

    private Trigger createTrigger() throws Exception {
        Trigger result;
        Date startTime = new Date();
        if (this.getComponent().getScheduler().isStarted()) {
            startTime = new Date(System.currentTimeMillis() + this.triggerStartDelay);
        }
        if (this.cron != null) {
            LOG.debug("Creating CronTrigger: {}", (Object)this.cron);
            result = TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron).withMisfireHandlingInstructionFireAndProceed()).build();
        } else {
            String intervalString;
            LOG.debug("Creating SimpleTrigger.");
            TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(this.triggerKey).startAt(startTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withMisfireHandlingInstructionFireNow());
            if (this.fireNow && (intervalString = (String)this.triggerParameters.get("repeatInterval")) != null) {
                long interval = Long.valueOf(intervalString);
                triggerBuilder.startAt(new Date(System.currentTimeMillis() - interval));
            }
            result = triggerBuilder.build();
        }
        if (this.triggerParameters != null && this.triggerParameters.size() > 0) {
            LOG.debug("Setting user extra triggerParameters {}", this.triggerParameters);
            this.setProperties(result, this.triggerParameters);
        }
        LOG.debug("Created trigger={}", (Object)result);
        return result;
    }

    private void setProperties(Object bean, Map<String, Object> parameters) throws Exception {
        EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)bean, parameters);
        EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)bean, parameters);
    }

    private JobDetail createJobDetail() throws Exception {
        String name = this.triggerKey.getName();
        String group = this.triggerKey.getGroup();
        Class jobClass = this.stateful ? StatefulCamelJob.class : CamelJob.class;
        LOG.debug("Creating new {}.", (Object)jobClass.getSimpleName());
        JobDetail result = JobBuilder.newJob((Class)jobClass).withIdentity(name, group).build();
        if (this.jobParameters != null && this.jobParameters.size() > 0) {
            LOG.debug("Setting user extra jobParameters {}", this.jobParameters);
            this.setProperties(result, this.jobParameters);
        }
        LOG.debug("Created jobDetail={}", (Object)result);
        return result;
    }

    public QuartzComponent getComponent() {
        return (QuartzComponent)super.getComponent();
    }

    public void pauseTrigger() throws Exception {
        if (this.jobPaused.get()) {
            return;
        }
        this.jobPaused.set(true);
        Scheduler scheduler = this.getComponent().getScheduler();
        if (scheduler != null) {
            LOG.info("Pausing trigger {}", (Object)this.triggerKey);
            scheduler.pauseTrigger(this.triggerKey);
        }
    }

    public void resumeTrigger() throws Exception {
        if (!this.jobPaused.get()) {
            return;
        }
        this.jobPaused.set(false);
        Scheduler scheduler = this.getComponent().getScheduler();
        if (scheduler != null) {
            LOG.info("Resuming trigger {}", (Object)this.triggerKey);
            scheduler.resumeTrigger(this.triggerKey);
        }
    }

    public void onConsumerStart(QuartzConsumer quartzConsumer) throws Exception {
        this.getConsumerLoadBalancer().addProcessor(quartzConsumer.getProcessor());
        if (!this.jobAdded.get()) {
            this.addJobInScheduler();
        } else {
            this.resumeTrigger();
        }
    }

    public void onConsumerStop(QuartzConsumer quartzConsumer) throws Exception {
        this.getConsumerLoadBalancer().removeProcessor(quartzConsumer.getProcessor());
        if (this.jobAdded.get()) {
            this.pauseTrigger();
        }
    }
}

