/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.pollconsumer.quartz2;

import java.util.TimeZone;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.component.quartz2.QuartzComponent;
import org.apache.camel.component.quartz2.QuartzHelper;
import org.apache.camel.pollconsumer.quartz2.QuartzScheduledPollConsumerJob;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduledPollConsumerScheduler
extends ServiceSupport
implements ScheduledPollConsumerScheduler,
NonManagedService {
    private static final Logger LOG = LoggerFactory.getLogger(QuartzScheduledPollConsumerScheduler.class);
    private Scheduler quartzScheduler;
    private CamelContext camelContext;
    private String routeId;
    private Consumer consumer;
    private Runnable runnable;
    private String cron;
    private String triggerId;
    private String triggerGroup = "QuartzScheduledPollConsumerScheduler";
    private TimeZone timeZone = TimeZone.getDefault();
    private volatile CronTrigger trigger;
    private volatile JobDetail job;

    public void onInit(Consumer consumer) {
        this.consumer = consumer;
        for (Route route : consumer.getEndpoint().getCamelContext().getRoutes()) {
            if (route.getConsumer() != consumer) continue;
            this.routeId = route.getId();
            break;
        }
    }

    public void scheduleTask(Runnable runnable) {
        this.runnable = runnable;
    }

    public void unscheduleTask() {
        if (this.trigger != null) {
            LOG.debug("Unscheduling trigger: {}", (Object)this.trigger.getKey());
            try {
                this.quartzScheduler.unscheduleJob(this.trigger.getKey());
            }
            catch (SchedulerException e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public void startScheduler() {
    }

    public boolean isSchedulerStarted() {
        try {
            return this.quartzScheduler != null && this.quartzScheduler.isStarted();
        }
        catch (SchedulerException e) {
            return false;
        }
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void setQuartzScheduler(Scheduler scheduler) {
        this.quartzScheduler = scheduler;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public String getTriggerGroup() {
        return this.triggerGroup;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.triggerGroup = triggerGroup;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notEmpty((String)this.cron, (String)"cron", (Object)((Object)this));
        if (this.quartzScheduler == null) {
            QuartzComponent quartz = (QuartzComponent)this.getCamelContext().getComponent("quartz2", QuartzComponent.class);
            this.setQuartzScheduler(quartz.getScheduler());
        }
        JobDataMap map = new JobDataMap();
        if (this.routeId != null) {
            map.put("routeId", this.routeId);
        } else {
            map.put("task", (Object)this.runnable);
        }
        map.put("CamelQuartzTriggerType", "cron");
        map.put("CamelQuartzTriggerCronExpression", this.getCron());
        map.put("CamelQuartzTriggerCronTimeZone", this.getTimeZone().getID());
        this.job = JobBuilder.newJob(QuartzScheduledPollConsumerJob.class).usingJobData(map).build();
        QuartzHelper.updateJobDataMap(this.getCamelContext(), this.job, null);
        String id = this.triggerId;
        if (id == null) {
            id = "trigger-" + this.getCamelContext().getUuidGenerator().generateUuid();
        }
        this.trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(id, this.triggerGroup).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.getCron()).inTimeZone(this.getTimeZone())).build();
        LOG.debug("Scheduling job: {} with trigger: {}", (Object)this.job, (Object)this.trigger.getKey());
        this.quartzScheduler.scheduleJob(this.job, (Trigger)this.trigger);
    }

    protected void doStop() throws Exception {
        if (this.trigger != null) {
            LOG.debug("Unscheduling trigger: {}", (Object)this.trigger.getKey());
            this.quartzScheduler.unscheduleJob(this.trigger.getKey());
        }
    }

    protected void doShutdown() throws Exception {
    }
}

