/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rabbitmq.reply;

import com.rabbitmq.client.AMQP;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;

public class ReplyHolder {
    private final Exchange exchange;
    private final AsyncCallback callback;
    private final byte[] message;
    private final String originalCorrelationId;
    private final String correlationId;
    private long timeout;
    private AMQP.BasicProperties properties;

    public ReplyHolder(Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, AMQP.BasicProperties properties, byte[] message) {
        this.exchange = exchange;
        this.callback = callback;
        this.originalCorrelationId = originalCorrelationId;
        this.correlationId = correlationId;
        this.properties = properties;
        this.message = message;
    }

    public ReplyHolder(Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long timeout) {
        this(exchange, callback, originalCorrelationId, correlationId, null, null);
        this.timeout = timeout;
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public AsyncCallback getCallback() {
        return this.callback;
    }

    public String getOriginalCorrelationId() {
        return this.originalCorrelationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public byte[] getMessage() {
        return this.message;
    }

    public boolean isTimeout() {
        return this.message == null;
    }

    public long getRequestTimeout() {
        return this.timeout;
    }

    public AMQP.BasicProperties getProperties() {
        return this.properties;
    }
}

