/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class DefaultRestletBinding
implements RestletBinding,
HeaderFilterStrategyAware {
    private static final Log LOG = LogFactory.getLog(DefaultRestletBinding.class);
    private HeaderFilterStrategy headerFilterStrategy;

    public void populateExchangeFromRestletRequest(Request request, Exchange exchange) throws Exception {
        Message inMessage = exchange.getIn();
        for (Map.Entry entry : request.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            inMessage.setHeader((String)entry.getKey(), entry.getValue());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Populate exchange from Restlet request header: " + (String)entry.getKey() + " value: " + entry.getValue()));
        }
        String query = request.getResourceRef().getQuery();
        if (query != null) {
            inMessage.setHeader("CamelHttpQuery", (Object)query);
        }
        inMessage.setHeader("CamelHttpUri", (Object)request.getResourceRef().getIdentifier(true));
        inMessage.setHeader("CamelHttpMethod", (Object)request.getMethod().toString());
        if (!request.isEntityAvailable()) {
            return;
        }
        if (request.getEntity().getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM)) {
            Form form = new Form(request.getEntity());
            for (Map.Entry entry : form.getValuesMap().entrySet()) {
                if (entry.getValue() == null) {
                    inMessage.setBody(entry.getKey());
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Populate exchange from Restlet request body: " + (String)entry.getValue()));
                    continue;
                }
                if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                inMessage.setHeader((String)entry.getKey(), entry.getValue());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Populate exchange from Restlet request user header: " + (String)entry.getKey() + " value: " + (String)entry.getValue()));
            }
        } else {
            inMessage.setBody((Object)request.getEntity().getStream());
        }
    }

    public void populateRestletRequestFromExchange(Request request, Exchange exchange) {
        request.setReferrerRef("camel-restlet");
        String body = (String)exchange.getIn().getBody(String.class);
        Form form = new Form();
        form.add(body, null);
        MediaType mediaType = (MediaType)exchange.getIn().getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_WWW_FORM;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Populate Restlet request from exchange body: " + body + " using media type " + mediaType));
        }
        String login = (String)exchange.getIn().getHeader("CamelRestletLogin", String.class);
        String password = (String)exchange.getIn().getHeader("CamelRestletPassword", String.class);
        if (login != null && password != null) {
            ChallengeResponse authentication = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, login, password);
            request.setChallengeResponse(authentication);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Basic HTTP Authentication has been applied");
            }
        }
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
                if (((String)entry.getKey()).startsWith("org.restlet.")) {
                    request.getAttributes().put(entry.getKey(), entry.getValue());
                } else {
                    form.add((String)entry.getKey(), entry.getValue().toString());
                }
            } else {
                request.getAttributes().put(entry.getKey(), entry.getValue());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Populate Restlet request from exchange header: " + (String)entry.getKey() + " value: " + entry.getValue()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using Content Type: " + mediaType + " for POST data: " + body));
        }
        if (request.getMethod() == Method.GET || request.getMethod() == Method.POST && mediaType == MediaType.APPLICATION_WWW_FORM) {
            request.setEntity(form.getWebRepresentation());
        } else {
            request.setEntity(body, mediaType);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void populateRestletResponseFromExchange(Exchange exchange, Response response) {
        Integer responseCode;
        Message out;
        block11: {
            if (exchange.isFailed()) {
                response.setStatus(Status.valueOf((int)500));
                if (exchange.hasOut() && exchange.getOut().isFault()) {
                    out = exchange.getOut();
                    break block11;
                } else {
                    Exception t = exchange.getException();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    response.setEntity(sw.toString(), MediaType.TEXT_PLAIN);
                    return;
                }
            }
            out = exchange.getOut();
        }
        MediaType mediaType = (MediaType)out.getHeader("Content-Type", MediaType.class);
        if (mediaType == null) {
            Object body = out.getBody();
            mediaType = MediaType.TEXT_PLAIN;
            if (body instanceof String) {
                mediaType = MediaType.TEXT_PLAIN;
            } else if (body instanceof StringSource || body instanceof DOMSource) {
                mediaType = MediaType.TEXT_XML;
            }
        }
        if ((responseCode = (Integer)out.getHeader("CamelHttpResponseCode", Integer.class)) != null) {
            response.setStatus(Status.valueOf((int)responseCode));
        }
        for (Map.Entry entry : out.getHeaders().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToCamelHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            response.getAttributes().put(entry.getKey(), entry.getValue());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Populate Restlet response from exchange header: " + (String)entry.getKey() + " value: " + entry.getValue()));
        }
        String text = (String)out.getBody(String.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Populate Restlet response from exchange body: " + text));
        }
        response.setEntity(text, mediaType);
        if (exchange.getProperty("CamelCharsetName") != null) {
            CharacterSet cs = CharacterSet.valueOf((String)((String)exchange.getProperty("CamelCharsetName", String.class)));
            response.getEntity().setCharacterSet(cs);
        }
    }

    public void populateExchangeFromRestletResponse(Exchange exchange, Response response) throws Exception {
        for (Map.Entry entry : response.getAttributes().entrySet()) {
            if (this.headerFilterStrategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
            exchange.getOut().setHeader((String)entry.getKey(), entry.getValue());
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Populate exchange from Restlet response header: " + (String)entry.getKey() + " value: " + entry.getValue()));
        }
        int responseCode = response.getStatus().getCode();
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)responseCode);
        if (response.getEntity() != null) {
            MediaType mediaType = response.getEntity().getMediaType();
            if (mediaType != null) {
                exchange.getOut().setHeader("Content-Type", (Object)mediaType.toString());
            }
            String text = response.getEntity().getText();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Populate exchange from Restlet response: " + text));
            }
            exchange.getOut().setBody((Object)text);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy strategy) {
        this.headerFilterStrategy = strategy;
    }
}

