/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestletConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(RestletConsumer.class);
    private Restlet restlet = new Restlet(){

        public void handle(Request request, Response response) {
            LOG.debug("Consumer restlet handle request method: {}", (Object)request.getMethod());
            try {
                Exchange exchange = RestletConsumer.this.getEndpoint().createExchange();
                RestletBinding binding = RestletConsumer.this.getEndpoint().getRestletBinding();
                binding.populateExchangeFromRestletRequest(request, response, exchange);
                try {
                    RestletConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                binding.populateRestletResponseFromExchange(exchange, response);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot process request", (Throwable)e);
            }
        }
    };

    public RestletConsumer(Endpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
    }

    public RestletEndpoint getEndpoint() {
        return (RestletEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getEndpoint().connect(this);
    }

    public void doStop() throws Exception {
        this.getEndpoint().disconnect(this);
        super.doStop();
    }

    public Restlet getRestlet() {
        return this.restlet;
    }
}

