/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Method;

public class PicklistEnumConverter
implements Converter {
    private static final String FACTORY_METHOD = "fromValue";

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class<?> aClass = o.getClass();
        try {
            Method getterMethod = aClass.getMethod("value", new Class[0]);
            writer.setValue((String)getterMethod.invoke(o, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Exception writing pick list value %s of type %s: %s", o, o.getClass().getName(), e.getMessage()), e);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String value = reader.getValue();
        Class requiredType = context.getRequiredType();
        try {
            Method factoryMethod = requiredType.getMethod(FACTORY_METHOD, String.class);
            return factoryMethod.invoke(null, value);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(String.format("Security Exception reading pick list value %s of type %s: %s", value, context.getRequiredType().getName(), e.getMessage()), e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Exception reading pick list value %s of type %s: %s", value, context.getRequiredType().getName(), e.getMessage()), e);
        }
    }

    public boolean canConvert(Class aClass) {
        try {
            return Enum.class.isAssignableFrom(aClass) && aClass.getMethod(FACTORY_METHOD, String.class) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

