/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.api.dto.CreateSObjectResult;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.RestResources;
import org.apache.camel.component.salesforce.api.dto.SObjectBasicInfo;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SearchResult;
import org.apache.camel.component.salesforce.api.dto.Version;
import org.apache.camel.component.salesforce.internal.processor.AbstractRestProcessor;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.type.TypeReference;
import org.eclipse.jetty.util.StringUtil;

public class JsonRestProcessor
extends AbstractRestProcessor {
    private static final String RESPONSE_TYPE = JsonRestProcessor.class.getName() + ".responseType";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonRestProcessor(SalesforceEndpoint endpoint) throws SalesforceException {
        super(endpoint);
        this.objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
    }

    @Override
    protected void processRequest(Exchange exchange) throws SalesforceException {
        switch (this.operationName) {
            case GET_VERSIONS: {
                exchange.setProperty(RESPONSE_TYPE, (Object)new TypeReference<List<Version>>(){});
                break;
            }
            case GET_RESOURCES: {
                exchange.setProperty(RESPONSE_CLASS, RestResources.class);
                break;
            }
            case GET_GLOBAL_OBJECTS: {
                exchange.setProperty(RESPONSE_CLASS, GlobalObjects.class);
                break;
            }
            case GET_BASIC_INFO: {
                exchange.setProperty(RESPONSE_CLASS, SObjectBasicInfo.class);
                break;
            }
            case GET_DESCRIPTION: {
                exchange.setProperty(RESPONSE_CLASS, SObjectDescription.class);
                break;
            }
            case CREATE_SOBJECT: {
                exchange.setProperty(RESPONSE_CLASS, CreateSObjectResult.class);
                break;
            }
            case UPSERT_SOBJECT: {
                exchange.setProperty(RESPONSE_CLASS, CreateSObjectResult.class);
                break;
            }
            case SEARCH: {
                exchange.setProperty(RESPONSE_TYPE, (Object)new TypeReference<List<SearchResult>>(){});
                break;
            }
        }
    }

    @Override
    protected InputStream getRequestStream(Exchange exchange) throws SalesforceException {
        try {
            Message in = exchange.getIn();
            InputStream request = (InputStream)in.getBody(InputStream.class);
            if (request == null) {
                AbstractSObjectBase sObject = (AbstractSObjectBase)in.getBody(AbstractSObjectBase.class);
                if (sObject != null) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    this.objectMapper.writeValue((OutputStream)out, (Object)sObject);
                    request = new ByteArrayInputStream(out.toByteArray());
                } else {
                    String body = (String)in.getBody(String.class);
                    if (null == body) {
                        String msg = "Unsupported request message body " + (in.getBody() == null ? null : in.getBody().getClass());
                        throw new SalesforceException(msg, null);
                    }
                    request = new ByteArrayInputStream(body.getBytes(StringUtil.__UTF8_CHARSET));
                }
            }
            return request;
        }
        catch (IOException e) {
            String msg = "Error marshaling request: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processResponse(Exchange exchange, InputStream responseEntity, SalesforceException ex, AsyncCallback callback) {
        try {
            if (responseEntity != null) {
                TypeReference responseType;
                Object response = null;
                Class responseClass = (Class)exchange.getProperty(RESPONSE_CLASS, Class.class);
                response = responseClass != null ? this.objectMapper.readValue(responseEntity, responseClass) : ((responseType = (TypeReference)exchange.getProperty(RESPONSE_TYPE, TypeReference.class)) != null ? this.objectMapper.readValue(responseEntity, responseType) : responseEntity);
                exchange.getOut().setBody(response);
            } else {
                exchange.setException((Throwable)((Object)ex));
            }
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            exchange.getOut().getAttachments().putAll(exchange.getIn().getAttachments());
        }
        catch (IOException e) {
            String msg = "Error parsing JSON response: " + e.getMessage();
            exchange.setException((Throwable)((Object)new SalesforceException(msg, e)));
        }
        finally {
            exchange.removeProperty(RESPONSE_CLASS);
            exchange.removeProperty(RESPONSE_TYPE);
            try {
                if (responseEntity != null) {
                    responseEntity.close();
                }
            }
            catch (IOException ignored) {}
            callback.done(false);
        }
    }
}

