/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Method;

public class MultiSelectPicklistConverter
implements Converter {
    private static final String FACTORY_METHOD = "fromValue";

    public void marshal(Object o, HierarchicalStreamWriter writer, MarshallingContext context) {
        Class<?> arrayClass = o.getClass();
        Class<?> aClass = arrayClass.getComponentType();
        try {
            Method getterMethod = aClass.getMethod("value", new Class[0]);
            int length = Array.getLength(o);
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                buffer.append((String)getterMethod.invoke(Array.get(o, i), new Object[0]));
                if (i >= length - 1) continue;
                buffer.append(';');
            }
            writer.setValue(buffer.toString());
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Exception writing pick list value %s of type %s: %s", o, o.getClass().getName(), e.getMessage()), (Throwable)e);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String listValue = reader.getValue();
        Class requiredArrayType = context.getRequiredType();
        Class<?> requiredType = requiredArrayType.getComponentType();
        try {
            Method factoryMethod = requiredType.getMethod(FACTORY_METHOD, String.class);
            String[] value = listValue.split(";");
            int length = value.length;
            Object resultArray = Array.newInstance(requiredType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(resultArray, i, factoryMethod.invoke(null, value[i].trim()));
            }
            return resultArray;
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Exception reading pick list value %s of type %s: %s", listValue, requiredArrayType.getName(), e.getMessage()), (Throwable)e);
        }
    }

    public boolean canConvert(Class aClass) {
        try {
            Class<?> componentType = aClass.getComponentType();
            return componentType != null && Enum.class.isAssignableFrom(componentType) && componentType.getMethod(FACTORY_METHOD, String.class) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

