/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.CachingMapper;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.JodaTimeConverter;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractDTOBase;
import org.apache.camel.component.salesforce.api.dto.CreateSObjectResult;
import org.apache.camel.component.salesforce.api.dto.GlobalObjects;
import org.apache.camel.component.salesforce.api.dto.RestResources;
import org.apache.camel.component.salesforce.api.dto.SObjectBasicInfo;
import org.apache.camel.component.salesforce.api.dto.SObjectDescription;
import org.apache.camel.component.salesforce.api.dto.SearchResults;
import org.apache.camel.component.salesforce.api.dto.Versions;
import org.apache.camel.component.salesforce.internal.client.XStreamUtils;
import org.apache.camel.component.salesforce.internal.processor.AbstractRestProcessor;

public class XmlRestProcessor
extends AbstractRestProcessor {
    private static ThreadLocal<XStream> xStream = new ThreadLocal<XStream>(){

        @Override
        protected XStream initialValue() {
            XStream result = new XStream((HierarchicalStreamDriver)new XppDriver((NameCoder)new NoNameCoder()){

                public HierarchicalStreamWriter createWriter(Writer out) {
                    return new CompactWriter(out, this.getNameCoder());
                }
            });
            XStreamUtils.addDefaultPermissions(result);
            result.registerConverter((Converter)new JodaTimeConverter());
            return result;
        }
    };
    private static final String RESPONSE_ALIAS = XmlRestProcessor.class.getName() + ".responseAlias";

    public XmlRestProcessor(SalesforceEndpoint endpoint) throws SalesforceException {
        super(endpoint);
    }

    @Override
    protected void processRequest(Exchange exchange) throws SalesforceException {
        switch (this.operationName) {
            case GET_VERSIONS: {
                exchange.setProperty(RESPONSE_CLASS, Versions.class);
                break;
            }
            case GET_RESOURCES: {
                exchange.setProperty(RESPONSE_CLASS, RestResources.class);
                break;
            }
            case GET_GLOBAL_OBJECTS: {
                exchange.setProperty(RESPONSE_CLASS, GlobalObjects.class);
                break;
            }
            case GET_BASIC_INFO: {
                exchange.setProperty(RESPONSE_CLASS, SObjectBasicInfo.class);
                exchange.setProperty(RESPONSE_ALIAS, (Object)this.getParameter("sObjectName", exchange, true, false));
                break;
            }
            case GET_DESCRIPTION: {
                exchange.setProperty(RESPONSE_CLASS, SObjectDescription.class);
                exchange.setProperty(RESPONSE_ALIAS, (Object)this.getParameter("sObjectName", exchange, true, false));
                break;
            }
            case GET_SOBJECT: {
                exchange.setProperty(RESPONSE_ALIAS, (Object)this.getParameter("sObjectName", exchange, false, false));
                break;
            }
            case CREATE_SOBJECT: {
                exchange.setProperty(RESPONSE_CLASS, CreateSObjectResult.class);
                break;
            }
            case GET_SOBJECT_WITH_ID: {
                exchange.setProperty(RESPONSE_ALIAS, (Object)this.getParameter("sObjectName", exchange, false, false));
                break;
            }
            case UPSERT_SOBJECT: {
                exchange.setProperty(RESPONSE_CLASS, CreateSObjectResult.class);
                break;
            }
            case QUERY: 
            case QUERY_MORE: {
                exchange.setProperty(RESPONSE_ALIAS, (Object)"QueryResult");
                break;
            }
            case SEARCH: {
                exchange.setProperty(RESPONSE_CLASS, SearchResults.class);
                break;
            }
            case APEX_CALL: {
                exchange.setProperty(RESPONSE_ALIAS, (Object)"response");
                break;
            }
        }
    }

    @Override
    protected InputStream getRequestStream(Exchange exchange) throws SalesforceException {
        XStream localXStream = xStream.get();
        try {
            Message in = exchange.getIn();
            InputStream request = (InputStream)in.getBody(InputStream.class);
            if (request == null) {
                AbstractDTOBase dto = (AbstractDTOBase)in.getBody(AbstractDTOBase.class);
                if (dto != null) {
                    localXStream.processAnnotations(dto.getClass());
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    localXStream.toXML((Object)dto, (Writer)new OutputStreamWriter((OutputStream)out, "UTF-8"));
                    request = new ByteArrayInputStream(out.toByteArray());
                } else {
                    String body = (String)in.getBody(String.class);
                    if (null == body) {
                        String msg = "Unsupported request message body " + (in.getBody() == null ? null : in.getBody().getClass());
                        throw new SalesforceException(msg, null);
                    }
                    request = new ByteArrayInputStream(body.getBytes("UTF-8"));
                }
            }
            return request;
        }
        catch (XStreamException e) {
            String msg = "Error marshaling request: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Error marshaling request: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processResponse(Exchange exchange, InputStream responseEntity, SalesforceException exception, AsyncCallback callback) {
        XStream localXStream = xStream.get();
        try {
            if (responseEntity != null) {
                InputStream response;
                Class responseClass = (Class)exchange.getProperty(RESPONSE_CLASS, Class.class);
                if (responseClass != null) {
                    localXStream.processAnnotations(responseClass);
                    String responseAlias = (String)exchange.getProperty(RESPONSE_ALIAS, String.class);
                    if (responseAlias != null) {
                        CachingMapper mapper = (CachingMapper)localXStream.getMapper();
                        try {
                            if (mapper.realClass(responseAlias) != responseClass) {
                                mapper.flushCache();
                            }
                        }
                        catch (CannotResolveClassException ignore) {
                            mapper.flushCache();
                        }
                        localXStream.alias(responseAlias, responseClass);
                    }
                    response = responseClass.newInstance();
                    localXStream.fromXML(responseEntity, (Object)response);
                } else {
                    response = responseEntity;
                }
                exchange.getOut().setBody((Object)response);
            } else {
                exchange.setException((Throwable)((Object)exception));
            }
            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
            exchange.getOut().getAttachments().putAll(exchange.getIn().getAttachments());
        }
        catch (XStreamException e) {
            String msg = "Error parsing XML response: " + e.getMessage();
            exchange.setException((Throwable)((Object)new SalesforceException(msg, e)));
        }
        catch (Exception e) {
            String msg = "Error creating XML response: " + e.getMessage();
            exchange.setException((Throwable)((Object)new SalesforceException(msg, e)));
        }
        finally {
            exchange.removeProperty(RESPONSE_CLASS);
            exchange.removeProperty(RESPONSE_ALIAS);
            if (responseEntity != null) {
                try {
                    responseEntity.close();
                }
                catch (IOException e) {}
            }
            callback.done(false);
        }
    }
}

