/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Service;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.SalesforceHttpRequest;
import org.apache.camel.component.salesforce.internal.client.SalesforceSecurityHandler;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBase
implements SalesforceSession.SalesforceSessionListener,
Service {
    protected static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    protected static final String APPLICATION_XML_UTF8 = "application/xml;charset=utf-8";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final SalesforceHttpClient httpClient;
    protected final SalesforceSession session;
    protected final String version;
    protected String accessToken;
    protected String instanceUrl;

    public AbstractClientBase(String version, SalesforceSession session, SalesforceHttpClient httpClient) throws SalesforceException {
        this.version = version;
        this.session = session;
        this.httpClient = httpClient;
    }

    public void start() throws Exception {
        this.accessToken = this.session.getAccessToken();
        if (this.accessToken == null) {
            this.accessToken = this.session.login(this.accessToken);
        }
        this.instanceUrl = this.session.getInstanceUrl();
        this.session.addListener(this);
    }

    public void stop() throws Exception {
        this.session.removeListener(this);
    }

    @Override
    public void onLogin(String accessToken, String instanceUrl) {
        if (!accessToken.equals(this.accessToken)) {
            this.accessToken = accessToken;
            this.instanceUrl = instanceUrl;
        }
    }

    @Override
    public void onLogout() {
    }

    protected Request getRequest(HttpMethod method, String url) {
        return this.getRequest(method.asString(), url);
    }

    protected Request getRequest(String method, String url) {
        SalesforceHttpRequest request = (SalesforceHttpRequest)this.httpClient.newRequest(url).method(method).timeout(this.session.getTimeout(), TimeUnit.MILLISECONDS);
        request.getConversation().setAttribute(SalesforceSecurityHandler.CLIENT_ATTRIBUTE, (Object)this);
        return request;
    }

    protected void doHttpRequest(final Request request, final ClientResponseCallback callback) {
        ContentProvider content = request.getContent();
        if (content instanceof InputStreamContentProvider) {
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
            for (ByteBuffer buffer : content) {
                buffers.add(buffer);
            }
            request.content((ContentProvider)new ByteBufferContentProvider(buffers.toArray(new ByteBuffer[buffers.size()])));
            buffers.clear();
        }
        request.send((Response.CompleteListener)new BufferingResponseListener(this.httpClient.getMaxContentLength()){

            public void onComplete(Result result) {
                Response response = result.getResponse();
                if (result.isFailed()) {
                    Throwable failure = result.getFailure();
                    if (failure instanceof SalesforceException) {
                        callback.onResponse(null, (SalesforceException)((Object)failure));
                    } else {
                        String msg = String.format("Unexpected error {%s:%s} executing {%s:%s}", response.getStatus(), response.getReason(), request.getMethod(), request.getURI());
                        callback.onResponse(null, new SalesforceException(msg, response.getStatus(), failure));
                    }
                } else {
                    int status = response.getStatus();
                    SalesforceHttpRequest request2 = (SalesforceHttpRequest)((Object)((SalesforceHttpRequest)result.getRequest()).getConversation().getAttribute(SalesforceSecurityHandler.AUTHENTICATION_REQUEST_ATTRIBUTE));
                    if (status == 400 && request2 != null) {
                        HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                        try {
                            AbstractClientBase.this.session.parseLoginResponse((ContentResponse)contentResponse, this.getContentAsString());
                            String msg = String.format("Unexpected Error {%s:%s} executing {%s:%s}", status, response.getReason(), request2.getMethod(), request2.getURI());
                            callback.onResponse(null, new SalesforceException(msg, null));
                        }
                        catch (SalesforceException e) {
                            String msg = String.format("Error {%s:%s} executing {%s:%s}", status, response.getReason(), request2.getMethod(), request2.getURI());
                            callback.onResponse(null, new SalesforceException(msg, response.getStatus(), (Throwable)((Object)e)));
                        }
                    } else if (status < 200 || status >= 300) {
                        request2 = (SalesforceHttpRequest)result.getRequest();
                        String msg = String.format("Error {%s:%s} executing {%s:%s}", status, response.getReason(), request2.getMethod(), request2.getURI());
                        SalesforceException cause = AbstractClientBase.this.createRestException(response, this.getContentAsInputStream());
                        callback.onResponse(null, new SalesforceException(msg, response.getStatus(), (Throwable)((Object)cause)));
                    } else {
                        callback.onResponse(this.getContentAsInputStream(), null);
                    }
                }
            }

            public InputStream getContentAsInputStream() {
                if (this.getContent().length == 0) {
                    return null;
                }
                return super.getContentAsInputStream();
            }
        });
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    protected abstract void setAccessToken(Request var1);

    protected abstract SalesforceException createRestException(Response var1, InputStream var2);

    protected static interface ClientResponseCallback {
        public void onResponse(InputStream var1, SalesforceException var2);
    }
}

