/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.WaitForTaskToComplete;
import org.apache.camel.component.seda.QueueReference;
import org.apache.camel.component.seda.SedaConsumerNotAvailableException;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedaProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SedaProducer.class);
    private final SedaEndpoint endpoint;
    private final WaitForTaskToComplete waitForTaskToComplete;
    private final long timeout;
    private final boolean blockWhenFull;
    private final boolean discardWhenFull;
    private final long offerTimeout;

    public SedaProducer(SedaEndpoint endpoint, WaitForTaskToComplete waitForTaskToComplete, long timeout, boolean blockWhenFull, boolean discardWhenFull, long offerTimeout) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.waitForTaskToComplete = waitForTaskToComplete;
        this.timeout = timeout;
        this.blockWhenFull = blockWhenFull;
        this.discardWhenFull = discardWhenFull;
        this.offerTimeout = offerTimeout;
    }

    public boolean process(final Exchange exchange, AsyncCallback callback) {
        WaitForTaskToComplete wait = this.waitForTaskToComplete;
        if (exchange.getProperty("CamelAsyncWait") != null) {
            wait = (WaitForTaskToComplete)exchange.getProperty("CamelAsyncWait", WaitForTaskToComplete.class);
        }
        if (wait == WaitForTaskToComplete.Always || wait == WaitForTaskToComplete.IfReplyExpected && ExchangeHelper.isOutCapable((Exchange)exchange)) {
            Exchange copy = this.prepareCopy(exchange, false);
            final CountDownLatch latch = new CountDownLatch(1);
            copy.getExchangeExtension().addOnCompletion((Synchronization)new SynchronizationAdapter(){

                public void onDone(Exchange response) {
                    if (latch.getCount() == 0L) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("{}. Timeout occurred so response will be ignored: {}", (Object)this, (Object)response.getMessage());
                        }
                        return;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("{} with response: {}", (Object)this, (Object)response.getMessage());
                    }
                    try {
                        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)response);
                    }
                    finally {
                        latch.countDown();
                    }
                }

                public boolean allowHandover() {
                    return false;
                }

                public String toString() {
                    return "onDone at endpoint: " + SedaProducer.this.endpoint;
                }
            });
            try {
                this.addToQueue(copy, false);
            }
            catch (SedaConsumerNotAvailableException e) {
                exchange.setException((Throwable)((Object)e));
                callback.done(true);
                return true;
            }
            if (this.timeout > 0L) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Waiting for task to complete using timeout (ms): {} at [{}]", (Object)this.timeout, (Object)this.endpoint.getEndpointUri());
                }
                boolean done = false;
                try {
                    done = latch.await(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!done) {
                    exchange.setException((Throwable)new ExchangeTimedOutException(exchange, this.timeout));
                    this.endpoint.getQueue().remove(copy);
                    latch.countDown();
                }
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Waiting for task to complete (blocking) at [{}]", (Object)this.endpoint.getEndpointUri());
                }
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            try {
                this.addToQueue(exchange, true);
            }
            catch (SedaConsumerNotAvailableException e) {
                exchange.setException((Throwable)((Object)e));
                callback.done(true);
                return true;
            }
        }
        callback.done(true);
        return true;
    }

    protected Exchange prepareCopy(Exchange exchange, boolean handover) {
        return ExchangeHelper.createCorrelatedCopy((Exchange)exchange, (boolean)handover, (boolean)true);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.onStarted(this);
    }

    protected void doStop() throws Exception {
        this.endpoint.onStopped(this);
        super.doStop();
    }

    protected void addToQueue(Exchange exchange, boolean copy) throws SedaConsumerNotAvailableException {
        boolean empty;
        BlockingQueue<Exchange> queue = null;
        QueueReference queueReference = this.endpoint.getQueueReference();
        if (queueReference != null) {
            queue = queueReference.getQueue();
        }
        if (queue == null) {
            throw new SedaConsumerNotAvailableException("No queue available on endpoint: " + this.endpoint, exchange);
        }
        boolean bl = empty = !queueReference.hasConsumers();
        if (empty) {
            if (this.endpoint.isFailIfNoConsumers()) {
                throw new SedaConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
            }
            if (this.endpoint.isDiscardIfNoConsumers()) {
                LOG.debug("Discard message as no active consumers on endpoint: {}", (Object)this.endpoint);
                return;
            }
        }
        Exchange target = exchange;
        if (copy) {
            target = this.prepareCopy(exchange, true);
        }
        LOG.trace("Adding Exchange to queue: {}", (Object)target);
        if (this.discardWhenFull) {
            try {
                boolean added = queue.offer(target, 0L, TimeUnit.MILLISECONDS);
                if (!added) {
                    LOG.trace("Discarding Exchange as queue is full: {}", (Object)target);
                }
            }
            catch (InterruptedException e) {
                LOG.debug("Offer interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
        } else if (this.blockWhenFull && this.offerTimeout == 0L) {
            try {
                queue.put(target);
            }
            catch (InterruptedException e) {
                LOG.debug("Put interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
        } else if (this.blockWhenFull && this.offerTimeout > 0L) {
            try {
                boolean added = queue.offer(target, this.offerTimeout, TimeUnit.MILLISECONDS);
                if (!added) {
                    throw new IllegalStateException("Fails to insert element into queue, after timeout of " + this.offerTimeout + " milliseconds");
                }
            }
            catch (InterruptedException e) {
                LOG.debug("Offer interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
        } else {
            queue.add(target);
        }
    }
}

