/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.camel.component.http.CamelServlet;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.servlet.HttpRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpRegistry
implements HttpRegistry {
    private static final transient Logger LOG = LoggerFactory.getLogger(DefaultHttpRegistry.class);
    private static HttpRegistry singleton;
    private final Set<HttpConsumer> consumers = new HashSet<HttpConsumer>();
    private final Set<CamelServlet> providers = new HashSet<CamelServlet>();

    public static synchronized HttpRegistry getSingletonHttpRegistry() {
        if (singleton == null) {
            singleton = new DefaultHttpRegistry();
        }
        return singleton;
    }

    @Override
    public void register(HttpConsumer consumer) {
        LOG.debug("Registering consumer for path {} providers present: {}", (Object)consumer.getPath(), (Object)this.providers.size());
        this.consumers.add(consumer);
        for (CamelServlet provider : this.providers) {
            provider.connect(consumer);
        }
    }

    @Override
    public void unregister(HttpConsumer consumer) {
        LOG.debug("Unregistering consumer for path {} ", (Object)consumer.getPath());
        this.consumers.remove(consumer);
        for (CamelServlet provider : this.providers) {
            provider.disconnect(consumer);
        }
    }

    public void register(CamelServlet provider, Map properties) {
        LOG.debug("Registering provider through OSGi service listener {}", (Object)properties);
        if (provider instanceof CamelServlet) {
            CamelServlet camelServlet = provider;
            camelServlet.setServletName((String)properties.get("servlet-name"));
            this.register(camelServlet);
        }
    }

    public void unregister(Servlet provider, Map<String, Object> properties) {
        if (provider instanceof CamelServlet) {
            this.unregister((CamelServlet)provider);
        }
    }

    @Override
    public void register(CamelServlet provider) {
        LOG.debug("Registering CamelServlet with name {} consumers present: {}", (Object)provider.getServletName(), (Object)this.consumers.size());
        this.providers.add(provider);
        for (HttpConsumer consumer : this.consumers) {
            provider.connect(consumer);
        }
    }

    @Override
    public void unregister(CamelServlet provider) {
        this.providers.remove(provider);
    }

    public void setServlets(List<Servlet> servlets) {
        this.providers.clear();
        for (Servlet servlet : servlets) {
            if (!(servlet instanceof CamelServlet)) continue;
            this.providers.add((CamelServlet)servlet);
        }
    }
}

