/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.Collections;
import java.util.Map;
import org.apache.camel.spring.boot.actuate.endpoint.AbstractCamelMvcEndpoint;
import org.apache.camel.spring.boot.actuate.endpoint.CamelHealthCheckEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ConfigurationProperties(prefix="endpoints.camelhealthcheck")
public class CamelHealthCheckMvcEndpoint
extends AbstractCamelMvcEndpoint<CamelHealthCheckEndpoint> {
    public CamelHealthCheckMvcEndpoint(CamelHealthCheckEndpoint delegate) {
        super("/camel/health/check", delegate);
    }

    @ResponseBody
    @GetMapping(value={"/{id}"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object query(@PathVariable String id, @RequestParam(required=false) Map<String, Object> options) {
        return this.doIfEnabled((T delegate) -> delegate.query(id, (Map)ObjectHelper.supplyIfEmpty((Object)options, Collections::emptyMap)).orElseThrow(() -> new NoSuchCheckException("No such check " + id)));
    }

    @ResponseBody
    @GetMapping(value={"/{id}/invoke"}, produces={"application/vnd.spring-boot.actuator.v1+json", "application/json"})
    public Object invoke(@PathVariable String id, @RequestParam(required=false) Map<String, Object> options) {
        return this.doIfEnabled((T delegate) -> delegate.invoke(id, (Map)ObjectHelper.supplyIfEmpty((Object)options, Collections::emptyMap)).orElseThrow(() -> new NoSuchCheckException("No such check " + id)));
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="No such check")
    public static class NoSuchCheckException
    extends RuntimeException {
        public NoSuchCheckException(String message) {
            super(message);
        }
    }
}

