/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.spring.boot.actuate.endpoint.AbstractCamelEndpoint;
import org.apache.camel.spring.boot.model.RouteDetailsInfo;
import org.apache.camel.spring.boot.model.RouteInfo;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="endpoints.camelroutes")
public class CamelRoutesEndpoint
extends AbstractCamelEndpoint<List<RouteInfo>> {
    public static final String ENDPOINT_ID = "camelroutes";

    public CamelRoutesEndpoint(CamelContext camelContext) {
        super(ENDPOINT_ID, camelContext);
    }

    public List<RouteInfo> invoke() {
        return this.getRoutesInfo();
    }

    public RouteInfo getRouteInfo(String id) {
        Route route = this.getCamelContext().getRoute(id);
        if (route != null) {
            return new RouteInfo(route);
        }
        return null;
    }

    public List<RouteInfo> getRoutesInfo() {
        return this.getCamelContext().getRoutes().stream().map(RouteInfo::new).collect(Collectors.toList());
    }

    public RouteDetailsInfo getRouteDetailsInfo(String id) {
        Route route = this.getCamelContext().getRoute(id);
        if (route != null) {
            return new RouteDetailsInfo(this.getCamelContext(), route);
        }
        return null;
    }

    public void startRoute(String id) throws Exception {
        this.getCamelContext().getRouteController().startRoute(id);
    }

    public void resetRoute(String id) throws Exception {
        ManagedRouteMBean managedRouteMBean = this.getCamelContext().getManagedRoute(id, ManagedRouteMBean.class);
        if (managedRouteMBean != null) {
            managedRouteMBean.reset(true);
        }
    }

    public void stopRoute(String id, Optional<Long> timeout, Optional<TimeUnit> timeUnit, Optional<Boolean> abortAfterTimeout) throws Exception {
        if (timeout.isPresent()) {
            this.getCamelContext().getRouteController().stopRoute(id, timeout.get().longValue(), timeUnit.orElse(TimeUnit.SECONDS), abortAfterTimeout.orElse(Boolean.TRUE).booleanValue());
        } else {
            this.getCamelContext().getRouteController().stopRoute(id);
        }
    }

    public void suspendRoute(String id, Optional<Long> timeout, Optional<TimeUnit> timeUnit) throws Exception {
        if (timeout.isPresent()) {
            this.getCamelContext().getRouteController().suspendRoute(id, timeout.get().longValue(), timeUnit.orElse(TimeUnit.SECONDS));
        } else {
            this.getCamelContext().getRouteController().suspendRoute(id);
        }
    }

    public void resumeRoute(String id) throws Exception {
        this.getCamelContext().getRouteController().resumeRoute(id);
    }
}

