/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.RedeliveryErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;
import org.apache.camel.spring.spi.TransactedRuntimeCamelException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandler
extends RedeliveryErrorHandler {
    private static final transient Log LOG = LogFactory.getLog(TransactionErrorHandler.class);
    private final TransactionTemplate transactionTemplate;

    public TransactionErrorHandler(Processor output, Logger logger, Processor redeliveryProcessor, RedeliveryPolicy redeliveryPolicy, Predicate handledPolicy, ExceptionPolicyStrategy exceptionPolicyStrategy, TransactionTemplate transactionTemplate) {
        super(output, logger, redeliveryProcessor, redeliveryPolicy, handledPolicy, null, null, false);
        this.setExceptionPolicy(exceptionPolicyStrategy);
        this.transactionTemplate = transactionTemplate;
    }

    public boolean supportTransacted() {
        return true;
    }

    public String toString() {
        if (this.output == null) {
            return "";
        }
        return "TransactionErrorHandler:" + this.propagationBehaviorToString(this.transactionTemplate.getPropagationBehavior()) + "[" + this.getOutput() + "]";
    }

    public void process(final Exchange exchange) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Transaction error handler is processing: " + exchange));
        }
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TransactedRuntimeCamelException rce = null;
                boolean activeTx = TransactionSynchronizationManager.isActualTransactionActive();
                if (!activeTx) {
                    boolean bl = activeTx = status.isNewTransaction() && !status.isCompleted();
                    if (!activeTx && DefaultTransactionStatus.class.isAssignableFrom(status.getClass())) {
                        DefaultTransactionStatus defStatus = (DefaultTransactionStatus)DefaultTransactionStatus.class.cast(status);
                        boolean bl2 = activeTx = defStatus.hasTransaction() && !status.isCompleted();
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Is actual transaction active: " + activeTx));
                }
                if (activeTx) {
                    exchange.setProperty("CamelTransacted", (Object)Boolean.TRUE);
                }
                try {
                    TransactionErrorHandler.super.process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                if (exchange.getException() != null || exchange.isRollbackOnly()) {
                    if (exchange.getException() != null) {
                        rce = TransactionErrorHandler.this.wrapTransactedRuntimeException(exchange.getException());
                    }
                    if (activeTx && !status.isRollbackOnly()) {
                        status.setRollbackOnly();
                        if (LOG.isDebugEnabled()) {
                            if (rce != null) {
                                LOG.debug((Object)("Setting transaction to rollbackOnly due to exception being thrown: " + rce.getMessage()));
                            } else {
                                LOG.debug((Object)"Setting transaction to rollbackOnly as Exchange was marked as rollback only");
                            }
                        }
                    }
                    if (rce != null) {
                        throw rce;
                    }
                }
            }
        });
        this.log.trace((Object)"Transaction error handler done");
    }

    protected boolean shouldHandleException(Exchange exchange) {
        boolean answer = false;
        if (exchange.getException() != null) {
            answer = true;
            if (exchange.getException() instanceof TransactedRuntimeCamelException) {
                TransactedRuntimeCamelException trce = (TransactedRuntimeCamelException)((Object)exchange.getException(TransactedRuntimeCamelException.class));
                answer = !trce.isHandled();
            }
        }
        return answer;
    }

    protected TransactedRuntimeCamelException wrapTransactedRuntimeException(Exception exception) {
        if (exception instanceof TransactedRuntimeCamelException) {
            return (TransactedRuntimeCamelException)((Object)exception);
        }
        return new TransactedRuntimeCamelException(exception, true);
    }

    protected String propagationBehaviorToString(int propagationBehavior) {
        String rc;
        switch (propagationBehavior) {
            case 2: {
                rc = "PROPAGATION_MANDATORY";
                break;
            }
            case 6: {
                rc = "PROPAGATION_NESTED";
                break;
            }
            case 5: {
                rc = "PROPAGATION_NEVER";
                break;
            }
            case 4: {
                rc = "PROPAGATION_NOT_SUPPORTED";
                break;
            }
            case 0: {
                rc = "PROPAGATION_REQUIRED";
                break;
            }
            case 3: {
                rc = "PROPAGATION_REQUIRES_NEW";
                break;
            }
            case 1: {
                rc = "PROPAGATION_SUPPORTS";
                break;
            }
            default: {
                rc = "UNKNOWN";
            }
        }
        return rc;
    }
}

