/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.URISupport;

public class ScheduledPollConsumerHealthCheck
implements HealthCheck {
    private final ScheduledPollConsumer consumer;
    private final String id;
    private final String sanitizedUri;

    public ScheduledPollConsumerHealthCheck(ScheduledPollConsumer consumer, String id) {
        this.consumer = consumer;
        this.id = id;
        this.sanitizedUri = URISupport.sanitizeUri((String)consumer.getEndpoint().getEndpointBaseUri());
    }

    public HealthCheckConfiguration getConfiguration() {
        throw new UnsupportedOperationException("Configuration is not in use for this kind of health-check");
    }

    public HealthCheck.Result call(Map<String, Object> options) {
        boolean healthy;
        HealthCheckResultBuilder builder = HealthCheckResultBuilder.on((HealthCheck)this);
        builder.detail("failure.endpoint.uri", (Object)this.consumer.getEndpoint().getEndpointUri());
        long ec = this.consumer.getErrorCounter();
        long cnt = this.consumer.getCounter();
        Throwable cause = this.consumer.getLastError();
        boolean bl = healthy = cnt > 0L && ec == 0L;
        if (healthy) {
            builder.up();
        } else {
            builder.down();
            builder.detail("failure.error.count", (Object)ec);
            String rid = this.consumer.getRouteId();
            if (ec > 0L) {
                String msg = "Consumer failed polling %s times route: %s (%s)";
                builder.message(String.format(msg, ec, rid, this.sanitizedUri));
            } else {
                String msg = "Consumer has not yet polled route: %s (%s)";
                builder.message(String.format(msg, rid, this.sanitizedUri));
            }
            builder.error(cause);
        }
        return builder.build();
    }

    public String getGroup() {
        return "camel";
    }

    public String getId() {
        return this.id;
    }
}

