/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import java.time.Duration;
import org.apache.camel.support.task.budget.BudgetBuilder;
import org.apache.camel.support.task.budget.IterationTimeBoundedBudget;

public class IterationTimeBoundedBudgetBuilder
implements BudgetBuilder<IterationTimeBoundedBudget> {
    private static final long DEFAULT_MAX_DURATION = 5000L;
    private static final int DEFAULT_MAX_ITERATIONS = Integer.MAX_VALUE;
    private static final long DEFAULT_INITIAL_DELAY = 0L;
    private static final long DEFAULT_INTERVAL = 1000L;
    private long maxDuration = 5000L;
    private long initialDelay = 0L;
    private long interval = 1000L;
    private int maxIterations = Integer.MAX_VALUE;

    public IterationTimeBoundedBudgetBuilder withInitialDelay(Duration duration) {
        this.initialDelay = duration.toMillis();
        return this;
    }

    public IterationTimeBoundedBudgetBuilder withInterval(Duration duration) {
        this.interval = duration.toMillis();
        return this;
    }

    public IterationTimeBoundedBudgetBuilder withMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
        return this;
    }

    public IterationTimeBoundedBudgetBuilder withMaxDuration(Duration duration) {
        this.maxDuration = duration.toMillis();
        return this;
    }

    @Override
    public IterationTimeBoundedBudget build() {
        return new IterationTimeBoundedBudget(this.initialDelay, this.interval, this.maxIterations, this.maxDuration);
    }
}

