/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.support.ExpressionSupport;

public abstract class ExpressionAdapter
extends ExpressionSupport {
    private TypeConverter converter;

    @Override
    public void init(CamelContext context) {
        super.init(context);
        this.converter = context.getTypeConverter();
    }

    @Override
    protected String assertionFailureMessage(Exchange exchange) {
        return this.toString();
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        Object value = this.evaluate(exchange);
        if (Object.class == type) {
            return (T)value;
        }
        if (this.converter != null) {
            return (T)this.converter.convertTo(type, exchange, value);
        }
        return (T)exchange.getContext().getTypeConverter().convertTo(type, exchange, value);
    }
}

