/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyConfigurerHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.StringQuoteHelper;

public final class PropertyBindingSupport {
    private PropertyBindingSupport() {
    }

    public static Builder build() {
        return new Builder();
    }

    public static boolean autowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target) {
        return PropertyBindingSupport.autowireSingletonPropertiesFromRegistry(camelContext, target, false, false, null);
    }

    public static boolean autowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target, boolean bindNullOnly, boolean deepNesting, OnAutowiring callback) {
        try {
            if (target != null) {
                HashSet<Object> parents = new HashSet<Object>();
                return PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, target, parents, bindNullOnly, deepNesting, callback);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, (Throwable)e);
        }
        return false;
    }

    private static boolean doAutowireSingletonPropertiesFromRegistry(CamelContext camelContext, Object target, Set<Object> parents, boolean bindNullOnly, boolean deepNesting, OnAutowiring callback) throws Exception {
        LinkedHashMap properties = new LinkedHashMap();
        PropertyConfigurer configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(camelContext, target);
        Map getterAllOption = null;
        if (configurer instanceof PropertyConfigurerGetter) {
            PropertyConfigurerGetter getter = (PropertyConfigurerGetter)configurer;
            Object lambdaTarget = target;
            getterAllOption = getter.getAllOptions(target);
            getterAllOption.forEach((key, type) -> {
                if (PropertyBindingSupport.isComplexUserType((Class)type)) {
                    Object value = getter.getOptionValue(lambdaTarget, key, true);
                    properties.put(key, value);
                }
            });
        } else {
            ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getProperties(target, properties, null);
        }
        boolean hit = false;
        for (Map.Entry entry : properties.entrySet()) {
            Set lookup;
            Class type2;
            boolean skip;
            String key2 = (String)entry.getKey();
            Object value = entry.getValue();
            if ("basicPropertyBinding".equals(key2) || "bridgeErrorHandler".equals(key2) || "lazyStartProducer".equals(key2) || (skip = parents.contains(value) || value instanceof CamelContext) || (type2 = getterAllOption != null ? (Class)getterAllOption.get(key2) : PropertyBindingSupport.getGetterType(camelContext, target, key2, false)) != null && CamelContext.class.isAssignableFrom(type2) || !PropertyBindingSupport.isComplexUserType(type2)) continue;
            if (!(bindNullOnly && value != null || (lookup = camelContext.getRegistry().findByType(type2)).size() != 1 || (value = lookup.iterator().next()) == null)) {
                if (configurer != null) {
                    hit = configurer.configure(camelContext, target, PropertyBindingSupport.undashKey(key2), value, true);
                }
                if (!hit) {
                    hit = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(camelContext, target, key2, value);
                }
                if (hit && callback != null) {
                    callback.onAutowire(target, key2, type2, value);
                }
            }
            if (value == null && deepNesting) {
                Object instance;
                Class<?> parameterType;
                Method method = PropertyBindingSupport.findBestSetterMethod(camelContext, target.getClass(), key2, true, true, false);
                if (method == null || (parameterType = method.getParameterTypes()[0]) == null || !org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType) || (instance = camelContext.getInjector().newInstance(parameterType)) == null) continue;
                ObjectHelper.invokeMethod(method, target, instance);
                target = instance;
                parents.add(target);
                value = instance;
                hit |= PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, value, parents, bindNullOnly, deepNesting, callback);
                continue;
            }
            if (value == null || !deepNesting) continue;
            parents.add(target);
            hit |= PropertyBindingSupport.doAutowireSingletonPropertiesFromRegistry(camelContext, value, parents, bindNullOnly, deepNesting, callback);
        }
        return hit;
    }

    public static boolean bindProperties(CamelContext camelContext, Object target, Map<String, Object> properties) {
        org.apache.camel.util.ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        return PropertyBindingSupport.build().bind(camelContext, target, properties);
    }

    public static boolean bindWithFlattenProperties(CamelContext camelContext, Object target, Map<String, Object> properties) {
        org.apache.camel.util.ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        org.apache.camel.util.ObjectHelper.notNull((Object)target, (String)"target");
        org.apache.camel.util.ObjectHelper.notNull(properties, (String)"properties");
        return PropertyBindingSupport.build().withFlattenProperties(true).bind(camelContext, target, properties);
    }

    private static boolean doBindProperties(CamelContext camelContext, Object target, Map<String, Object> properties, String optionPrefix, boolean ignoreCase, boolean removeParameter, boolean flattenProperties, boolean mandatory, boolean nesting, boolean deepNesting, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean placeholder, boolean reflection, PropertyConfigurer configurer) {
        AbstractMap sorted;
        if (properties == null || properties.isEmpty()) {
            return false;
        }
        if (flattenProperties) {
            properties = new FlattenMap(properties);
        }
        boolean answer = false;
        if (optionPrefix != null) {
            properties = new OptionPrefixMap(properties, optionPrefix);
        }
        if (properties.size() > 1) {
            sorted = new TreeMap(new PropertyBindingKeyComparator(properties));
            sorted.putAll(properties);
        } else {
            sorted = properties;
        }
        for (Map.Entry entry : sorted.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!nesting && key.indexOf(46) != -1) continue;
            boolean hit = PropertyBindingSupport.doBuildPropertyOgnlPath(camelContext, target, key, value, deepNesting, fluentBuilder, allowPrivateSetter, ignoreCase, reference, placeholder, mandatory, reflection, configurer);
            if (hit && removeParameter) {
                properties.remove(key);
            }
            answer |= hit;
        }
        return answer;
    }

    private static boolean doBuildPropertyOgnlPath(CamelContext camelContext, Object originalTarget, String name, Object value, boolean deepNesting, boolean fluentBuilder, boolean allowPrivateSetter, boolean ignoreCase, boolean reference, boolean placeholder, boolean mandatory, boolean reflection, PropertyConfigurer configurer) {
        boolean optional = name.startsWith("?");
        if (optional) {
            name = name.substring(1);
        }
        Object newTarget = originalTarget;
        Class<?> newClass = originalTarget.getClass();
        String newName = name;
        if (configurer == null) {
            configurer = PropertyConfigurerHelper.resolvePropertyConfigurer(camelContext, newClass);
        }
        String[] parts = name.contains(".") ? name.split("\\.") : new String[]{name};
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            Object prop = null;
            if (configurer != null) {
                prop = PropertyBindingSupport.getOrCreatePropertyOgnlPathViaConfigurer(camelContext, newTarget, part, ignoreCase, configurer);
            }
            if (prop == null && reflection) {
                prop = PropertyBindingSupport.getOrCreatePropertyOgnlPathViaReflection(camelContext, newTarget, part, ignoreCase);
            }
            if (prop == null) {
                if (!deepNesting) {
                    return false;
                }
                if (configurer != null) {
                    prop = PropertyBindingSupport.attemptCreateNewInstanceViaConfigurer(camelContext, newTarget, part, ignoreCase, configurer);
                }
                if (prop == null && reflection) {
                    prop = PropertyBindingSupport.attemptCreateNewInstanceViaReflection(camelContext, newTarget, newClass, part, fluentBuilder, allowPrivateSetter, ignoreCase);
                }
            }
            if (prop == null) {
                if (optional) {
                    return false;
                }
                if (!mandatory) continue;
                throw new IllegalArgumentException("Cannot find getter method: " + part + " on bean: " + newClass + " when binding property: " + name);
            }
            if (configurer instanceof PropertyConfigurerGetter) {
                Class collectionType;
                String key = part;
                int pos = part.indexOf(91);
                if (pos != -1) {
                    key = part.substring(0, pos);
                }
                configurer = (collectionType = (Class)((PropertyConfigurerGetter)configurer).getCollectionValueType(newTarget, PropertyBindingSupport.undashKey(key), ignoreCase)) != null ? PropertyConfigurerHelper.resolvePropertyConfigurer(camelContext, collectionType) : PropertyConfigurerHelper.resolvePropertyConfigurer(camelContext, prop.getClass());
            }
            newTarget = prop;
            newClass = newTarget.getClass();
            newName = parts[i + 1];
        }
        return PropertyBindingSupport.doSetPropertyValue(camelContext, newTarget, newName, value, ignoreCase, mandatory, fluentBuilder, allowPrivateSetter, reference, placeholder, optional, reflection, configurer);
    }

    private static Object attemptCreateNewInstanceViaReflection(CamelContext camelContext, Object newTarget, Class newClass, String name, boolean fluentBuilder, boolean allowPrivateSetter, boolean ignoreCase) {
        String key = name;
        int pos = name.indexOf(91);
        if (pos != -1) {
            key = name.substring(0, pos);
        }
        Object answer = null;
        Method method = PropertyBindingSupport.findBestSetterMethod(camelContext, newClass, key, fluentBuilder, allowPrivateSetter, ignoreCase);
        if (method != null) {
            Class<?> parameterType = method.getParameterTypes()[0];
            Object obj = null;
            if (Map.class.isAssignableFrom(parameterType)) {
                obj = new LinkedHashMap();
            } else if (Collection.class.isAssignableFrom(parameterType)) {
                obj = new ArrayList();
            } else if (parameterType.isArray()) {
                obj = Array.newInstance(parameterType.getComponentType(), 0);
            }
            if (obj == null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                obj = camelContext.getInjector().newInstance(parameterType);
            }
            if (obj != null) {
                ObjectHelper.invokeMethod(method, newTarget, obj);
                answer = obj;
            }
        }
        return answer;
    }

    private static Object attemptCreateNewInstanceViaConfigurer(CamelContext camelContext, Object newTarget, String name, boolean ignoreCase, PropertyConfigurer configurer) {
        String key = name;
        int pos = name.indexOf(91);
        if (pos != -1) {
            key = name.substring(0, pos);
        }
        Object answer = null;
        Class parameterType = null;
        if (configurer instanceof PropertyConfigurerGetter) {
            parameterType = (Class)((PropertyConfigurerGetter)configurer).getAllOptions(newTarget).get(key);
        }
        if (parameterType != null) {
            boolean hit;
            Object obj = null;
            if (Map.class.isAssignableFrom(parameterType)) {
                obj = new LinkedHashMap();
            } else if (Collection.class.isAssignableFrom(parameterType)) {
                obj = new ArrayList();
            } else if (parameterType.isArray()) {
                obj = Array.newInstance(parameterType.getComponentType(), 0);
            }
            if (obj == null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor((Class)parameterType)) {
                obj = camelContext.getInjector().newInstance(parameterType);
            }
            if (obj != null && (hit = configurer.configure(camelContext, newTarget, PropertyBindingSupport.undashKey(key), obj, ignoreCase))) {
                answer = obj;
            }
        }
        return answer;
    }

    private static boolean doSetPropertyValue(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase, boolean mandatory, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean placeholder, boolean optional, boolean reflection, PropertyConfigurer configurer) {
        String key = name;
        Object text = value;
        if (placeholder) {
            key = camelContext.resolvePropertyPlaceholders(key);
            if (text instanceof String) {
                text = camelContext.resolvePropertyPlaceholders(text.toString());
            }
        }
        try {
            Object str = PropertyBindingSupport.resolveValue(camelContext, target, key, text, ignoreCase, fluentBuilder, allowPrivateSetter, reflection, configurer);
            if (str instanceof String) {
                str = camelContext.resolvePropertyPlaceholders(str.toString());
            }
            value = str;
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, key, text, (Throwable)e);
        }
        boolean bound = false;
        try {
            if (PropertyBindingSupport.isCollectionKey(name)) {
                if (configurer != null) {
                    bound = PropertyBindingSupport.setPropertyCollectionViaConfigurer(camelContext, target, key, value, ignoreCase, configurer);
                }
                if (!bound && reflection) {
                    bound = PropertyBindingSupport.setPropertyCollectionViaReflection(camelContext, target, key, value, ignoreCase, reference);
                }
            } else {
                if (configurer != null) {
                    bound = PropertyBindingSupport.setSimplePropertyViaConfigurer(camelContext, target, key, value, ignoreCase, configurer);
                }
                if (!bound && reflection) {
                    bound = PropertyBindingSupport.setSimplePropertyViaReflection(camelContext, target, key, value, fluentBuilder, allowPrivateSetter, reflection, ignoreCase);
                }
            }
        }
        catch (PropertyBindingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, key, value, (Throwable)e);
        }
        if (mandatory && !optional && !bound) {
            throw new PropertyBindingException(target, key, value);
        }
        return bound;
    }

    private static boolean isCollectionKey(String name) {
        return name.contains("[") && name.endsWith("]");
    }

    private static boolean setPropertyCollectionViaReflection(CamelContext context, Object target, String name, Object value, boolean ignoreCase, boolean reference) throws Exception {
        BeanIntrospection bi = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        int pos = name.indexOf(91);
        String lookupKey = name.substring(pos + 1, name.length() - 1);
        String key = name.substring(0, pos);
        Object obj = bi.getOrElseProperty(target, key, null, ignoreCase);
        if (obj == null) {
            Method getter = bi.getPropertyGetter(target.getClass(), key, ignoreCase);
            if (getter != null) {
                Class<?> returnType = getter.getReturnType();
                if (Map.class.isAssignableFrom(returnType)) {
                    obj = new LinkedHashMap();
                } else if (Collection.class.isAssignableFrom(returnType)) {
                    obj = new ArrayList();
                } else if (returnType.isArray()) {
                    obj = Array.newInstance(returnType.getComponentType(), 0);
                }
            } else {
                obj = new LinkedHashMap();
            }
            boolean hit = bi.setProperty(context, target, key, obj);
            if (!hit) {
                throw new IllegalArgumentException("Cannot set property: " + name + " as a Map because target bean has no setter method for the Map");
            }
        }
        if (value instanceof String) {
            Object bean;
            String str = value.toString();
            if (reference && PropertyBindingSupport.isReferenceParameter(str) && (bean = CamelContextHelper.lookup(context, str.substring(1))) != null) {
                value = bean;
            }
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(lookupKey, value);
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                if (idx < list.size()) {
                    list.set(idx, value);
                } else if (idx == list.size()) {
                    list.add(value);
                } else {
                    if (list instanceof ArrayList) {
                        ((ArrayList)list).ensureCapacity(idx + 1);
                    }
                    while (list.size() < idx) {
                        list.add(null);
                    }
                    list.add(idx, value);
                }
            } else {
                list.add(value);
            }
            return true;
        }
        if (obj.getClass().isArray() && lookupKey != null) {
            boolean hit;
            int size;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = Array.getLength(obj)) && !(hit = bi.setProperty(context, target, key, obj = Arrays.copyOf((Object[])obj, idx + 1)))) {
                throw new IllegalArgumentException("Cannot set property: " + name + " as an array because target bean has no setter method for the array");
            }
            Array.set(obj, idx, value);
            return true;
        }
        throw new IllegalArgumentException("Cannot set property: " + name + " as either a Map/List/array because target bean is not a Map, List or array type: " + target);
    }

    private static boolean setPropertyCollectionViaConfigurer(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase, PropertyConfigurer configurer) throws Exception {
        Object[] originalTarget = target;
        int pos = name.indexOf(91);
        String lookupKey = name.substring(pos + 1, name.length() - 1);
        String key = name.substring(0, pos);
        String undashKey = PropertyBindingSupport.undashKey(key);
        Object[] obj = null;
        if (configurer instanceof PropertyConfigurerGetter) {
            obj = ((PropertyConfigurerGetter)configurer).getOptionValue((Object)target, undashKey, ignoreCase);
        }
        if (obj == null) {
            Class returnType = null;
            if (configurer instanceof PropertyConfigurerGetter) {
                returnType = (Class)((PropertyConfigurerGetter)configurer).getAllOptions((Object)target).get(undashKey);
            }
            if (returnType == null) {
                return false;
            }
            if (Map.class.isAssignableFrom(returnType)) {
                obj = new LinkedHashMap();
            } else if (Collection.class.isAssignableFrom(returnType)) {
                obj = new ArrayList();
            } else if (returnType.isArray()) {
                obj = Array.newInstance(returnType.getComponentType(), 0);
            }
            if (obj != null) {
                boolean hit = configurer.configure(camelContext, (Object)target, undashKey, obj, ignoreCase);
                if (!hit) {
                    throw new IllegalArgumentException("Cannot set property: " + name + " as either a Map/List/array because target bean is not a Map, List or array type: " + target);
                }
                target = obj;
            }
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            map.put(lookupKey, value);
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                if (idx < list.size()) {
                    list.set(idx, value);
                } else if (idx == list.size()) {
                    list.add(value);
                } else {
                    if (list instanceof ArrayList) {
                        ((ArrayList)list).ensureCapacity(idx + 1);
                    }
                    while (list.size() < idx) {
                        list.add(null);
                    }
                    list.add(idx, value);
                }
            } else {
                list.add(value);
            }
            return true;
        }
        if (obj.getClass().isArray()) {
            boolean hit;
            int size;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = Array.getLength(obj)) && !(hit = configurer.configure(camelContext, (Object)originalTarget, undashKey, (Object)(obj = Arrays.copyOf((Object[])obj, idx + 1)), ignoreCase))) {
                throw new IllegalArgumentException("Cannot set property: " + name + " as an array because target bean has no setter method for the array");
            }
            Array.set(obj, idx, value);
            return true;
        }
        throw new IllegalArgumentException("Cannot set property: " + name + " as either a Map/List/array because target bean is not a Map, List or array type: " + target);
    }

    private static boolean setSimplePropertyViaConfigurer(CamelContext camelContext, Object target, String key, Object value, boolean ignoreCase, PropertyConfigurer configurer) {
        try {
            return configurer.configure(camelContext, target, PropertyBindingSupport.undashKey(key), value, ignoreCase);
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, key, value, (Throwable)e);
        }
    }

    private static boolean setSimplePropertyViaReflection(CamelContext camelContext, Object target, String name, Object value, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference, boolean ignoreCase) {
        try {
            if (target != null && name != null) {
                return PropertyBindingSupport.doSetSimplePropertyViaReflection(camelContext, target, name, value, false, ignoreCase, fluentBuilder, allowPrivateSetter, reference);
            }
        }
        catch (Exception e) {
            throw new PropertyBindingException(target, name, value, (Throwable)e);
        }
        return false;
    }

    private static Object resolveAutowired(CamelContext context, Object target, String name, Object value, boolean ignoreCase, boolean fluentBuilder, boolean allowPrivateSetter, boolean reflection, PropertyConfigurer configurer) throws Exception {
        String str;
        String undashKey = PropertyBindingSupport.undashKey(name);
        if (value instanceof String && (str = value.toString()).equals("#autowired")) {
            Class<?> parameterType = null;
            if (configurer instanceof PropertyConfigurerGetter) {
                parameterType = (Class<?>)((PropertyConfigurerGetter)configurer).getAllOptions(target).get(undashKey);
            }
            if (parameterType == null && reflection) {
                Method method = PropertyBindingSupport.findBestSetterMethod(context, target.getClass(), undashKey, fluentBuilder, allowPrivateSetter, ignoreCase);
                if (method != null) {
                    parameterType = method.getParameterTypes()[0];
                } else {
                    throw new IllegalStateException("Cannot find setter method with name: " + undashKey + " on class: " + target.getClass().getName() + " to use for autowiring");
                }
            }
            if (parameterType != null) {
                Set types = context.getRegistry().findByType((Class)parameterType);
                if (types.size() == 1) {
                    value = types.iterator().next();
                } else {
                    if (types.size() > 1) {
                        throw new IllegalStateException("Cannot select single type: " + parameterType + " as there are " + types.size() + " beans in the registry with this type");
                    }
                    throw new IllegalStateException("Cannot select single type: " + parameterType + " as there are no beans in the registry with this type");
                }
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object resolveValue(CamelContext context, Object target, String name, Object value, boolean ignoreCase, boolean fluentBuilder, boolean allowPrivateSetter, boolean reflection, PropertyConfigurer configurer) throws Exception {
        if (!(value instanceof String)) return value;
        String str = value.toString();
        if (str.startsWith("#property:")) {
            String key = str.substring(10);
            key = context.resolvePropertyPlaceholders(key);
            Optional resolved = context.getPropertiesComponent().resolveProperty(key);
            if (!resolved.isPresent()) throw new IllegalArgumentException("Property with key " + key + " not found by properties component");
            return resolved.get();
        }
        if (!str.equals("#autowired")) return PropertyBindingSupport.resolveBean(context, name, value);
        return PropertyBindingSupport.resolveAutowired(context, target, name, value, ignoreCase, fluentBuilder, allowPrivateSetter, reflection, configurer);
    }

    private static boolean doSetSimplePropertyViaReflection(CamelContext context, Object target, String name, Object value, boolean mandatory, boolean ignoreCase, boolean fluentBuilder, boolean allowPrivateSetter, boolean reference) throws Exception {
        boolean hit;
        String refName = null;
        if (reference && value instanceof String) {
            Object bean;
            String str = value.toString();
            if (str.startsWith("#bean:")) {
                refName = "#" + ((String)value).substring(6);
                value = null;
            } else if (str.equals("#autowired")) {
                value = PropertyBindingSupport.resolveAutowired(context, target, name, value, ignoreCase, fluentBuilder, allowPrivateSetter, true, null);
            } else if (PropertyBindingSupport.isReferenceParameter(str) && (bean = CamelContextHelper.lookup(context, str.substring(1))) != null) {
                value = bean;
            }
        }
        if (!(hit = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(context, context.getTypeConverter(), target, name, value, refName, fluentBuilder, allowPrivateSetter, ignoreCase)) && mandatory) {
            throw new IllegalArgumentException("Cannot find setter method: " + name + " on bean: " + target + " of type: " + target.getClass().getName() + " when binding property: " + name);
        }
        return hit;
    }

    private static Object getOrCreatePropertyOgnlPathViaConfigurer(CamelContext context, Object target, String property, boolean ignoreCase, PropertyConfigurer configurer) {
        String key = property;
        String lookupKey = null;
        if (property.contains("[") && property.endsWith("]")) {
            int pos = property.indexOf(91);
            lookupKey = property.substring(pos + 1, property.length() - 1);
            key = property.substring(0, pos);
        }
        String undashKey = PropertyBindingSupport.undashKey(key);
        Object answer = null;
        Class type = null;
        if (configurer instanceof PropertyConfigurerGetter) {
            answer = ((PropertyConfigurerGetter)configurer).getOptionValue(target, undashKey, ignoreCase);
        }
        if (answer != null) {
            type = answer.getClass();
        } else if (configurer instanceof PropertyConfigurerGetter) {
            type = (Class)((PropertyConfigurerGetter)configurer).getAllOptions(target).get(undashKey);
        }
        if (answer == null && type == null) {
            return null;
        }
        if (answer == null && lookupKey != null) {
            if (Map.class.isAssignableFrom(type)) {
                answer = new LinkedHashMap();
            } else if (Collection.class.isAssignableFrom(type)) {
                answer = new ArrayList();
            } else if (type.isArray()) {
                answer = Array.newInstance(type.getComponentType(), 0);
            } else {
                throw new IllegalArgumentException("Cannot set property: " + property + " as either a Map/List/array because target bean is not a Map, List or array type: " + target);
            }
            boolean hit = configurer.configure(context, target, undashKey, answer, ignoreCase);
            if (!hit) {
                throw new IllegalArgumentException("Cannot set property: " + key + " as an map/list/array because target bean has no suitable setter method");
            }
        }
        if (answer instanceof Map && lookupKey != null) {
            Map map = (Map)answer;
            if ((answer = map.get(lookupKey)) == null) {
                Class parameterType = null;
                if (configurer instanceof PropertyConfigurerGetter) {
                    parameterType = (Class)((PropertyConfigurerGetter)configurer).getCollectionValueType(target, undashKey, ignoreCase);
                }
                if (parameterType != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                    Object instance = context.getInjector().newInstance(parameterType);
                    map.put(lookupKey, instance);
                    answer = instance;
                }
            }
        } else if (answer instanceof List) {
            List list = (List)answer;
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                answer = list.size() > idx ? list.get(idx) : null;
            } else {
                answer = list.isEmpty() ? null : list.get(list.size() - 1);
            }
            if (answer == null) {
                Class parameterType = null;
                if (configurer instanceof PropertyConfigurerGetter) {
                    parameterType = (Class)((PropertyConfigurerGetter)configurer).getCollectionValueType(target, undashKey, ignoreCase);
                }
                if (parameterType != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                    Object instance = context.getInjector().newInstance(parameterType);
                    list.add(instance);
                    answer = instance;
                }
            }
        } else if (type != null && type.isArray() && lookupKey != null) {
            boolean hit;
            int size;
            Object[] arr = (Object[])answer;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = arr.length) && !(hit = configurer.configure(context, target, undashKey, (Object)(arr = Arrays.copyOf(arr, idx + 1)), true))) {
                throw new IllegalArgumentException("Cannot set property: " + key + " as an array because target bean has no setter method for the array");
            }
            Object instance = arr[idx];
            if (instance == null) {
                instance = context.getInjector().newInstance(type.getComponentType());
                Array.set(arr, idx, instance);
            }
            answer = instance;
        }
        return answer;
    }

    private static Object getOrCreatePropertyOgnlPathViaReflection(CamelContext context, Object target, String property, boolean ignoreCase) {
        String key = property;
        String lookupKey = null;
        if (property.contains("[") && property.endsWith("]")) {
            int pos = property.indexOf(91);
            lookupKey = property.substring(pos + 1, property.length() - 1);
            key = property.substring(0, pos);
        }
        Class<?> type = null;
        BeanIntrospection introspection = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection();
        LinkedHashMap answer = introspection.getOrElseProperty(target, key, null, ignoreCase);
        if (answer != null) {
            type = answer.getClass();
        } else {
            try {
                Method method = introspection.getPropertyGetter(target.getClass(), key, ignoreCase);
                if (method != null) {
                    type = method.getReturnType();
                }
            }
            catch (NoSuchMethodException method) {
                // empty catch block
            }
        }
        if (answer == null && type == null) {
            return null;
        }
        if (answer == null && lookupKey != null) {
            if (Map.class.isAssignableFrom(type)) {
                answer = new LinkedHashMap();
            } else if (Collection.class.isAssignableFrom(type)) {
                answer = new ArrayList();
            } else if (type.isArray()) {
                answer = Array.newInstance(type.getComponentType(), 0);
            } else {
                throw new IllegalArgumentException("Cannot set property: " + property + " as either a Map/List/array because target bean is not a Map, List or array type: " + target);
            }
            boolean hit = false;
            try {
                hit = introspection.setProperty(context, target, key, (Object)answer);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!hit) {
                throw new IllegalArgumentException("Cannot set property: " + key + " as an map/list/array because target bean has no suitable setter method");
            }
        }
        if (answer instanceof Map && lookupKey != null) {
            Map map = answer;
            if ((answer = map.get(lookupKey)) == null) {
                Class parameterType = null;
                try {
                    String typeName;
                    String fqn;
                    Method method = introspection.getPropertyGetter(target.getClass(), key, ignoreCase);
                    if (method != null && (fqn = StringHelper.between((String)(typeName = method.getGenericReturnType().getTypeName()), (String)",", (String)">")) != null) {
                        fqn = fqn.trim();
                        parameterType = context.getClassResolver().resolveClass(fqn);
                    }
                }
                catch (Exception method) {
                    // empty catch block
                }
                if (parameterType != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                    Object instance = context.getInjector().newInstance(parameterType);
                    map.put(lookupKey, instance);
                    answer = instance;
                }
            }
        } else if (answer instanceof List) {
            List list = (List)((Object)answer);
            if (org.apache.camel.util.ObjectHelper.isNotEmpty((Object)lookupKey)) {
                int idx = Integer.parseInt(lookupKey);
                answer = list.size() > idx ? list.get(idx) : null;
            } else {
                answer = list.isEmpty() ? null : list.get(list.size() - 1);
            }
            if (answer == null) {
                Class parameterType = null;
                try {
                    String typeName;
                    String fqn;
                    Method method = introspection.getPropertyGetter(target.getClass(), key, ignoreCase);
                    if (method != null && (fqn = StringHelper.between((String)(typeName = method.getGenericReturnType().getTypeName()), (String)"<", (String)">")) != null) {
                        parameterType = context.getClassResolver().resolveClass(fqn);
                    }
                }
                catch (Exception method) {
                    // empty catch block
                }
                if (parameterType != null && org.apache.camel.util.ObjectHelper.hasDefaultPublicNoArgConstructor(parameterType)) {
                    Object instance = context.getInjector().newInstance(parameterType);
                    list.add(instance);
                    answer = instance;
                }
            }
        } else if (type != null && type.isArray() && lookupKey != null) {
            Object instance;
            int size;
            Object[] arr = (Object[])answer;
            int idx = Integer.parseInt(lookupKey);
            if (idx >= (size = arr.length)) {
                arr = Arrays.copyOf(arr, idx + 1);
                boolean hit = false;
                try {
                    hit = introspection.setProperty(context, target, key, (Object)arr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!hit) {
                    throw new IllegalArgumentException("Cannot set property: " + key + " as an array because target bean has no setter method for the array");
                }
            }
            if ((instance = arr[idx]) == null) {
                instance = context.getInjector().newInstance(type.getComponentType());
                Array.set(arr, idx, instance);
            }
            answer = instance;
        }
        return answer;
    }

    private static Method findBestSetterMethod(CamelContext context, Class clazz, String name, boolean fluentBuilder, boolean allowPrivateSetter, boolean ignoreCase) {
        Set candidates = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().findSetterMethods(clazz, name, false, allowPrivateSetter, ignoreCase);
        if (candidates.size() == 1) {
            return (Method)candidates.iterator().next();
        }
        if (fluentBuilder && (candidates = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().findSetterMethods(clazz, name, fluentBuilder, allowPrivateSetter, ignoreCase)).size() == 1) {
            return (Method)candidates.iterator().next();
        }
        return null;
    }

    private static Class getGetterType(CamelContext context, Object target, String name, boolean ignoreCase) {
        try {
            if (ignoreCase) {
                Method getter = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getPropertyGetter(target.getClass(), name, true);
                if (getter != null) {
                    return getter.getReturnType();
                }
            } else {
                Method getter = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getBeanIntrospection().getPropertyGetter(target.getClass(), name, false);
                if (getter != null) {
                    return getter.getReturnType();
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    private static boolean isComplexUserType(Class type) {
        return type != null && !type.isPrimitive() && !type.getName().startsWith("java.");
    }

    private static boolean isReferenceParameter(Object obj) {
        if (obj == null) {
            return false;
        }
        String parameter = obj.toString();
        if (!(parameter = parameter.trim()).startsWith("#")) {
            return false;
        }
        return !parameter.equals("#autowired") && !parameter.startsWith("#bean:") && !parameter.startsWith("#class:") && !parameter.startsWith("#type:") && !parameter.startsWith("#property:");
    }

    private static Object newInstanceConstructorParameters(CamelContext camelContext, Class<?> type, String parameters) throws Exception {
        String[] params = StringQuoteHelper.splitSafeQuote((String)parameters, (char)',');
        Constructor found = PropertyBindingSupport.findMatchingConstructor(type.getConstructors(), params);
        if (found != null) {
            Object[] arr = new Object[found.getParameterCount()];
            for (int i = 0; i < found.getParameterCount(); ++i) {
                Class<?> paramType = found.getParameterTypes()[i];
                String param = params[i];
                Object val = camelContext.getTypeConverter().convertTo(paramType, (Object)param);
                if (val instanceof String) {
                    val = StringHelper.removeLeadingAndEndingQuotes((String)((String)val));
                }
                arr[i] = val;
            }
            return found.newInstance(arr);
        }
        return null;
    }

    private static Constructor findMatchingConstructor(Constructor<?>[] constructors, String[] params) {
        ArrayList candidates = new ArrayList();
        Constructor<?> fallbackCandidate = null;
        for (Constructor<?> ctr : constructors) {
            if (ctr.getParameterCount() != params.length) continue;
            boolean matches = true;
            for (int i = 0; i < ctr.getParameterCount(); ++i) {
                String parameter = params[i];
                if (parameter != null) {
                    parameter = parameter.trim();
                }
                Class<?> parameterType = PropertyBindingSupport.getValidParameterType(parameter);
                Class<?> expectedType = ctr.getParameterTypes()[i];
                if (parameterType == null || expectedType == null) continue;
                if (Object.class.equals(expectedType)) {
                    fallbackCandidate = ctr;
                    matches = false;
                    break;
                }
                boolean matchingTypes = PropertyBindingSupport.isParameterMatchingType(parameterType, expectedType);
                if (matchingTypes) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            candidates.add(ctr);
        }
        return candidates.size() == 1 ? (Constructor<?>)candidates.get(0) : fallbackCandidate;
    }

    private static Object newInstanceFactoryParameters(CamelContext camelContext, Class<?> type, String factoryMethod, String parameters) throws Exception {
        String[] params = StringQuoteHelper.splitSafeQuote((String)parameters, (char)',');
        Method found = PropertyBindingSupport.findMatchingFactoryMethod(type.getMethods(), factoryMethod, params);
        if (found != null) {
            Object[] arr = new Object[found.getParameterCount()];
            for (int i = 0; i < found.getParameterCount(); ++i) {
                Class<?> paramType = found.getParameterTypes()[i];
                String param = params[i];
                Object val = camelContext.getTypeConverter().convertTo(paramType, (Object)param);
                if (val instanceof String) {
                    val = StringHelper.removeLeadingAndEndingQuotes((String)((String)val));
                }
                arr[i] = val;
            }
            return found.invoke(null, arr);
        }
        return null;
    }

    private static Method findMatchingFactoryMethod(Method[] methods, String factoryMethod, String[] params) {
        ArrayList<Method> candidates = new ArrayList<Method>();
        Method fallbackCandidate = null;
        for (Method method : methods) {
            if (!factoryMethod.equals(method.getName()) || !Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() == Void.TYPE || method.getParameterCount() != params.length) continue;
            boolean matches = true;
            for (int i = 0; i < method.getParameterCount(); ++i) {
                String parameter = params[i];
                if (parameter != null) {
                    parameter = parameter.trim();
                }
                Class<?> parameterType = PropertyBindingSupport.getValidParameterType(parameter);
                Class<?> expectedType = method.getParameterTypes()[i];
                if (parameterType == null || expectedType == null) continue;
                if (Object.class.equals(expectedType)) {
                    fallbackCandidate = method;
                    matches = false;
                    break;
                }
                boolean matchingTypes = PropertyBindingSupport.isParameterMatchingType(parameterType, expectedType);
                if (matchingTypes) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            candidates.add(method);
        }
        return candidates.size() == 1 ? (Method)candidates.get(0) : fallbackCandidate;
    }

    private static Class<?> getValidParameterType(String value) {
        if (org.apache.camel.util.ObjectHelper.isEmpty((Object)value)) {
            return null;
        }
        if ((value = value.trim()).startsWith("'") && value.endsWith("'")) {
            return String.class;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return String.class;
        }
        if (value.equals("true") || value.equals("false")) {
            return Boolean.class;
        }
        if (value.equals("null")) {
            return Object.class;
        }
        if (StringHelper.hasStartToken((String)value, (String)"simple")) {
            return Object.class;
        }
        boolean numeric = true;
        for (char ch : value.toCharArray()) {
            if (Character.isDigit(ch)) continue;
            numeric = false;
            break;
        }
        if (numeric) {
            return Number.class;
        }
        return null;
    }

    private static boolean isParameterMatchingType(Class<?> parameterType, Class<?> expectedType) {
        if (Number.class.equals(parameterType) && (Integer.class.isAssignableFrom(expectedType) || Long.class.isAssignableFrom(expectedType) || Integer.TYPE.isAssignableFrom(expectedType) || Long.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        if (Boolean.class.equals(parameterType) && (Boolean.class.isAssignableFrom(expectedType) || Boolean.TYPE.isAssignableFrom(expectedType))) {
            return true;
        }
        return parameterType.isAssignableFrom(expectedType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object resolveBean(CamelContext camelContext, String name, Object value) throws Exception {
        if (value.toString().startsWith("#class:")) {
            String className = value.toString().substring(7);
            String factoryMethod = null;
            String parameters = null;
            if (className.endsWith(")") && className.indexOf(40) != -1) {
                parameters = StringHelper.after((String)className, (String)"(");
                parameters = parameters.substring(0, parameters.length() - 1);
                className = StringHelper.before((String)className, (String)"(");
            }
            if (className != null && className.indexOf(35) != -1) {
                factoryMethod = StringHelper.after((String)className, (String)"#");
                className = StringHelper.before((String)className, (String)"#");
            }
            Class type = camelContext.getClassResolver().resolveMandatoryClass(className);
            if (factoryMethod != null) {
                value = parameters != null ? PropertyBindingSupport.newInstanceFactoryParameters(camelContext, type, factoryMethod, parameters) : camelContext.getInjector().newInstance(type, factoryMethod);
                if (value == null) {
                    throw new IllegalStateException("Cannot create bean instance using factory method: " + className + "#" + factoryMethod);
                }
            } else {
                value = parameters != null ? PropertyBindingSupport.newInstanceConstructorParameters(camelContext, type, parameters) : camelContext.getInjector().newInstance(type);
            }
            if (value != null) return value;
            throw new IllegalStateException("Cannot create instance of class: " + className);
        }
        if (value.toString().startsWith("#type:")) {
            String typeName = value.toString().substring(6);
            Class type = camelContext.getClassResolver().resolveMandatoryClass(typeName);
            Set types = camelContext.getRegistry().findByType(type);
            if (types.size() == 1) {
                return types.iterator().next();
            }
            if (types.size() <= 1) throw new IllegalStateException("Cannot select single type: " + typeName + " as there are no beans in the registry with this type");
            throw new IllegalStateException("Cannot select single type: " + typeName + " as there are " + types.size() + " beans in the registry with this type");
        }
        if (!value.toString().startsWith("#bean:")) return value;
        String key = value.toString().substring(6);
        return camelContext.getRegistry().lookupByName(key);
    }

    private static String undashKey(String key) {
        key = StringHelper.dashToCamelCase((String)key);
        return key;
    }

    private static final class PropertyBindingKeyComparator
    implements Comparator<String> {
        private final Map<String, Object> map;

        private PropertyBindingKeyComparator(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public int compare(String o1, String o2) {
            boolean ref2;
            int n2;
            int n1 = StringHelper.countChar((String)o1, (char)'.');
            if (n1 != (n2 = StringHelper.countChar((String)o2, (char)'.'))) {
                return Integer.compare(n1, n2);
            }
            Object v1 = this.map.get(o1);
            Object v2 = this.map.get(o2);
            boolean ref1 = v1 instanceof String && ((String)v1).startsWith("#");
            boolean bl = ref2 = v2 instanceof String && ((String)v2).startsWith("#");
            if (ref1 != ref2) {
                return Boolean.compare(ref1, ref2);
            }
            return o1.compareTo(o2);
        }
    }

    private static class FlattenMap
    extends LinkedHashMap<String, Object> {
        private final Map<String, Object> originalMap;

        public FlattenMap(Map<String, Object> map) {
            this.originalMap = map;
            this.flatten("", this.originalMap);
        }

        private void flatten(String prefix, Map<?, Object> map) {
            for (Map.Entry<?, Object> entry : map.entrySet()) {
                String key = entry.getKey().toString();
                boolean optional = key.startsWith("?");
                if (optional) {
                    key = key.substring(1);
                }
                Object value = entry.getValue();
                String keyPrefix = (optional ? "?" : "") + (prefix.isEmpty() ? key : prefix + "." + key);
                if (value instanceof Map) {
                    this.flatten(keyPrefix, (Map)value);
                    continue;
                }
                this.put(keyPrefix, value);
            }
        }

        @Override
        public Object remove(Object key) {
            String[] parts = key.toString().split("\\.");
            Map map = this.originalMap;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                Object obj = map.get(part);
                if (i == parts.length - 1) {
                    map.remove(part);
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                map = (Map)obj;
            }
            Object answer = super.remove(key);
            if (super.isEmpty()) {
                this.originalMap.clear();
            }
            return answer;
        }
    }

    private static class OptionPrefixMap
    extends LinkedHashMap<String, Object> {
        private final String optionPrefix;
        private final Map<String, Object> originalMap;

        public OptionPrefixMap(Map<String, Object> map, String optionPrefix) {
            this.originalMap = map;
            this.optionPrefix = optionPrefix;
            map.forEach((k, v) -> {
                if (StringHelper.startsWithIgnoreCase((String)k, (String)optionPrefix)) {
                    this.put(k.substring(optionPrefix.length()), v);
                } else if (StringHelper.startsWithIgnoreCase((String)k, (String)("?" + optionPrefix))) {
                    this.put(k.substring(optionPrefix.length() + 1), v);
                }
            });
        }

        @Override
        public Object remove(Object key) {
            HashSet toBeRemoved = new HashSet();
            this.originalMap.forEach((k, v) -> {
                if (StringHelper.startsWithIgnoreCase((String)k, (String)this.optionPrefix)) {
                    toBeRemoved.add(k);
                } else if (StringHelper.startsWithIgnoreCase((String)k, (String)("?" + this.optionPrefix))) {
                    toBeRemoved.add(k);
                }
            });
            toBeRemoved.forEach(this.originalMap::remove);
            return super.remove(key);
        }
    }

    public static class Builder {
        private CamelContext camelContext;
        private Object target;
        private Map<String, Object> properties;
        private boolean removeParameters = true;
        private boolean flattenProperties;
        private boolean mandatory;
        private boolean nesting = true;
        private boolean deepNesting = true;
        private boolean reference = true;
        private boolean placeholder = true;
        private boolean fluentBuilder = true;
        private boolean allowPrivateSetter = true;
        private boolean ignoreCase;
        private String optionPrefix;
        private boolean reflection = true;
        private PropertyConfigurer configurer;

        public Builder withCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
            return this;
        }

        public Builder withTarget(Object target) {
            this.target = target;
            return this;
        }

        public Builder withProperties(Map<String, Object> properties) {
            if (this.properties == null) {
                this.properties = properties;
            } else {
                this.properties.forEach(properties::putIfAbsent);
                this.properties = properties;
            }
            return this;
        }

        public Builder withProperty(String key, Object value) {
            if (this.properties == null) {
                this.properties = new LinkedHashMap<String, Object>();
            }
            this.properties.put(key, value);
            return this;
        }

        public Builder withRemoveParameters(boolean removeParameters) {
            this.removeParameters = removeParameters;
            return this;
        }

        public Builder withFlattenProperties(boolean flattenProperties) {
            this.flattenProperties = flattenProperties;
            return this;
        }

        public Builder withMandatory(boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public Builder withNesting(boolean nesting) {
            this.nesting = nesting;
            return this;
        }

        public Builder withDeepNesting(boolean deepNesting) {
            this.deepNesting = deepNesting;
            return this;
        }

        public Builder withReference(boolean reference) {
            this.reference = reference;
            return this;
        }

        public Builder withPlaceholder(boolean placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder withFluentBuilder(boolean fluentBuilder) {
            this.fluentBuilder = fluentBuilder;
            return this;
        }

        public Builder withAllowPrivateSetter(boolean allowPrivateSetter) {
            this.allowPrivateSetter = allowPrivateSetter;
            return this;
        }

        public Builder withIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            return this;
        }

        public Builder withOptionPrefix(String optionPrefix) {
            this.optionPrefix = optionPrefix;
            return this;
        }

        public Builder withConfigurer(PropertyConfigurer configurer) {
            this.configurer = configurer;
            return this;
        }

        public Builder withReflection(boolean reflection) {
            this.reflection = reflection;
            return this;
        }

        public boolean bind() {
            org.apache.camel.util.ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext");
            org.apache.camel.util.ObjectHelper.notNull((Object)this.target, (String)"target");
            if (this.properties == null || this.properties.isEmpty()) {
                return false;
            }
            return PropertyBindingSupport.doBindProperties(this.camelContext, this.target, this.removeParameters ? this.properties : new HashMap<String, Object>(this.properties), this.optionPrefix, this.ignoreCase, this.removeParameters, this.flattenProperties, this.mandatory, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.reflection, this.configurer);
        }

        public boolean bind(CamelContext camelContext, Object target, Map<String, Object> properties) {
            CamelContext context = camelContext != null ? camelContext : this.camelContext;
            Object obj = target != null ? target : this.target;
            HashMap prop = properties != null ? properties : this.properties;
            return PropertyBindingSupport.doBindProperties(context, obj, this.removeParameters ? prop : new HashMap(prop), this.optionPrefix, this.ignoreCase, this.removeParameters, this.flattenProperties, this.mandatory, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.reflection, this.configurer);
        }

        public boolean bind(CamelContext camelContext, Object target, String key, Object value) {
            HashMap<String, Object> properties = new HashMap<String, Object>(1);
            properties.put(key, value);
            return PropertyBindingSupport.doBindProperties(camelContext, target, properties, this.optionPrefix, this.ignoreCase, true, false, this.mandatory, this.nesting, this.deepNesting, this.fluentBuilder, this.allowPrivateSetter, this.reference, this.placeholder, this.reflection, this.configurer);
        }
    }

    @FunctionalInterface
    public static interface OnAutowiring {
        public void onAutowire(Object var1, String var2, Class var3, Object var4);
    }
}

