/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StaticService;
import org.apache.camel.TimerListener;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerListenerManager
extends ServiceSupport
implements Runnable,
CamelContextAware,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(TimerListenerManager.class);
    private final Set<TimerListener> listeners = new LinkedHashSet<TimerListener>();
    private CamelContext camelContext;
    private ScheduledExecutorService executorService;
    private volatile ScheduledFuture<?> task;
    private long interval = 1000L;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    @Override
    public void run() {
        LOG.trace("Running scheduled TimerListener task");
        if (!this.isRunAllowed()) {
            LOG.debug("TimerListener task cannot run as its not allowed");
            return;
        }
        for (TimerListener listener : this.listeners) {
            try {
                LOG.trace("Invoking onTimer on {}", (Object)listener);
                listener.onTimer();
            }
            catch (Throwable e) {
                LOG.debug("Error occurred during onTimer for TimerListener: {}. This exception will be ignored.", (Object)listener, (Object)e);
            }
        }
    }

    public void addTimerListener(TimerListener listener) {
        this.listeners.add(listener);
        LOG.debug("Added TimerListener: {}", (Object)listener);
    }

    public void removeTimerListener(TimerListener listener) {
        this.listeners.remove(listener);
        LOG.debug("Removed TimerListener: {}", (Object)listener);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"camelContext", (Object)this);
        this.executorService = this.camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "ManagementLoadTask");
        this.task = this.executorService.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.MILLISECONDS);
        LOG.debug("Started scheduled TimerListener task to run with interval {} ms", (Object)this.interval);
    }

    protected void doStop() throws Exception {
        if (this.task != null) {
            this.task.cancel(true);
            this.task = null;
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.camelContext.getExecutorServiceManager().shutdownNow((ExecutorService)this.executorService);
        this.executorService = null;
        this.listeners.clear();
    }
}

