/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointAware;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Service;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultEndpointUtilizationStatistics;
import org.apache.camel.support.cache.PollingConsumerServicePool;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.function.ThrowingFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConsumerCache
extends ServiceSupport
implements ConsumerCache {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConsumerCache.class);
    public static final String CONTEXT_IS_STOPPED = "CamelContext is stopped";
    private final CamelContext camelContext;
    private final PollingConsumerServicePool consumers;
    private final Object source;
    private EndpointUtilizationStatistics statistics;
    private boolean extendedStatistics;
    private final int maxCacheSize;

    public DefaultConsumerCache(Object source, CamelContext camelContext, int cacheSize) {
        this.source = source;
        this.camelContext = camelContext;
        this.maxCacheSize = cacheSize <= 0 ? CamelContextHelper.getMaximumCachePoolSize(camelContext) : cacheSize;
        this.consumers = this.createServicePool(camelContext, this.maxCacheSize);
        this.extendedStatistics = camelContext.getManagementStrategy().getManagementAgent() != null ? camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
    }

    protected PollingConsumerServicePool createServicePool(CamelContext camelContext, int cacheSize) {
        return new PollingConsumerServicePool((ThrowingFunction<Endpoint, PollingConsumer, Exception>)((ThrowingFunction)Endpoint::createPollingConsumer), EndpointAware::getEndpoint, cacheSize);
    }

    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    public void releasePollingConsumer(Endpoint endpoint, PollingConsumer pollingConsumer) {
        this.consumers.release(endpoint, (Service)pollingConsumer);
    }

    public PollingConsumer acquirePollingConsumer(Endpoint endpoint) {
        try {
            PollingConsumer consumer = (PollingConsumer)this.consumers.acquire(endpoint);
            if (this.statistics != null) {
                this.statistics.onHit(endpoint.getEndpointUri());
            }
            return consumer;
        }
        catch (Exception e) {
            throw new FailedToCreateConsumerException(endpoint, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receive(Endpoint endpoint) {
        if (this.camelContext.isStopped()) {
            throw new RejectedExecutionException(CONTEXT_IS_STOPPED);
        }
        LOG.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receive();
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receive(Endpoint endpoint, long timeout) {
        if (this.camelContext.isStopped()) {
            throw new RejectedExecutionException(CONTEXT_IS_STOPPED);
        }
        LOG.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receive(timeout);
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exchange receiveNoWait(Endpoint endpoint) {
        if (this.camelContext.isStopped()) {
            throw new RejectedExecutionException(CONTEXT_IS_STOPPED);
        }
        LOG.debug("<<<< {}", (Object)endpoint);
        PollingConsumer consumer = null;
        try {
            consumer = this.acquirePollingConsumer(endpoint);
            Exchange exchange = consumer.receiveNoWait();
            return exchange;
        }
        finally {
            if (consumer != null) {
                this.releasePollingConsumer(endpoint, consumer);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public int getCapacity() {
        return this.maxCacheSize;
    }

    public int size() {
        int size = this.consumers.size();
        LOG.trace("size = {}", (Object)size);
        return size;
    }

    public void purge() {
        this.lock.lock();
        try {
            try {
                this.consumers.stop();
                this.consumers.start();
            }
            catch (Exception e) {
                LOG.debug("Error restarting consumer pool", (Throwable)e);
            }
            if (this.statistics != null) {
                this.statistics.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void cleanUp() {
        this.consumers.cleanUp();
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.statistics;
    }

    public String toString() {
        return "ConsumerCache for source: " + String.valueOf(this.source) + ", capacity: " + this.getCapacity();
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)((Object)this.consumers));
    }

    protected void doInit() throws Exception {
        if (this.extendedStatistics) {
            int max = this.maxCacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize(this.camelContext) : this.maxCacheSize;
            this.statistics = new DefaultEndpointUtilizationStatistics(max);
        }
        ServiceHelper.initService((Object)((Object)this.consumers));
    }

    protected void doStart() throws Exception {
        if (this.statistics != null) {
            this.statistics.clear();
        }
        ServiceHelper.startService((Service)this.consumers);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Service)this.consumers);
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.consumers});
    }
}

