/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.EnumMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.clock.Clock;
import org.apache.camel.support.AbstractExchange;
import org.apache.camel.support.MonotonicClock;

public final class DefaultExchange
extends AbstractExchange {
    private final Clock timeInfo;

    DefaultExchange(CamelContext context, EnumMap<ExchangePropertyKey, Object> internalProperties, Map<String, Object> properties) {
        super(context, internalProperties, properties);
        this.timeInfo = new MonotonicClock();
    }

    public DefaultExchange(CamelContext context) {
        super(context);
        this.timeInfo = new MonotonicClock();
    }

    public DefaultExchange(CamelContext context, ExchangePattern pattern) {
        super(context, pattern);
        this.timeInfo = new MonotonicClock();
    }

    public DefaultExchange(Exchange parent) {
        super(parent);
        this.timeInfo = parent.getClock();
    }

    DefaultExchange(AbstractExchange parent) {
        super(parent);
        this.timeInfo = parent.getClock();
    }

    public Clock getClock() {
        return this.timeInfo;
    }

    @Override
    AbstractExchange newCopy() {
        return new DefaultExchange(this);
    }

    public static DefaultExchange newFromEndpoint(Endpoint fromEndpoint) {
        return DefaultExchange.newFromEndpoint(fromEndpoint, fromEndpoint.getExchangePattern());
    }

    public static DefaultExchange newFromEndpoint(Endpoint fromEndpoint, ExchangePattern exchangePattern) {
        DefaultExchange exchange = new DefaultExchange(fromEndpoint.getCamelContext(), exchangePattern);
        exchange.getExchangeExtension().setFromEndpoint(fromEndpoint);
        return exchange;
    }
}

