/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageCustomizer;

public final class CustomizersSupport {
    private CustomizersSupport() {
    }

    public static boolean isEnabled(CamelContext camelContext, String ... prefixes) {
        boolean answer = true;
        for (String prefix : prefixes) {
            String property = prefix.endsWith(".") ? prefix + "enabled" : prefix + ".enabled";
            answer = camelContext.getPropertiesComponent().resolveProperty(property).map(Boolean::valueOf).orElse(answer);
        }
        return answer;
    }

    public static final class LanguageCustomizationEnabledPolicy
    extends CamelContextAwarePolicy
    implements LanguageCustomizer.Policy {
        public boolean test(String name, Language target) {
            return CustomizersSupport.isEnabled(this.getCamelContext(), "camel.customizer", "camel.customizer.language", "camel.customizer.language." + name);
        }
    }

    public static final class DataFormatCustomizationEnabledPolicy
    extends CamelContextAwarePolicy
    implements DataFormatCustomizer.Policy {
        public boolean test(String name, DataFormat target) {
            return CustomizersSupport.isEnabled(this.getCamelContext(), "camel.customizer", "camel.customizer.dataformat", "camel.customizer.dataformat." + name);
        }
    }

    public static final class ComponentCustomizationEnabledPolicy
    extends CamelContextAwarePolicy
    implements ComponentCustomizer.Policy {
        public boolean test(String name, Component target) {
            return CustomizersSupport.isEnabled(this.getCamelContext(), "camel.customizer", "camel.customizer.component", "camel.customizer.component." + name);
        }
    }

    private static class CamelContextAwarePolicy
    implements CamelContextAware {
        private CamelContext camelContext;

        private CamelContextAwarePolicy() {
        }

        public CamelContext getCamelContext() {
            return this.camelContext;
        }

        public void setCamelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
        }
    }
}

