/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.blueprint;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.test.blueprint.CamelBlueprintHelper;
import org.apache.camel.test.junit4.CamelTestSupport;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.osgi.framework.BundleContext;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class CamelBlueprintTestSupport
extends CamelTestSupport {
    private static ThreadLocal<BundleContext> threadLocalBundleContext = new ThreadLocal();
    private volatile BundleContext bundleContext;

    protected BundleContext createBundleContext() throws Exception {
        String pid;
        String symbolicName = ((Object)((Object)this)).getClass().getSimpleName();
        BundleContext answer = CamelBlueprintHelper.createBundleContext(symbolicName, this.getBlueprintDescriptor(), true, this.getBundleFilter(), this.getBundleVersion(), this.getBundleDirectives());
        Properties extra = this.useOverridePropertiesWithPropertiesComponent();
        if (extra != null) {
            answer.registerService(PropertiesComponent.OVERRIDE_PROPERTIES, (Object)extra, null);
        }
        Properties props = new Properties();
        String[] file = this.loadConfigAdminConfigurationFile();
        if (file != null && file.length != 2) {
            throw new IllegalArgumentException("The returned String[] from loadConfigAdminConfigurationFile must be of length 2, was " + file.length);
        }
        if (file != null) {
            CamelBlueprintHelper.setPersistentFileForConfigAdmin(answer, file[1], file[0], props);
        }
        if ((pid = this.useOverridePropertiesWithConfigAdmin(props)) != null) {
            ConfigurationAdmin configAdmin = CamelBlueprintHelper.getOsgiService(answer, ConfigurationAdmin.class);
            Configuration config = configAdmin.getConfiguration(pid);
            if (config == null) {
                throw new IllegalArgumentException("Cannot find configuration with pid " + pid + " in OSGi ConfigurationAdmin service.");
            }
            this.log.info("Updating ConfigAdmin {} by overriding properties {}", (Object)config, (Object)props);
            config.update((Dictionary)props);
        }
        return answer;
    }

    @Before
    public void setUp() throws Exception {
        System.setProperty("skipStartingCamelContext", "true");
        System.setProperty("registerBlueprintCamelContextEager", "true");
        String symbolicName = ((Object)((Object)this)).getClass().getSimpleName();
        if (this.isCreateCamelContextPerClass()) {
            boolean first;
            boolean bl = first = threadLocalBundleContext.get() == null;
            if (first) {
                threadLocalBundleContext.set(this.createBundleContext());
            }
            this.bundleContext = threadLocalBundleContext.get();
        } else {
            this.bundleContext = this.createBundleContext();
        }
        super.setUp();
        this.log.debug("Staring CamelContext: {}", (Object)this.context.getName());
        this.context.start();
        this.log.debug("Waiting for BlueprintContainer to be published with symbolicName: {}", (Object)symbolicName);
        this.getOsgiService(BlueprintContainer.class, "(osgi.blueprint.container.symbolicname=" + symbolicName + ")");
    }

    protected String useOverridePropertiesWithConfigAdmin(Dictionary props) throws Exception {
        return null;
    }

    protected String[] loadConfigAdminConfigurationFile() {
        return null;
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("skipStartingCamelContext");
        System.clearProperty("registerBlueprintCamelContextEager");
        super.tearDown();
        if (this.isCreateCamelContextPerClass()) {
            return;
        }
        CamelBlueprintHelper.disposeBundleContext(this.bundleContext);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (threadLocalBundleContext.get() != null) {
            CamelBlueprintHelper.disposeBundleContext(threadLocalBundleContext.get());
            threadLocalBundleContext.remove();
        }
        CamelTestSupport.tearDownAfterClass();
    }

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected String getBlueprintDescriptor() {
        return null;
    }

    protected String getBundleFilter() {
        return "(Bundle-SymbolicName=*)";
    }

    protected String getBundleVersion() {
        return "1.0.0";
    }

    protected String getBundleDirectives() {
        return null;
    }

    protected CamelContext createCamelContext() throws Exception {
        CamelContext answer = CamelBlueprintHelper.getOsgiService(this.bundleContext, CamelContext.class);
        this.context = (ModelCamelContext)answer;
        return answer;
    }

    protected <T> T getOsgiService(Class<T> type) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type);
    }

    protected <T> T getOsgiService(Class<T> type, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, timeout);
    }

    protected <T> T getOsgiService(Class<T> type, String filter) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter);
    }

    protected <T> T getOsgiService(Class<T> type, String filter, long timeout) {
        return CamelBlueprintHelper.getOsgiService(this.bundleContext, type, filter, timeout);
    }
}

