/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailablePort {
    private static final Logger LOG = LoggerFactory.getLogger(AvailablePort.class);

    public static int probePort(InetAddress address, int port) {
        int n;
        ServerSocket ss = new ServerSocket();
        try {
            ss.setReuseAddress(true);
            ss.bind(new InetSocketAddress(address, port), 1);
            int probedPort = ss.getLocalPort();
            LOG.info("Available port is -> {}", (Object)probedPort);
            n = probedPort;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ss.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot find free port", e);
            }
        }
        ss.close();
        return n;
    }
}

