/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.test.spring;

import java.util.EventObject;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.management.event.CamelContextStoppingEvent;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.test.spring.RouteCoverageDumper;

public class RouteCoverageEventNotifier
extends EventNotifierSupport {
    private final String testClassName;
    private final Function testMethodName;

    public RouteCoverageEventNotifier(String testClassName, Function testMethodName) {
        this.testClassName = testClassName;
        this.testMethodName = testMethodName;
        this.setIgnoreCamelContextEvents(false);
        this.setIgnoreExchangeEvents(true);
    }

    public boolean isEnabled(EventObject event) {
        return event instanceof CamelContextStoppingEvent;
    }

    public void notify(EventObject event) throws Exception {
        CamelContext context = ((CamelContextStoppingEvent)event).getContext();
        String testName = (String)this.testMethodName.apply(this);
        RouteCoverageDumper.dumpRouteCoverage(context, this.testClassName, testName);
    }
}

