/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.testng;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.NoSuchElementException;

public final class AvailablePortFinder {
    public static final int MIN_PORT_NUMBER = 1100;
    public static final int MAX_PORT_NUMBER = 65535;

    private AvailablePortFinder() {
    }

    public static int getNextAvailable() {
        return AvailablePortFinder.getNextAvailable(1100);
    }

    public static int getNextAvailable(int fromPort) {
        if (fromPort < 1100 || fromPort > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + fromPort);
        }
        for (int i = fromPort; i <= 65535; ++i) {
            if (!AvailablePortFinder.available(i)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find an available port above " + fromPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        if (port < 1100 || port > 65535) {
            throw new IllegalArgumentException("Invalid start port: " + port);
        }
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

